/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.common.TasksManager;
import me.lucaaa.advanceddisplays.folia.FoliaTasksManager;
import me.lucaaa.advanceddisplays.managers.PlayerPacketManager;
import me.lucaaa.advanceddisplays.nms_common.Logger;
import me.lucaaa.advanceddisplays.nms_common.PacketException;
import me.lucaaa.advanceddisplays.nms_common.PacketInterface;
import me.lucaaa.advanceddisplays.spigot.SpigotTasksManager;
import org.bukkit.entity.Player;

public class VersionManager {
    private final PacketsManager packetsManager;
    private final TasksManager tasksManager;
    private static final String TAIL_CONTEXT_IDENTIFIER = "DefaultChannelPipeline$TailContext#0";

    public VersionManager(AdvancedDisplays plugin) {
        this.packetsManager = new PacketsManager(plugin);
        if (this.isFolia()) {
            plugin.log(Level.INFO, "Using the Folia tasks manager.");
            this.tasksManager = new FoliaTasksManager();
        } else {
            plugin.log(Level.INFO, "Using the Paper/Spigot tasks manager.");
            this.tasksManager = new SpigotTasksManager();
        }
    }

    public PacketsManager getPacketsManager() {
        return this.packetsManager;
    }

    public TasksManager getTasksManager() {
        return this.tasksManager;
    }

    private boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static class PacketsManager {
        private final AdvancedDisplays plugin;
        private final PacketInterface packets;

        public PacketsManager(AdvancedDisplays plugin) {
            this.plugin = plugin;
            try {
                Class<?> nmsClass = Class.forName("me.lucaaa.advanceddisplays." + plugin.getNmsVersion().name() + ".Packets");
                Object nmsClassInstance = nmsClass.getConstructor(Logger.class).newInstance(plugin);
                this.packets = (PacketInterface)nmsClassInstance;
                this.addAll();
                plugin.log(Level.INFO, "Using the PacketsManager for NMS version " + plugin.getNmsVersion().name());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        public PacketInterface getPackets() {
            return this.packets;
        }

        public void add(Player player) {
            this.playerPipelineOperation(player, pipeline -> {
                block3: {
                    if (pipeline.get("ad_packet_manager") != null) {
                        pipeline.remove("ad_packet_manager");
                    }
                    try {
                        pipeline.addBefore("packet_handler", "ad_packet_manager", (ChannelHandler)new PlayerPacketManager(this.plugin, player));
                    }
                    catch (NoSuchElementException e) {
                        String firstName;
                        String string = firstName = pipeline.names().isEmpty() ? null : (String)pipeline.names().get(0);
                        if (VersionManager.TAIL_CONTEXT_IDENTIFIER.equals(firstName)) break block3;
                        throw e;
                    }
                }
            });
        }

        public void addAll() {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.add(player);
            }
        }

        public void remove(Player player) {
            this.playerPipelineOperation(player, pipeline -> {
                if (pipeline.get("ad_packet_manager") != null) {
                    pipeline.remove("ad_packet_manager");
                }
            });
        }

        public void removeAll() {
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                this.remove(player);
            }
        }

        private void playerPipelineOperation(Player player, Consumer<ChannelPipeline> operation) {
            try {
                ChannelPipeline pipeline = this.packets.getPlayerPipeline(player);
                if (pipeline == null) {
                    this.plugin.logError(Level.WARNING, "Player pipeline is null for player \"" + player.getName() + "\".", new PacketException("Missing pipeline"));
                    return;
                }
                EventLoop eventLoop = pipeline.channel().eventLoop();
                if (eventLoop.inEventLoop()) {
                    operation.accept(pipeline);
                } else {
                    eventLoop.execute(() -> this.playerPipelineOperation(player, operation));
                }
            }
            catch (Exception e) {
                this.plugin.logError(Level.WARNING, "An error occurred while executing an operation on a player's pipeline! Player: " + player.getName(), e);
            }
        }
    }
}

