/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.common.ITask;
import me.lucaaa.advanceddisplays.data.Ticking;
import org.bukkit.plugin.Plugin;

public class TickManager {
    private final AdvancedDisplays plugin;
    private final List<Ticking> ticking = new CopyOnWriteArrayList<Ticking>();
    private ITask task;
    private final AtomicBoolean isTicking = new AtomicBoolean(false);
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);

    public TickManager(AdvancedDisplays plugin) {
        this.plugin = plugin;
        this.start();
    }

    private void start() {
        this.task = this.plugin.getTasksManager().runTaskTimerAsynchronously((Plugin)this.plugin, this::tick, 0L, 1L);
    }

    public void stop() {
        this.isCancelled.set(true);
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.ticking.clear();
    }

    public void addTicking(Ticking ticked) {
        this.ticking.add(ticked);
    }

    public void removeTicking(Ticking ticked) {
        this.ticking.remove(ticked);
    }

    private void tick() {
        if (this.isCancelled.get() || !this.isTicking.compareAndSet(false, true)) {
            return;
        }
        for (Ticking ticked : this.ticking) {
            try {
                ticked.tick();
            }
            catch (Exception e) {
                this.ticking.remove(ticked);
                this.plugin.logError(Level.SEVERE, "An error occurred while ticking a display: ", e);
            }
        }
        this.isTicking.set(false);
    }
}

