/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import java.util.HashMap;
import java.util.Map;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.data.PlayerData;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import org.bukkit.entity.Player;

public class PlayersManager {
    private final AdvancedDisplays plugin;
    private final Map<Player, PlayerData> playersData = new HashMap<Player, PlayerData>();

    public PlayersManager(AdvancedDisplays plugin) {
        this.plugin = plugin;
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            this.playersData.put(player, new PlayerData(player, plugin));
        }
    }

    public void addPlayer(Player player) {
        if (!this.playersData.containsKey(player)) {
            this.playersData.put(player, new PlayerData(player, this.plugin));
        }
    }

    public void removePlayer(Player player) {
        PlayerData playerData = this.playersData.remove(player);
        playerData.stopRunnables();
        if (playerData.isEditing()) {
            playerData.finishEditing();
        }
    }

    public PlayerData getPlayerData(Player player) {
        return this.playersData.get(player);
    }

    public void resetDisplay(Player player, ADTextDisplay display) {
        PlayerData playerData = this.playersData.get(player);
        if (playerData == null) {
            return;
        }
        playerData.stopRunnable(display);
    }

    public void removeAll() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.removePlayer(player);
        }
    }

    public void handleDisplayRemoval(BaseEntity display) {
        for (PlayerData player : this.playersData.values()) {
            if (player.getEditingDisplay() == display) {
                player.finishEditing();
            }
            if (!(display instanceof ADTextDisplay)) continue;
            ADTextDisplay textDisplay = (ADTextDisplay)display;
            player.stopRunnable(textDisplay);
        }
    }
}

