/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.nms_common.InternalEntityClickEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class PlayerPacketManager
extends ChannelDuplexHandler {
    private final AdvancedDisplays plugin;
    public static final String IDENTIFIER = "ad_packet_manager";
    private final Player player;
    private boolean pastInteraction = false;

    public PlayerPacketManager(AdvancedDisplays plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void channelRead(ChannelHandlerContext ctx, Object packet) throws Exception {
        ADBaseEntity display;
        super.channelRead(ctx, packet);
        InternalEntityClickEvent clickEvent = this.plugin.getPacketsManager().getPackets().getClickEvent(this.player, packet);
        if (clickEvent == null) {
            return;
        }
        ClickType clickType = clickEvent.clickType();
        if (clickType == ClickType.RIGHT || clickType == ClickType.SHIFT_RIGHT) {
            if (this.pastInteraction) {
                this.pastInteraction = false;
                return;
            }
            this.pastInteraction = true;
        }
        if ((display = this.plugin.getInteractionsManager().getDisplay(clickEvent.interactionId())) == null) {
            return;
        }
        this.plugin.getTasksManager().runTask((Plugin)this.plugin, () -> display.runActions(this.player, clickType));
    }
}

