/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.data.PlayerData;
import me.lucaaa.advanceddisplays.inventory.ADInventory;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.PlayersManager;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;

public class InventoryManager {
    private final PlayersManager playersManager;
    private final List<EditorItem> disabledItems = new ArrayList<EditorItem>();
    private final Map<Player, ADInventory> openGUIs = new HashMap<Player, ADInventory>();

    public InventoryManager(AdvancedDisplays plugin, ConfigManager mainConfig) {
        this.playersManager = plugin.getPlayersManager();
        if (!mainConfig.getConfig().isList("disabledItems")) {
            mainConfig.getConfig().set("disabledItems", List.of());
            mainConfig.getConfig().setComments("disabledItems", List.of(" List of disabled settings in the editor menu. Visit the link below for a list of settings that can be disabled.", "https://javadoc.jitpack.io/com/github/Luncaaa/AdvancedDisplays/main-SNAPSHOT/javadoc/me/lucaaa/advanceddisplays/api/displays/enums/EditorItem.html"));
            mainConfig.save();
        } else {
            for (String item : mainConfig.getConfig().getStringList("disabledItems")) {
                try {
                    EditorItem disabledItem = EditorItem.valueOf(item.toUpperCase());
                    this.disabledItems.add(disabledItem);
                }
                catch (IllegalArgumentException exception) {
                    plugin.log(Level.WARNING, "Invalid item found in the \"disabledItems\" section in the config.yml file: " + item);
                }
            }
        }
    }

    public void handleOpen(Player player, ADInventory gui) {
        gui.onOpen();
        player.openInventory(gui.getInventory());
        this.openGUIs.put(player, gui);
    }

    public void handleClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null || event.getClickedInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.openGUIs.containsKey(player)) {
            return;
        }
        this.openGUIs.get(player).onClick(event);
    }

    public void handleClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (!this.openGUIs.containsKey(player) || !event.getInventory().equals((Object)this.openGUIs.get(player).getInventory())) {
            return;
        }
        if (this.playersManager.getPlayerData(player).isChatEditing()) {
            return;
        }
        this.openGUIs.remove(player).onClose(player);
    }

    public void onQuit(Player player) {
        this.openGUIs.remove(player);
    }

    public void handleChatEdit(Player player, String input) {
        PlayerData playerData = this.playersManager.getPlayerData(player);
        if (!playerData.isChatEditing()) {
            return;
        }
        ADInventory openGUI = this.openGUIs.get(player);
        boolean stopChatEditing = openGUI.handleChatEdit(player, input);
        if (stopChatEditing) {
            playerData.setChatEditing(false);
            this.handleOpen(player, openGUI);
        }
    }

    public void clearAll() {
        for (Player player : this.openGUIs.keySet()) {
            player.closeInventory();
        }
        this.openGUIs.clear();
    }

    public List<EditorItem> getDisabledItems() {
        return this.disabledItems;
    }
}

