/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import java.util.HashMap;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;

public class InteractionsManager {
    private final HashMap<Integer, ADBaseEntity> displaysMap = new HashMap();
    private final HashMap<Integer, ADBaseEntity> apiDisplaysMap;

    public InteractionsManager(HashMap<Integer, ADBaseEntity> apiDisplaysMap) {
        this.apiDisplaysMap = apiDisplaysMap;
    }

    public void addInteraction(int interactionId, ADBaseEntity display) {
        if (display.isApi()) {
            this.apiDisplaysMap.put(interactionId, display);
        } else {
            this.displaysMap.put(interactionId, display);
        }
    }

    public void removeInteraction(int interactionId) {
        this.displaysMap.remove(interactionId);
        this.apiDisplaysMap.remove(interactionId);
    }

    public ADBaseEntity getDisplay(int interactionId) {
        if (this.displaysMap.get(interactionId) != null) {
            return this.displaysMap.get(interactionId);
        }
        return this.apiDisplaysMap.get(interactionId);
    }

    public HashMap<Integer, ADBaseEntity> getApiDisplays() {
        return this.apiDisplaysMap;
    }
}

