/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import java.util.HashMap;
import java.util.Map;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.ItemDisplay;
import me.lucaaa.advanceddisplays.common.ITask;
import me.lucaaa.advanceddisplays.data.DisplayHeadType;
import me.lucaaa.advanceddisplays.data.HeadUtils;
import me.lucaaa.advanceddisplays.displays.ADItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HeadCacheManager {
    private final AdvancedDisplays plugin;
    private final Map<ItemDisplay, ITask> tasks = new HashMap<ItemDisplay, ITask>();
    public final ItemStack CANCEL = this.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmViNTg4YjIxYTZmOThhZDFmZjRlMDg1YzU1MmRjYjA1MGVmYzljYWI0MjdmNDYwNDhmMThmYzgwMzQ3NWY3In19fQ==");
    public final ItemStack DONE = this.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDMxMmNhNDYzMmRlZjVmZmFmMmViMGQ5ZDdjYzdiNTVhNTBjNGUzOTIwZDkwMzcyYWFiMTQwNzgxZjVkZmJjNCJ9fX0=");
    public final ItemStack LOADING = this.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmVlMTc0ZjQxZTU5NGU2NGVhMzE0MWMwN2RhZjdhY2YxZmEwNDVjMjMwYjJiMGIwZmIzZGExNjNkYjIyZjQ1NSJ9fX0=");
    public final ItemStack ADD = this.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZmMzE0MzFkNjQ1ODdmZjZlZjk4YzA2NzU4MTA2ODFmOGMxM2JmOTZmNTFkOWNiMDdlZDc4NTJiMmZmZDEifX19");
    public final ItemStack LEFT = this.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTM5NzExMjRiZTg5YWM3ZGM5YzkyOWZlOWI2ZWZhN2EwN2NlMzdjZTFkYTJkZjY5MWJmODY2MzQ2NzQ3N2M3In19fQ==");
    public final ItemStack RIGHT = this.getHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjY3MWM0YzA0MzM3YzM4YTVjN2YzMWE1Yzc1MWY5OTFlOTZjMDNkZjczMGNkYmVlOTkzMjA2NTVjMTlkIn19fQ==");

    public HeadCacheManager(AdvancedDisplays plugin) {
        this.plugin = plugin;
    }

    public void loadHead(ADItemDisplay display, DisplayHeadType type, String value) {
        ITask task = this.plugin.getTasksManager().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ItemStack head = type == DisplayHeadType.PLAYER ? HeadUtils.getPlayerHead(value, this.plugin) : HeadUtils.getBase64Head(value, this.plugin);
            display.setHead(head);
            this.tasks.remove(display);
        });
        this.tasks.put(display, task);
    }

    public void cancelTask(ItemDisplay display) {
        if (this.tasks.containsKey(display)) {
            this.tasks.get(display).cancel();
        }
        this.tasks.remove(display);
    }

    public void shutdown() {
        for (ITask task : this.tasks.values()) {
            task.cancel();
        }
        this.tasks.clear();
    }

    private ItemStack getHead(String base64) {
        return HeadUtils.getBase64Head(base64, this.plugin);
    }
}

