/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.data.AttachedDisplay;
import me.lucaaa.advanceddisplays.displays.ADBaseDisplay;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.displays.ADBlockDisplay;
import me.lucaaa.advanceddisplays.displays.ADEntityDisplay;
import me.lucaaa.advanceddisplays.displays.ADItemDisplay;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.ConversionManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import shaded.net.kyori.adventure.text.Component;

public class DisplaysManager {
    private final AdvancedDisplays plugin;
    private final String pluginName;
    private final String configsFolder;
    private final boolean isApi;
    private final Map<String, ADBaseEntity> displays = new HashMap<String, ADBaseEntity>();
    private final Map<Player, AttachedDisplay> attachDisplays = new HashMap<Player, AttachedDisplay>();
    public static final List<EntityType> FORBIDDEN_ENTITIES = List.of(EntityType.EVOKER_FANGS, EntityType.UNKNOWN, EntityType.EXPERIENCE_ORB, EntityType.FALLING_BLOCK, EntityType.FIREWORK, EntityType.INTERACTION, EntityType.DROPPED_ITEM, EntityType.LIGHTNING, EntityType.LLAMA_SPIT, EntityType.MARKER, EntityType.PRIMED_TNT, EntityType.FISHING_HOOK, EntityType.BLOCK_DISPLAY, EntityType.ITEM_DISPLAY, EntityType.TEXT_DISPLAY, EntityType.PLAYER);
    private int failedLoads = 0;

    public DisplaysManager(AdvancedDisplays plugin, String pluginName, boolean createFolders, boolean isApi) {
        this.plugin = plugin;
        this.pluginName = pluginName;
        this.configsFolder = isApi ? "displays" + File.separator + pluginName : "displays";
        this.isApi = isApi;
        File displaysFolder = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + this.configsFolder);
        if (!displaysFolder.exists() && createFolders) {
            displaysFolder.mkdirs();
        }
        if (displaysFolder.exists()) {
            for (File configFile : Objects.requireNonNull(displaysFolder.listFiles())) {
                if (configFile.isDirectory()) continue;
                ConfigManager configManager = new ConfigManager(plugin, this.configsFolder + File.separator + configFile.getName(), false);
                if (!configManager.getConfig().isConfigurationSection("entity")) {
                    ConversionManager.setConversionNeeded(plugin, true);
                    break;
                }
                this.loadDisplay(configManager);
            }
        }
        String message = "Loaded " + this.displays.size() + " display(s)";
        if (isApi) {
            message = message + " for plugin \"" + pluginName + "\"";
        }
        plugin.log(Level.INFO, message);
    }

    public ADTextDisplay createAttachedDisplay(PlayerInteractEvent event, AttachedDisplay display) {
        Location location;
        if (event.getClickedBlock() == null) {
            return null;
        }
        Player player = event.getPlayer();
        BlockFace clickedFace = event.getBlockFace();
        float yaw = clickedFace == BlockFace.UP || clickedFace == BlockFace.DOWN ? AttachedDisplay.getYaw(player.getFacing().getOppositeFace()) : AttachedDisplay.getYaw(clickedFace);
        float pitch = 0.0f;
        if (clickedFace == BlockFace.UP) {
            pitch = -90.0f;
        } else if (clickedFace == BlockFace.DOWN) {
            pitch = 90.0f;
        }
        if (clickedFace == BlockFace.UP || clickedFace == BlockFace.DOWN) {
            double addY = clickedFace == BlockFace.UP ? 1.001 : -0.001;
            boolean add = clickedFace == BlockFace.UP;
            Location loc = event.getClickedBlock().getLocation().clone().add(0.0, addY, 0.0);
            float pos = AttachedDisplay.getPos(player.getFacing().getOppositeFace(), display.side());
            location = AttachedDisplay.addSides(player.getFacing(), loc, pos, add);
        } else {
            float pos = AttachedDisplay.getPos(clickedFace, display.side());
            location = AttachedDisplay.addSides(clickedFace, event.getClickedBlock().getLocation(), pos, false);
        }
        ADTextDisplay newDisplay = (ADTextDisplay)this.createDisplay(DisplayType.TEXT, location, display.name(), display.content(), display.saveToConfig());
        if (newDisplay != null) {
            newDisplay.setBillboard(Display.Billboard.FIXED);
            newDisplay.setSeeThrough(false);
            newDisplay.setRotation(yaw, pitch);
        }
        return newDisplay;
    }

    public ADBaseEntity createDisplay(DisplayType type, Location location, String name, Object value, boolean saveToConfig) {
        if (this.displays.containsKey(name)) {
            return null;
        }
        ADBaseEntity display = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DisplayType.BLOCK -> new ADBlockDisplay(this.plugin, this, name, location, saveToConfig).create((BlockData)value);
            case DisplayType.ENTITY -> new ADEntityDisplay(this.plugin, this, name, location, (EntityType)value, saveToConfig).create();
            case DisplayType.ITEM -> new ADItemDisplay(this.plugin, this, name, location, saveToConfig).create((Material)value);
            case DisplayType.TEXT -> {
                ADTextDisplay textDisplay = new ADTextDisplay(this.plugin, this, name, location, saveToConfig);
                if (value instanceof Component) {
                    yield textDisplay.create((Component)value);
                }
                yield textDisplay.create((String)value);
            }
        };
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            display.sendMetadataPackets(onlinePlayer);
        }
        this.plugin.getInteractionsManager().addInteraction(display.getInteractionId(), display);
        this.displays.put(name, display);
        return display;
    }

    public boolean removeDisplay(String name) {
        if (!this.displays.containsKey(name)) {
            return false;
        }
        this.removeDisplay(this.displays.get(name), true, true);
        return true;
    }

    public void removeDisplay(ADBaseEntity display, boolean deleteFile, boolean removeFromList) {
        if (display.getConfigManager() != null && deleteFile) {
            display.getConfigManager().getFile().delete();
        }
        if (display instanceof ADTextDisplay) {
            ADTextDisplay textDisplay = (ADTextDisplay)display;
            textDisplay.stopRunnable();
        }
        display.destroy();
        this.plugin.getPlayersManager().handleDisplayRemoval(display);
        if (removeFromList) {
            this.displays.remove(display.getName());
        }
        display.setRemoved();
    }

    public void removeAll(boolean onReload) {
        for (ADBaseEntity display : this.displays.values()) {
            this.removeDisplay(display, !onReload, false);
        }
        this.attachDisplays.clear();
    }

    public ADBaseEntity getDisplayFromMap(String name) {
        return this.displays.get(name);
    }

    public void spawnDisplays(Player player) {
        for (ADBaseEntity display : this.displays.values()) {
            if (display.getLocation().getWorld() != player.getLocation().getWorld() || !display.getVisibilityManager().isVisibleByPlayer(player)) continue;
            display.spawnToPlayer(player);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadDisplay(ConfigManager configManager) {
        ADBaseDisplay newDisplay;
        Iterator iterator;
        DisplayType displayType;
        String name = Files.getNameWithoutExtension((String)configManager.getFile().getName());
        if (!this.hasValidLocation(name, configManager)) {
            ++this.failedLoads;
            return;
        }
        String configDisplayType = configManager.getConfig().getString("type");
        if (configDisplayType == null) {
            this.plugin.log(Level.WARNING, this.getMessage(name, "does not have a display type set!"));
            ++this.failedLoads;
            return;
        }
        try {
            displayType = DisplayType.valueOf(configDisplayType);
        }
        catch (IllegalArgumentException e) {
            this.plugin.log(Level.WARNING, this.getMessage(name, "has an invalid display type set: " + configDisplayType));
            ++this.failedLoads;
            return;
        }
        switch (displayType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BLOCK: {
                iterator = new ADBlockDisplay(this.plugin, this, configManager, name);
                ADBaseDisplay aDBaseDisplay = iterator;
                break;
            }
            case TEXT: {
                iterator = new ADTextDisplay(this.plugin, this, configManager, name);
                ADBaseDisplay aDBaseDisplay = iterator;
                break;
            }
            case ITEM: {
                iterator = new ADItemDisplay(this.plugin, this, configManager, name);
                ADBaseDisplay aDBaseDisplay = iterator;
                break;
            }
            case ENTITY: {
                ADBaseDisplay aDBaseDisplay;
                String configType = configManager.getSection("entity").getString("type");
                if (configType == null) {
                    this.plugin.log(Level.WARNING, this.getMessage(name, "does not have an entity type set!"));
                    iterator = null;
                    aDBaseDisplay = iterator;
                    break;
                }
                try {
                    EntityType entityType = EntityType.valueOf((String)configType);
                    if (FORBIDDEN_ENTITIES.contains(entityType)) {
                        this.plugin.log(Level.WARNING, this.getMessage(name, "cannot be of entity type: " + configType));
                        iterator = null;
                        aDBaseDisplay = iterator;
                        break;
                    }
                    iterator = new ADEntityDisplay(this.plugin, this, configManager, name, entityType);
                    aDBaseDisplay = iterator;
                }
                catch (IllegalArgumentException e) {
                    this.plugin.log(Level.WARNING, this.getMessage(name, "has an invalid entity type set: " + configType));
                    iterator = null;
                    aDBaseDisplay = newDisplay = iterator;
                }
            }
        }
        if (newDisplay == null) {
            ++this.failedLoads;
            return;
        }
        if (newDisplay.hasErrorsOnLoad()) {
            this.plugin.log(Level.WARNING, "The display \"" + name + "\" for plugin \"" + this.pluginName + "\" registered the following errors:");
            iterator = newDisplay.getErrors().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    ++this.failedLoads;
                    return;
                }
                String error = (String)iterator.next();
                this.plugin.log(Level.WARNING, error);
            }
        }
        this.displays.put(configManager.getFile().getName().replace(".yml", ""), newDisplay);
        iterator = this.plugin.getServer().getOnlinePlayers().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.plugin.getInteractionsManager().addInteraction(((ADBaseEntity)newDisplay).getInteractionId(), newDisplay);
                return;
            }
            Player onlinePlayer = (Player)iterator.next();
            ((ADBaseEntity)newDisplay).sendMetadataPackets(onlinePlayer);
        }
    }

    public BaseEntity getDisplayFromLoc(Location location, double radius, boolean closest) {
        double closestDistance = Math.pow(radius, 2.0);
        BaseEntity closestDisplay = null;
        for (BaseEntity baseEntity : this.displays.values()) {
            boolean isInRadius;
            double distanceSquared = baseEntity.getLocation().distanceSquared(location);
            boolean bl = isInRadius = distanceSquared <= Math.pow(radius, 2.0);
            if (closest && isInRadius) {
                if (!(closestDistance > distanceSquared)) continue;
                closestDistance = distanceSquared;
                closestDisplay = baseEntity;
                continue;
            }
            if (!isInRadius) continue;
            return baseEntity;
        }
        return closestDisplay;
    }

    public void addAttachingPlayer(Player player, AttachedDisplay display) {
        this.attachDisplays.put(player, display);
    }

    public boolean isPlayerAttaching(Player player) {
        return this.attachDisplays.containsKey(player);
    }

    public AttachedDisplay getAttachingDisplay(Player player) {
        return this.attachDisplays.remove(player);
    }

    public void removeAttachingDisplay(Player player) {
        this.attachDisplays.remove(player);
    }

    public Map<String, ADBaseEntity> getDisplays() {
        return this.displays;
    }

    public boolean existsDisplay(String name) {
        return this.displays.containsKey(name);
    }

    public String getConfigsFolder() {
        return this.configsFolder;
    }

    public boolean isApi() {
        return this.isApi;
    }

    private boolean hasValidLocation(String name, ConfigManager configManager) {
        String world;
        ArrayList<Object> errors = new ArrayList<Object>();
        YamlConfiguration config = configManager.getConfig();
        ConfigurationSection locationSection = config.getConfigurationSection("location");
        if (locationSection == null) {
            errors.add("Missing \"location\" section. An empty one has been created for you.");
            locationSection = config.createSection("location");
            configManager.save();
        }
        if ((world = locationSection.getString("world")) == null) {
            errors.add("Missing \"world\" field.");
        } else if (this.plugin.getServer().getWorld(world) == null) {
            errors.add("Invalid \"world\" field - World not found: " + world);
        }
        for (String field : List.of("x", "y", "z")) {
            if (locationSection.isDouble(field)) continue;
            errors.add("Missing \"" + field + "\" field or invalid type - must be a double.");
        }
        if (!errors.isEmpty()) {
            this.plugin.log(Level.WARNING, "=".repeat(25));
            this.plugin.log(Level.SEVERE, this.getMessage(name, "has an invalid location:"));
            errors.forEach(error -> this.plugin.log(Level.WARNING, (String)error));
            this.plugin.log(Level.WARNING, "=".repeat(25));
        }
        return errors.isEmpty();
    }

    private String getMessage(String name, String message) {
        return "The display \"" + name + "\" for plugin \"" + this.pluginName + "\" " + message;
    }

    public int getFailedLoads() {
        return this.failedLoads;
    }
}

