/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.managers;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final AdvancedDisplays plugin;
    private final File file;
    private final YamlConfiguration config;

    public ConfigManager(AdvancedDisplays plugin, String path, boolean createIfNotExists) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + path);
        if (!this.file.exists() && createIfNotExists) {
            plugin.saveResource(path, false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public ConfigurationSection getSection(String name) {
        return this.getSection(name, true, (ConfigurationSection)this.config);
    }

    public ConfigurationSection getSection(String name, ConfigurationSection parent) {
        return this.getSection(name, true, parent);
    }

    public ConfigurationSection getSection(String name, boolean createIfNotExists, ConfigurationSection parent) {
        ConfigurationSection section = parent.getConfigurationSection(name);
        if (section == null && createIfNotExists) {
            section = parent.createSection(name);
            this.save();
            this.plugin.log(Level.WARNING, "Missing section \"" + name + "\" in \"" + this.file.getName() + "\" file! Created an empty section.");
        }
        return section;
    }

    public <T> T getOrDefault(String setting, T def, ConfigurationSection section) {
        if (!section.contains(setting)) {
            this.plugin.log(Level.WARNING, "Missing setting \"" + setting + "\" in \"" + this.file.getName() + "\" file! Setting to default value: " + String.valueOf(def));
            section.set(setting, def);
            this.save();
            return def;
        }
        Object data = section.get(setting);
        Class<?> clazz = def.getClass();
        if (!clazz.isInstance(data)) {
            this.plugin.log(Level.WARNING, "Setting \"" + setting + "\" is not a \"" + clazz.getSimpleName() + "\" value in \"" + this.file.getName() + "\" file! Setting to default value: " + String.valueOf(def));
            return def;
        }
        return (T)clazz.cast(data);
    }
}

