/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.lucaaa.advanceddisplays.data.NamedEnum;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.inventory.items.EditorItems;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Item<T> {
    protected ItemStack item;
    protected final String title;
    protected final ArrayList<String> lore;
    protected final boolean changeTitle;
    protected T value;

    protected Item(Material material, String title, List<String> lore, T initialValue, boolean changeTitle) {
        this(new ItemStack(material), title, lore, initialValue, changeTitle);
    }

    protected Item(ItemStack item, String title, List<String> lore, T value, boolean changeTitle) {
        this.item = item;
        this.title = title;
        this.lore = new ArrayList<String>(lore);
        this.changeTitle = changeTitle;
        this.value = value;
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            Utils.hideFlags(meta);
        }
        item.setItemMeta(meta);
        this.setMeta(title, lore);
    }

    protected void setMeta(String title, List<String> lore) {
        ItemStack clone = this.item.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.setDisplayName(Utils.getColoredText("&6" + title));
        meta.setLore(lore.stream().map(line -> Utils.getColoredText("&e" + line)).toList());
        clone.setItemMeta(meta);
        this.item = clone;
    }

    public void applyMeta(ItemMeta meta) {
        ItemStack clone = this.item.clone();
        ItemMeta cloneMeta = clone.getItemMeta();
        if (cloneMeta == null) {
            return;
        }
        meta.setDisplayName(cloneMeta.getDisplayName());
        meta.setLore(cloneMeta.getLore());
        clone.setItemMeta(meta);
        this.item = clone;
    }

    public void setLore(List<String> lore) {
        this.lore.clear();
        this.lore.addAll(lore);
        this.setMeta(this.title, lore);
    }

    public void disable(List<String> reason) {
        this.lore.add("");
        this.lore.add(String.valueOf(net.md_5.bungee.api.ChatColor.RED) + String.valueOf(net.md_5.bungee.api.ChatColor.BOLD) + "Setting disabled!");
        this.lore.add(String.valueOf(net.md_5.bungee.api.ChatColor.GRAY) + "You won't be able to change it");
        this.lore.add(String.valueOf(net.md_5.bungee.api.ChatColor.DARK_GRAY) + "Reason:");
        if (reason.isEmpty()) {
            this.lore.add(String.valueOf(net.md_5.bungee.api.ChatColor.DARK_GRAY) + String.valueOf(net.md_5.bungee.api.ChatColor.ITALIC) + "Disabled by plugin");
        } else {
            for (String line : reason) {
                this.lore.add(String.valueOf(net.md_5.bungee.api.ChatColor.DARK_GRAY) + String.valueOf(net.md_5.bungee.api.ChatColor.ITALIC) + line);
            }
        }
        this.lore.add("");
        this.setValue(this.value);
    }

    public ItemStack getStack() {
        return this.item;
    }

    public void setValue(T value) {
        this.value = value;
        Object title = this.title;
        ArrayList<String> newLore = new ArrayList<String>(this.lore);
        if (value != null) {
            Object parsedValue = value.toString();
            if (value instanceof NamedEnum) {
                NamedEnum namedEnum = (NamedEnum)value;
                parsedValue = namedEnum.getName();
            } else if (value instanceof ChatColor) {
                ChatColor color = (ChatColor)value;
                parsedValue = String.valueOf(color) + color.name();
            } else if (value instanceof Keyed) {
                Keyed keyed = (Keyed)value;
                parsedValue = keyed.getKey().getKey();
            } else if (value instanceof Double && ((String)(parsedValue = String.valueOf(Utils.round((Double)value)))).contains(".")) {
                String beforeDecimal = ((String)parsedValue).split("\\.")[0];
                String afterDecimal = ((String)parsedValue).split("\\.")[1];
                parsedValue = beforeDecimal + "." + (afterDecimal = afterDecimal.replaceAll("0+$", ""));
                if (((String)parsedValue).endsWith(".")) {
                    parsedValue = ((String)parsedValue).replace(".", "");
                }
            }
            newLore.add("&9Current value: &7" + (String)parsedValue);
            if (this.changeTitle) {
                title = (String)title + ": &e" + (String)parsedValue;
            }
        }
        this.setMeta((String)title, newLore);
    }

    public Object getValue() {
        return this.value;
    }

    public static class RegistryItem
    extends Item<Keyed> {
        private final boolean canBeNone;
        private boolean isNone;

        public RegistryItem(Material material, String title, Keyed initialValue) {
            this(material, title, List.of(), initialValue, false, false);
        }

        public RegistryItem(Material material, String title, List<String> baseLore, Keyed initialValue, boolean canBeNone, boolean startNone) {
            super(material, title, baseLore, initialValue, false);
            this.canBeNone = canBeNone;
            this.isNone = canBeNone && startNone;
            this.lore.add("");
            this.lore.add("&7Click to change");
            this.lore.add("");
            if (this.isNone) {
                this.setValueNone();
            } else {
                this.setValue((Keyed)this.value);
            }
        }

        private void setValueNone() {
            ArrayList<String> newLore = new ArrayList<String>(this.lore);
            newLore.add("&9Current value: &7NONE");
            this.setMeta(this.title, newLore);
        }

        public Keyed changeValue() {
            Class<?> clazz = ((Keyed)this.value).getClass();
            for (Class<?> interfaceClass : ((Keyed)this.value).getClass().getInterfaces()) {
                if (!Keyed.class.isAssignableFrom(interfaceClass) || interfaceClass == Keyed.class) continue;
                clazz = interfaceClass;
            }
            Registry registry = Objects.requireNonNull(Bukkit.getRegistry((Class)clazz));
            Iterator iterator = registry.iterator();
            Keyed first = null;
            boolean foundCurrent = false;
            while (iterator.hasNext() && (!this.isNone || first == null)) {
                Keyed registryValue = (Keyed)iterator.next();
                if (first == null) {
                    first = registryValue;
                }
                if (foundCurrent) {
                    this.setValue(registryValue);
                    return registryValue;
                }
                if (!registryValue.equals(this.value)) continue;
                foundCurrent = true;
            }
            if (this.isNone) {
                this.isNone = false;
                this.setValue(first);
                return first;
            }
            if (this.canBeNone) {
                this.isNone = true;
                this.value = first;
                this.setValueNone();
                return null;
            }
            this.setValue(first);
            return first;
        }
    }

    public static class ClickableItem
    extends Item<String> {
        public ClickableItem(Material material, String title, String lore) {
            this(material, title, List.of(lore), null);
        }

        public ClickableItem(Material material, String title, String lore, String value) {
            this(material, title, List.of(lore), value);
        }

        public ClickableItem(Material material, String title, List<String> baseLore, String value) {
            super(material, title, baseLore, value, false);
            this.lore.add("");
            this.setValue(value);
        }

        public ClickableItem(ItemStack item, String title, List<String> baseLore, String value) {
            super(item, title, baseLore, value, false);
            this.lore.add("");
            this.setValue(value);
        }
    }

    public static class EnumItem<T extends Enum<T>>
    extends Item<T> {
        public EnumItem(Material material, String title, String lore, T initialValue) {
            this(material, title, List.of(lore), initialValue, false);
        }

        public EnumItem(Material material, String title, List<String> baseLore, T initialValue, boolean changeTitle) {
            this(new ItemStack(material), title, baseLore, initialValue, changeTitle);
        }

        public EnumItem(ItemStack item, String title, List<String> baseLore, T initialValue, boolean changeTitle) {
            super(item, title, baseLore, initialValue, changeTitle);
            this.lore.add("");
            this.lore.add("&7Click to change");
            this.lore.add("");
            this.setValue(initialValue);
        }

        public T changeValue() {
            Enum[] values = (Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants();
            int currentIndex = ((Enum)this.value).ordinal();
            int newValueIndex = currentIndex + 1 == values.length ? 0 : currentIndex + 1;
            Enum newValue = values[newValueIndex];
            this.setValue(newValue);
            return (T)newValue;
        }
    }

    public static class BooleanItem
    extends Item<Boolean> {
        public BooleanItem(Material material, String title, String lore, boolean initialValue) {
            this(material, title, List.of(lore), initialValue, false);
        }

        public BooleanItem(Material material, String title, List<String> lore, boolean initialValue) {
            this(material, title, lore, initialValue, false);
        }

        public BooleanItem(Material material, String title, List<String> baseLore, boolean initialValue, boolean changeTitle) {
            this(new ItemStack(material), title, baseLore, initialValue, changeTitle);
        }

        public BooleanItem(ItemStack item, String title, List<String> baseLore, boolean initialValue, boolean changeTitle) {
            super(item, title, baseLore, Boolean.valueOf(initialValue), changeTitle);
            this.lore.add("");
            this.lore.add("&7Click to change");
            this.lore.add("");
            this.setValue((Boolean)this.value);
        }

        public boolean changeValue() {
            this.setValue((Boolean)this.value == false);
            return (Boolean)this.value;
        }
    }

    public static class StepItem
    extends Item<Double> {
        private final double bigChange;
        private final double smallChange;
        private final boolean smallEnabled;

        public StepItem(Material material, String title, List<String> lore, double initialValue, double bigChange) {
            this(material, title, lore, initialValue, bigChange, 0.0, false, false);
        }

        public StepItem(Material material, String title, List<String> lore, double initialValue, double bigChange, double smallChange) {
            this(material, title, lore, initialValue, bigChange, smallChange, true, false);
        }

        public StepItem(Material material, String title, String lore, double initialValue, double bigChange, double smallChange, boolean changeTitle) {
            this(material, title, List.of(lore), initialValue, bigChange, smallChange, true, changeTitle);
        }

        public StepItem(Material material, String title, List<String> lore, double initialValue, double bigChange, double smallChange, boolean changeTitle) {
            this(material, title, lore, initialValue, bigChange, smallChange, true, changeTitle);
        }

        private StepItem(Material material, String title, List<String> baseLore, double initialValue, double bigChange, double smallChange, boolean smallEnabled, boolean changeTitle) {
            super(material, title, baseLore, Double.valueOf(initialValue), changeTitle);
            this.bigChange = bigChange;
            this.smallChange = smallChange;
            this.smallEnabled = smallEnabled;
            this.lore.add("");
            this.lore.add("&7Use &cLEFT_CLICK &7to add " + bigChange);
            this.lore.add("&7Use &cRIGHT_CLICK &7to subtract " + bigChange);
            if (smallEnabled) {
                this.lore.add("&7Use &cSHIFT + LEFT_CLICK &7to add " + smallChange);
                this.lore.add("&7Use &cSHIFT + RIGHT_CLICK &7to subtract " + smallChange);
            }
            this.lore.add("");
            this.setValue((Double)this.value);
        }

        public double changeValue(boolean increase, boolean small, Double min) {
            return this.changeValue(increase, small, min, null);
        }

        public double changeValue(boolean increase, boolean small, Double min, Double max) {
            double change = small && this.smallEnabled ? (increase ? this.smallChange : -this.smallChange) : (increase ? this.bigChange : -this.bigChange);
            double filterMax = max == null ? (Double)this.value + change : Math.min(max, (Double)this.value + change);
            double filterMin = min == null ? filterMax : Math.max(min, filterMax);
            this.setValue(Utils.round(filterMin));
            return (Double)this.value;
        }

        public int setNewItemBrightness(boolean increase) {
            int change;
            int n = change = increase ? 1 : -1;
            int newBrightness = (Double)this.value == 15.0 && change == 1 ? 0 : ((Double)this.value == 0.0 && change == -1 ? 15 : (int)((Double)this.value + (double)change));
            EditorItems.setBrightness(this.item, newBrightness);
            this.setValue(Double.valueOf(newBrightness));
            return newBrightness;
        }
    }
}

