/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.items;

import java.util.List;
import me.lucaaa.advanceddisplays.api.displays.BaseDisplay;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.inventory.inventories.PlayerEditorInv;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import org.bukkit.Material;
import org.bukkit.util.Transformation;

public class InventoryItems {
    public final Item.StepItem YAW;
    public final Item.StepItem PITCH;
    public final Item.ClickableItem OPEN_GUI;
    public final Item.EnumItem<PlayerEditorInv.InventoryRows> CHANGE_ROW;

    public InventoryItems(BaseEntity entity) {
        this.YAW = new Item.StepItem(Material.SLIME_BALL, "Yaw", "Changes the display's yaw", (double)entity.getYaw(), 10.0, 1.0, true);
        this.PITCH = new Item.StepItem(Material.FIRE_CHARGE, "Pitch", "Changes the display's pitch", (double)entity.getPitch(), 10.0, 1.0, true);
        this.OPEN_GUI = new Item.ClickableItem(Material.NETHER_STAR, "Open editor GUI", List.of("Opens a GUI with more options", "to edit the display"), "(" + String.valueOf((Object)entity.getType()) + ") " + entity.getName());
        this.CHANGE_ROW = new Item.EnumItem<PlayerEditorInv.InventoryRows>(Material.ARROW, "Change row", List.of("Changes the tools in your hotbar", "with another row of tools"), PlayerEditorInv.InventoryRows.LEFT_ROTATION_YAW_PITCH, true);
    }

    public static class DisplayItems
    extends InventoryItems {
        public final Item.StepItem LEFT_ROTATION_X;
        public final Item.StepItem LEFT_ROTATION_Y;
        public final Item.StepItem LEFT_ROTATION_Z;
        public final Item.StepItem LEFT_ROTATION_ANGLE;
        public final Item.StepItem RIGHT_ROTATION_X;
        public final Item.StepItem RIGHT_ROTATION_Y;
        public final Item.StepItem RIGHT_ROTATION_Z;
        public final Item.StepItem RIGHT_ROTATION_ANGLE;
        public final Item.StepItem HITBOX_WIDTH;
        public final Item.StepItem HITBOX_HEIGHT;
        public final Item.StepItem SCALE_X;
        public final Item.StepItem SCALE_Y;
        public final Item.StepItem SCALE_Z;
        public final Item.StepItem TRANSLATION_X;
        public final Item.StepItem TRANSLATION_Y;
        public final Item.StepItem TRANSLATION_Z;

        public DisplayItems(BaseDisplay display) {
            super(display);
            Transformation transformation = display.getTransformation();
            this.SCALE_X = new Item.StepItem(Material.LARGE_AMETHYST_BUD, "Scale X", "Changes the x component of the display's scale", (double)transformation.getScale().x, 1.0, 0.1, true);
            this.SCALE_Y = new Item.StepItem(Material.LARGE_AMETHYST_BUD, "Scale Y", "Changes the y component of the display's scale", (double)transformation.getScale().y, 1.0, 0.1, true);
            this.SCALE_Z = new Item.StepItem(Material.LARGE_AMETHYST_BUD, "Scale Z", "Changes the z component of the display's scale", (double)transformation.getScale().z, 1.0, 0.1, true);
            this.TRANSLATION_X = new Item.StepItem(Material.REPEATER, "Translation X", "Changes the x component of the display's translation", (double)transformation.getTranslation().x, 1.0, 0.1, true);
            this.TRANSLATION_Y = new Item.StepItem(Material.REPEATER, "Translation Y", "Changes the y component of the display's translation", (double)transformation.getTranslation().y, 1.0, 0.1, true);
            this.TRANSLATION_Z = new Item.StepItem(Material.REPEATER, "Translation Z", "Changes the z component of the display's translation", (double)transformation.getTranslation().z, 1.0, 0.1, true);
            this.LEFT_ROTATION_X = new Item.StepItem(Material.BLAZE_ROD, "Left Rotation X", "Changes the x component of the display's left rotation", (double)transformation.getLeftRotation().x, 1.0, 0.1, true);
            this.LEFT_ROTATION_Y = new Item.StepItem(Material.BLAZE_ROD, "Left Rotation Y", "Changes the y component of the display's left rotation", (double)transformation.getLeftRotation().y, 1.0, 0.1, true);
            this.LEFT_ROTATION_Z = new Item.StepItem(Material.BLAZE_ROD, "Left Rotation Z", "Changes the z component of the display's left rotation", (double)transformation.getLeftRotation().z, 1.0, 0.1, true);
            this.LEFT_ROTATION_ANGLE = new Item.StepItem(Material.MAGMA_CREAM, "Left Rotation Angle", "Changes the angle of the display's left rotation", Utils.round(Math.toDegrees(transformation.getLeftRotation().angle())), 10.0, 1.0, true);
            this.RIGHT_ROTATION_X = new Item.StepItem(Material.STICK, "Right Rotation X", "Changes the x component of the display's right rotation", (double)transformation.getRightRotation().x, 1.0, 0.1, true);
            this.RIGHT_ROTATION_Y = new Item.StepItem(Material.STICK, "Right Rotation Y", "Changes the y component of the display's right rotation", (double)transformation.getRightRotation().y, 1.0, 0.1, true);
            this.RIGHT_ROTATION_Z = new Item.StepItem(Material.STICK, "Left Rotation Z", "Changes the z component of the display's right rotation", (double)transformation.getRightRotation().z, 1.0, 0.1, true);
            this.RIGHT_ROTATION_ANGLE = new Item.StepItem(Material.MAGMA_CREAM, "Right Rotation Angle", "Changes the angle of the display's right rotation", Utils.round(Math.toDegrees(transformation.getRightRotation().angle())), 10.0, 1.0, true);
            this.HITBOX_WIDTH = new Item.StepItem(Material.LEATHER, "Hitbox width", List.of("Changes the width of the display's hitbox.", "It will automatically set the hitbox size override to true,", "although you can change it to false in the GUI"), (double)display.getHitboxWidth(), 1.0, 0.1, true);
            this.HITBOX_HEIGHT = new Item.StepItem(Material.RABBIT_HIDE, "Hitbox height", List.of("Changes the height of the display's hitbox.", "It will automatically set the hitbox size override to true,", "although you can change it to false in the GUI"), (double)display.getHitboxHeight(), 1.0, 0.1, true);
        }
    }
}

