/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.lucaaa.advanceddisplays.api.displays.BaseDisplay;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.api.displays.BlockDisplay;
import me.lucaaa.advanceddisplays.api.displays.ItemDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.NameVisibility;
import me.lucaaa.advanceddisplays.api.util.ComponentSerializer;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import me.lucaaa.advanceddisplays.inventory.items.ColorItems;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import me.lucaaa.advanceddisplays.nms_common.Version;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EditorItems {
    public final Item.BooleanItem ON_FIRE;
    public final Item.BooleanItem SPRINTING;
    public final Item.BooleanItem GLOW_TOGGLE;
    public final Item.EnumItem<ChatColor> GLOW_COLOR;
    public final Item.ClickableItem CUSTOM_NAME;
    public final Item.EnumItem<NameVisibility> CUSTOM_NAME_VISIBILITY;
    public final Item.ClickableItem TELEPORT;
    public final Item.ClickableItem MOVE_HERE;
    public final Item.ClickableItem CENTER;
    public final Item.ClickableItem METADATA;
    public Item.StepItem BLOCK_LIGHT;
    public Item.StepItem SKY_LIGHT;
    public Item.StepItem SHADOW_RADIUS;
    public Item.StepItem SHADOW_STRENGTH;
    public ColorItems.ColorPreview GLOW_COLOR_OVERRIDE;
    public Item.EnumItem<Display.Billboard> BILLBOARD;
    public Item.BooleanItem HITBOX_OVERRIDE;
    public Item.ClickableItem ENTITY_SETTINGS;
    public Item.ClickableItem CURRENT_VALUE;
    public final Item.ClickableItem REMOVE;
    public Item.ClickableItem BLOCK_DATA;
    public Item.EnumItem<ItemDisplay.ItemDisplayTransform> ITEM_TRANSFORMATION;
    public Item.BooleanItem ENCHANTED;
    public Item<?> CUSTOM_MODEL_DATA;
    public Item.EnumItem<TextDisplay.TextAlignment> TEXT_ALIGNMENT;
    public ColorItems.ColorPreview BACKGROUND_COLOR;
    public Item.StepItem LINE_WIDTH;
    public Item.StepItem TEXT_OPACITY;
    public Item.BooleanItem USE_DEFAULT_BACKGROUND;
    public Item.BooleanItem SEE_THROUGH;
    public Item.BooleanItem SHADOWED;
    public Item.StepItem ANIMATION_TIME;
    public Item.StepItem REFRESH_TIME;

    public EditorItems(BaseEntity entity, Version nmsVersion) {
        this.ON_FIRE = new Item.BooleanItem(Material.CAMPFIRE, "On fire", "Changes whether the entity is on fire or not", entity.isOnFire());
        this.SPRINTING = new Item.BooleanItem(Material.IRON_BOOTS, "Sprinting", "Changes whether the entity appears to be sprinting or not", entity.isSprinting());
        this.GLOW_TOGGLE = new Item.BooleanItem(Material.GLOW_BERRIES, "Toggle glow", "Enables or disables the display's glowing status", entity.isGlowing());
        this.GLOW_COLOR = new Item.EnumItem<ChatColor>(Material.RED_DYE, "Glow color", "Enables or disables the display's glowing status", entity.getGlowColor());
        this.CUSTOM_NAME = entity.getCustomName() == null ? new Item.ClickableItem(Material.NAME_TAG, "Custom name", List.of("Changes the entity's custom name", "", "&7Click to change"), Utils.getColoredText("&cNo custom name set")) : new Item.ClickableItem(Material.NAME_TAG, "Custom name", List.of("Changes the entity's custom name", "", "&7Click to change"), ComponentSerializer.getLegacyString(ComponentSerializer.deserialize(entity.getCustomName())));
        this.CUSTOM_NAME_VISIBILITY = new Item.EnumItem<NameVisibility>(Material.REDSTONE, "Custom name visiblity", "Changes the entity's custom name visibility", entity.getCustomNameVisibility());
        String location = Utils.locToString(entity.getLocation());
        this.TELEPORT = new Item.ClickableItem(Material.ENDER_PEARL, "Teleport", "Teleports you to the display", location);
        this.MOVE_HERE = new Item.ClickableItem(Material.CHORUS_FRUIT, "Move here", "Moves the display to your location", location);
        this.CENTER = new Item.ClickableItem(Material.LIGHTNING_ROD, "Center", "Centers the display on the block it's on", location);
        this.METADATA = new Item.ClickableItem(Material.REPEATING_COMMAND_BLOCK, "Metadata", "Properties that change how to the entity looks like.");
        if (entity instanceof BaseDisplay) {
            BaseDisplay display = (BaseDisplay)entity;
            this.BLOCK_LIGHT = this.createLight("Block light", "Changes the block lighting component of the display", display.getBrightness().getBlockLight());
            this.SKY_LIGHT = this.createLight("Sky light", "Changes the sky lighting component of the display", display.getBrightness().getSkyLight());
            this.SHADOW_RADIUS = this.createShadow("Shadow Radius", "Changes how big the shadow is", display.getShadowRadius());
            this.SHADOW_STRENGTH = this.createShadow("Shadow Strength", "Changes how dark the shadow is", display.getShadowStrength());
            this.GLOW_COLOR_OVERRIDE = new ColorItems.ColorPreview("Glow color", display.getGlowColorOverride(), ColorItems.ColorComponent.ALL, false);
            this.BILLBOARD = new Item.EnumItem<Display.Billboard>(Material.STRUCTURE_VOID, "Change billboard", "Changes the display's rotation axis", display.getBillboard());
            this.HITBOX_OVERRIDE = new Item.BooleanItem(Material.END_CRYSTAL, "Override hitbox size", List.of("Whether the hitbox size is set", "automatically or manually"), display.isHitboxSizeOverriden());
            this.ENTITY_SETTINGS = new Item.ClickableItem(Material.CREEPER_HEAD, "Entity settings", "Changes this entity's properties");
            switch (display.getType()) {
                case TEXT: {
                    ADTextDisplay textDisplay = (ADTextDisplay)display;
                    ArrayList<String> lore = new ArrayList<String>();
                    lore.add("Changes the text that is being displayed");
                    lore.add("");
                    lore.add("&7Use &cLEFT_CLICK &7to add an animation");
                    if (textDisplay.isNotEmpty()) {
                        lore.add("&7Use &cRIGHT_CLICK &7to remove an animation");
                    }
                    this.CURRENT_VALUE = new Item.ClickableItem(Material.OAK_SIGN, "Display text", lore, textDisplay.getTextsNumber() + " text animation(s)");
                    this.TEXT_ALIGNMENT = new Item.EnumItem<TextDisplay.TextAlignment>(Material.FILLED_MAP, "Text alignment", "Changes the text's alignment", textDisplay.getAlignment());
                    this.BACKGROUND_COLOR = new ColorItems.ColorPreview("Background color", textDisplay.getBackgroundColor(), ColorItems.ColorComponent.ALL, true);
                    this.LINE_WIDTH = new Item.StepItem(Material.BLACK_DYE, "Line width", List.of("Changes the display's line width"), textDisplay.getLineWidth(), 10.0, 1.0);
                    this.TEXT_OPACITY = new Item.StepItem(Material.GRAY_DYE, "Text opacity", List.of("Changes the text's opacity"), textDisplay.getTextOpacity(), 10.0, 1.0);
                    this.USE_DEFAULT_BACKGROUND = new Item.BooleanItem(Material.WHITE_DYE, "Use default background", "Changes whether the display uses the default background or not", textDisplay.getUseDefaultBackground());
                    this.SEE_THROUGH = new Item.BooleanItem(Material.TINTED_GLASS, "See through", "Changes whether the display can be seen through blocks or not", textDisplay.isSeeThrough());
                    this.SHADOWED = new Item.BooleanItem(Material.BLACK_STAINED_GLASS, "Shadowed", "Changes whether the text is shadowed or not", textDisplay.isShadowed());
                    this.ANIMATION_TIME = new Item.StepItem(Material.NAME_TAG, "Animation time", List.of("Changes how often the text changes", "Value must be in ticks"), textDisplay.getAnimationTime(), 10.0, 1.0);
                    this.REFRESH_TIME = new Item.StepItem(Material.NAME_TAG, "Refresh time", List.of("Changes how often placeholders update", "Value must be in ticks"), textDisplay.getRefreshTime(), 10.0, 1.0);
                    break;
                }
                case ITEM: {
                    ItemDisplay itemDisplay = (ItemDisplay)display;
                    ItemMeta meta = itemDisplay.getItem().clone().getItemMeta();
                    this.CURRENT_VALUE = new Item.ClickableItem(itemDisplay.getItem(), "Display item", List.of("The item that is being displayed", "", "&7Click to change"), itemDisplay.getItem().getType().name());
                    this.ITEM_TRANSFORMATION = new Item.EnumItem<ItemDisplay.ItemDisplayTransform>(Material.ARMOR_STAND, "Item model transform", "Changes how the displayed item is shown", itemDisplay.getItemTransformation());
                    this.ENCHANTED = new Item.BooleanItem(Material.ENCHANTED_BOOK, "Enchanted", "Changes whether the enchanted effect is visible or not", itemDisplay.isEnchanted());
                    if (meta == null) break;
                    if (nmsVersion.isEqualOrNewerThan(Version.v1_21_R3)) {
                        this.CUSTOM_MODEL_DATA = new Item.ClickableItem(Material.REPEATING_COMMAND_BLOCK, "Custom model data", List.of("Changes the item's custom model data"), "Custom model data component");
                        break;
                    }
                    this.CUSTOM_MODEL_DATA = new Item.StepItem(Material.REPEATING_COMMAND_BLOCK, "Custom model data", List.of("Changes the item's custom model data"), meta.hasCustomModelData() ? (double)meta.getCustomModelData() : 0.0, 1.0);
                    break;
                }
                case BLOCK: {
                    this.CURRENT_VALUE = new Item.ClickableItem(((BlockDisplay)display).getBlock().getMaterial(), "Display block", List.of("The block that is being displayed", "", "&7Click to change"), ((BlockDisplay)display).getBlock().getMaterial().name());
                    this.BLOCK_DATA = new Item.ClickableItem(Material.COMMAND_BLOCK, "Block data", "Changes values that makes the block look different", ((BlockDisplay)display).getBlock().toString());
                    break;
                }
                default: {
                    this.CURRENT_VALUE = new Item.ClickableItem(Material.BARRIER, "&cUnextected error", "&7Report to developer.");
                }
            }
        }
        this.REMOVE = new Item.ClickableItem(Material.BARRIER, "&cRemove", List.of("Permanently removes this display", "&cThis action cannot be undone!"), null);
    }

    private Item.StepItem createLight(String title, String lore, int value) {
        Item.StepItem item = new Item.StepItem(Material.LIGHT, title, List.of(lore), value, 1.0);
        EditorItems.setBrightness(item.getStack(), value);
        return item;
    }

    public static void setBrightness(ItemStack item, int brightness) {
        BlockDataMeta meta = (BlockDataMeta)Objects.requireNonNull(item.getItemMeta());
        Levelled data = (Levelled)Material.LIGHT.createBlockData();
        data.setLevel(brightness);
        meta.setBlockData((BlockData)data);
        item.setItemMeta((ItemMeta)meta);
    }

    private Item.StepItem createShadow(String title, String rawLore, float value) {
        return new Item.StepItem(Material.COAL, title, List.of(rawLore), value, 1.0, 0.1);
    }
}

