/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.items;

import java.util.ArrayList;
import java.util.List;
import me.lucaaa.advanceddisplays.data.ADChatColor;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class ColorItems {
    public final ColorSelector RED_1;
    public final ColorSelector RED_10;
    public final ColorSelector RED_100;
    public final ColorPreview RED_PREVIEW;
    public final ColorSelector GREEN_1;
    public final ColorSelector GREEN_10;
    public final ColorSelector GREEN_100;
    public final ColorPreview GREEN_PREVIEW;
    public final ColorSelector BLUE_1;
    public final ColorSelector BLUE_10;
    public final ColorSelector BLUE_100;
    public final ColorPreview BLUE_PREVIEW;
    public final ColorSelector ALPHA_1;
    public final ColorSelector ALPHA_10;
    public final ColorSelector ALPHA_100;
    public final ColorPreview ALPHA_PREVIEW;
    public final ColorPreview PREVIEW;

    public ColorItems(Material previewMaterial, Color color, boolean alphaEnabled) {
        this.RED_1 = new ColorSelector(ColorComponent.RED, 1, color.getRed());
        this.RED_10 = new ColorSelector(ColorComponent.RED, 10, color.getRed());
        this.RED_100 = new ColorSelector(ColorComponent.RED, 100, color.getRed());
        this.RED_PREVIEW = new ColorPreview(previewMaterial, "&cRed preview", color, ColorComponent.RED, false);
        this.GREEN_1 = new ColorSelector(ColorComponent.GREEN, 1, color.getGreen());
        this.GREEN_10 = new ColorSelector(ColorComponent.GREEN, 10, color.getGreen());
        this.GREEN_100 = new ColorSelector(ColorComponent.GREEN, 100, color.getGreen());
        this.GREEN_PREVIEW = new ColorPreview(previewMaterial, "&aGreen preview", color, ColorComponent.GREEN, false);
        this.BLUE_1 = new ColorSelector(ColorComponent.BLUE, 1, color.getBlue());
        this.BLUE_10 = new ColorSelector(ColorComponent.BLUE, 10, color.getBlue());
        this.BLUE_100 = new ColorSelector(ColorComponent.BLUE, 100, color.getBlue());
        this.BLUE_PREVIEW = new ColorPreview(previewMaterial, "&9Blue preview", color, ColorComponent.BLUE, false);
        this.ALPHA_1 = new ColorSelector(ColorComponent.ALPHA, 1, color.getAlpha());
        this.ALPHA_10 = new ColorSelector(ColorComponent.ALPHA, 10, color.getAlpha());
        this.ALPHA_100 = new ColorSelector(ColorComponent.ALPHA, 100, color.getAlpha());
        this.ALPHA_PREVIEW = new ColorPreview(previewMaterial, "&fAlpha preview", color, ColorComponent.ALPHA, true);
        this.PREVIEW = new ColorPreview(previewMaterial, "Color preview", color, ColorComponent.ALL, alphaEnabled);
    }

    public static class ColorSelector
    extends Item.StepItem {
        private final int amount;

        public ColorSelector(ColorComponent component, int amount, int color) {
            super(component.material, component.name + " \u00b1" + amount, List.of("Adds or subtracts " + amount + " " + component.name + " from the color"), color, amount);
            this.amount = amount;
        }

        public void updateColor(double newAmount) {
            this.setValue(newAmount);
        }

        public int getAmount() {
            return this.amount;
        }
    }

    public static enum ColorComponent {
        RED(Material.RED_CONCRETE, "Red", "&c"),
        GREEN(Material.LIME_CONCRETE, "Green", "&a"),
        BLUE(Material.BLUE_CONCRETE, "Blue", "&9"),
        ALPHA(Material.WHITE_CONCRETE, "Alpha", "&f"),
        ALL(Material.BARRIER, "All", "&4");

        private final Material material;
        private final String name;
        private final String code;

        private ColorComponent(Material material, String name, String code) {
            this.material = material;
            this.name = name;
            this.code = code;
        }
    }

    public static class ColorPreview
    extends Item<Double> {
        private final ColorComponent component;
        private final boolean alphaEnabled;

        public ColorPreview(String title, Color color, ColorComponent component, boolean alphaEnabled) {
            this(Material.LEATHER_CHESTPLATE, title, List.of(), color, component, alphaEnabled);
        }

        public ColorPreview(Material material, String title, Color color, ColorComponent component, boolean alphaEnabled) {
            this(material, title, List.of(), color, component, alphaEnabled);
        }

        public ColorPreview(Material material, String title, List<String> lore, Color color, ColorComponent component, boolean alphaEnabled) {
            super(material, title, lore, null, false);
            this.component = component;
            this.alphaEnabled = alphaEnabled;
            this.setColor(color);
        }

        public void setColor(Color color) {
            ADChatColor colors = new ADChatColor(color, this.component);
            ArrayList<String> lore = new ArrayList<String>(this.lore);
            lore.add("");
            if (this.component == ColorComponent.ALL) {
                lore.add(Utils.getColoredText("&9Current values:"));
                lore.add(String.valueOf(ChatColor.of((String)"#FF0000")) + "Red: " + String.valueOf(colors.red) + color.getRed());
                lore.add(String.valueOf(ChatColor.of((String)"#00FF00")) + "Green: " + String.valueOf(colors.green) + color.getGreen());
                lore.add(String.valueOf(ChatColor.of((String)"#0000FF")) + "Blue: " + String.valueOf(colors.blue) + color.getBlue());
                if (this.alphaEnabled) {
                    lore.add(String.valueOf(ChatColor.WHITE) + "Alpha: " + String.valueOf(colors.alpha) + color.getAlpha());
                }
                lore.add("");
                lore.add("&9Preview: " + String.valueOf(colors.fromComponent()) + "Color preview");
            } else {
                int componentNumber = switch (this.component.ordinal()) {
                    case 0 -> color.getRed();
                    case 1 -> color.getGreen();
                    case 2 -> color.getBlue();
                    case 3 -> color.getAlpha();
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.component));
                };
                lore.add("&9Current value: " + String.valueOf(colors.fromComponent()) + this.component.name() + this.component.code + " (" + componentNumber + ")");
            }
            ItemMeta meta = this.item.getItemMeta();
            if (meta != null) {
                Color parsedColor = ADChatColor.fromChatColor(colors.fromComponent());
                if (meta instanceof LeatherArmorMeta) {
                    LeatherArmorMeta leatherMeta = (LeatherArmorMeta)meta;
                    leatherMeta.setColor(parsedColor);
                } else if (meta instanceof PotionMeta) {
                    PotionMeta potionMeta = (PotionMeta)meta;
                    potionMeta.setColor(parsedColor);
                }
                this.item.setItemMeta(meta);
            }
            this.setMeta(this.title, lore);
        }
    }
}

