/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BaseDisplay;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.data.NamedEnum;
import me.lucaaa.advanceddisplays.displays.ADBaseDisplay;
import me.lucaaa.advanceddisplays.inventory.ADInventory;
import me.lucaaa.advanceddisplays.inventory.Button;
import me.lucaaa.advanceddisplays.inventory.inventories.DisplayEditorGUI;
import me.lucaaa.advanceddisplays.inventory.inventories.EntityEditorGUI;
import me.lucaaa.advanceddisplays.inventory.items.GlobalItems;
import me.lucaaa.advanceddisplays.inventory.items.InventoryItems;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Transformation;

public class PlayerEditorInv {
    private final Player player;
    private final List<EditorItem> disabledItems;
    private InventoryRows currentRow = InventoryRows.LEFT_ROTATION_YAW_PITCH;
    private final BaseEntity entity;
    private final boolean isDisplay;
    private final Transformation transformation;
    private final InventoryItems items;
    private final Map<InventoryRows, Map<Integer, Button.PlayerButton<?>>> rows = new HashMap();
    private final Map<Integer, Button.PlayerButton<?>> buttons = new HashMap();

    public PlayerEditorInv(final AdvancedDisplays plugin, final Player player, BaseEntity entity, final List<EditorItem> disabledItems) {
        this.player = player;
        this.disabledItems = disabledItems;
        this.entity = entity;
        this.isDisplay = entity instanceof ADBaseDisplay;
        this.transformation = this.isDisplay ? ((BaseDisplay)entity).getTransformation() : null;
        this.items = this.isDisplay ? new InventoryItems.DisplayItems((BaseDisplay)this.entity) : new InventoryItems(this.entity);
        this.addLeftRotButtons();
        if (this.isDisplay) {
            this.addRightRotButtons();
            this.addScaleTranslationButtons();
        }
        if (this.isDisplay) {
            this.buttons.put(6, new Button.PlayerButton<Item.EnumItem<InventoryRows>>(this.items.CHANGE_ROW){

                @Override
                public void onClick(PlayerInteractEvent event) {
                    PlayerEditorInv.this.currentRow = (InventoryRows)((Item.EnumItem)this.getItem()).changeValue();
                    player.getInventory().setItem(8, ((Item.EnumItem)this.getItem()).getStack());
                    PlayerEditorInv.this.setContents(PlayerEditorInv.this.currentRow);
                }
            });
        }
        this.buttons.put(7, new Button.PlayerButton<Item.ClickableItem>(this.items.OPEN_GUI){

            @Override
            public void onClick(PlayerInteractEvent event) {
                ADInventory inventory = PlayerEditorInv.this.isDisplay ? new DisplayEditorGUI(plugin, (ADBaseDisplay)PlayerEditorInv.this.entity, disabledItems) : new EntityEditorGUI(plugin, PlayerEditorInv.this.entity, (List<EditorItem>)disabledItems, null, null);
                plugin.getInventoryManager().handleOpen(event.getPlayer(), inventory);
            }
        });
        this.buttons.put(8, new Button.PlayerButton<Item.ClickableItem>(GlobalItems.done(plugin)){

            @Override
            public void onClick(PlayerInteractEvent event) {
                plugin.getPlayersManager().getPlayerData(player).finishEditing();
                player.sendMessage(plugin.getMessagesManager().getColoredMessage("&aYour old inventory has been given back to you."));
            }
        });
        this.setContents(this.currentRow);
    }

    public void handleClick(int slot, PlayerInteractEvent event) {
        if (this.buttons.containsKey(slot)) {
            this.buttons.get(slot).onClick(event);
        } else {
            Button.PlayerButton<?> button = this.rows.get(this.currentRow).get(slot);
            if (button != null) {
                button.onClick(event);
            }
        }
    }

    public void setContents(InventoryRows hotbarRow) {
        ItemStack[] itemArray = new ItemStack[36];
        HashMap maps = new HashMap(this.rows);
        for (Map.Entry entry : ((Map)maps.remove(hotbarRow)).entrySet()) {
            itemArray[((Integer)entry.getKey()).intValue()] = ((Item)((Button.PlayerButton)entry.getValue()).getItem()).getStack();
        }
        int i = 27;
        for (Map.Entry entry : maps.entrySet()) {
            for (Map.Entry row : ((Map)entry.getValue()).entrySet()) {
                itemArray[i + ((Integer)row.getKey()).intValue()] = ((Item)((Button.PlayerButton)row.getValue()).getItem()).getStack();
            }
            i -= 9;
        }
        for (Map.Entry<Object, Object> entry : this.buttons.entrySet()) {
            itemArray[((Integer)entry.getKey()).intValue()] = ((Item)((Button.PlayerButton)entry.getValue()).getItem()).getStack();
        }
        this.player.getInventory().setContents(itemArray);
    }

    private boolean isLeftClick(PlayerInteractEvent event) {
        return event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK;
    }

    private void addLeftRotButtons() {
        HashMap leftRotationMap = new HashMap();
        if (this.isDisplay) {
            InventoryItems.DisplayItems items = (InventoryItems.DisplayItems)this.items;
            final BaseDisplay display = (BaseDisplay)this.entity;
            leftRotationMap.put(0, this.getCheckedAllowed(EditorItem.LEFT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.LEFT_ROTATION_X){

                @Override
                public void onClick(PlayerInteractEvent event) {
                    double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0, 1.0);
                    PlayerEditorInv.this.player.getInventory().setItem(0, ((Item.StepItem)this.getItem()).getStack());
                    PlayerEditorInv.this.transformation.getLeftRotation().setAngleAxis(PlayerEditorInv.this.transformation.getLeftRotation().angle(), (float)newValue, PlayerEditorInv.this.transformation.getLeftRotation().y, PlayerEditorInv.this.transformation.getLeftRotation().z);
                    display.setTransformation(PlayerEditorInv.this.transformation);
                }
            }));
            leftRotationMap.put(1, this.getCheckedAllowed(EditorItem.LEFT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.LEFT_ROTATION_Y){

                @Override
                public void onClick(PlayerInteractEvent event) {
                    double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0, 1.0);
                    PlayerEditorInv.this.player.getInventory().setItem(1, ((Item.StepItem)this.getItem()).getStack());
                    PlayerEditorInv.this.transformation.getLeftRotation().setAngleAxis(PlayerEditorInv.this.transformation.getLeftRotation().angle(), PlayerEditorInv.this.transformation.getLeftRotation().x, (float)newValue, PlayerEditorInv.this.transformation.getLeftRotation().z);
                    display.setTransformation(PlayerEditorInv.this.transformation);
                }
            }));
            leftRotationMap.put(2, this.getCheckedAllowed(EditorItem.LEFT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.LEFT_ROTATION_Z){

                @Override
                public void onClick(PlayerInteractEvent event) {
                    double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0, 1.0);
                    PlayerEditorInv.this.player.getInventory().setItem(2, ((Item.StepItem)this.getItem()).getStack());
                    PlayerEditorInv.this.transformation.getLeftRotation().setAngleAxis(PlayerEditorInv.this.transformation.getLeftRotation().angle(), PlayerEditorInv.this.transformation.getLeftRotation().x, PlayerEditorInv.this.transformation.getLeftRotation().y, (float)newValue);
                    display.setTransformation(PlayerEditorInv.this.transformation);
                }
            }));
            leftRotationMap.put(3, this.getCheckedAllowed(EditorItem.LEFT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.LEFT_ROTATION_ANGLE){

                @Override
                public void onClick(PlayerInteractEvent event) {
                    double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                    PlayerEditorInv.this.player.getInventory().setItem(3, ((Item.StepItem)this.getItem()).getStack());
                    PlayerEditorInv.this.transformation.getLeftRotation().setAngleAxis((float)Math.toRadians(newValue), PlayerEditorInv.this.transformation.getLeftRotation().x, PlayerEditorInv.this.transformation.getLeftRotation().y, PlayerEditorInv.this.transformation.getLeftRotation().z);
                    display.setTransformation(PlayerEditorInv.this.transformation);
                }
            }));
        }
        leftRotationMap.put(4, this.getCheckedAllowed(EditorItem.ROTATION, new Button.PlayerButton<Item.StepItem>(this.items.YAW){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), null);
                PlayerEditorInv.this.player.getInventory().setItem(4, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.entity.setRotation((float)newValue, PlayerEditorInv.this.entity.getPitch());
            }
        }));
        leftRotationMap.put(5, this.getCheckedAllowed(EditorItem.ROTATION, new Button.PlayerButton<Item.StepItem>(this.items.PITCH){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), null);
                PlayerEditorInv.this.player.getInventory().setItem(5, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.entity.setRotation(PlayerEditorInv.this.entity.getYaw(), (float)newValue);
            }
        }));
        this.rows.put(InventoryRows.LEFT_ROTATION_YAW_PITCH, leftRotationMap);
    }

    private void addRightRotButtons() {
        HashMap rightRotationMap = new HashMap();
        final BaseDisplay display = (BaseDisplay)this.entity;
        InventoryItems.DisplayItems items = (InventoryItems.DisplayItems)this.items;
        rightRotationMap.put(0, this.getCheckedAllowed(EditorItem.RIGHT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.RIGHT_ROTATION_X){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0, 1.0);
                PlayerEditorInv.this.player.getInventory().setItem(0, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getRightRotation().setAngleAxis(PlayerEditorInv.this.transformation.getRightRotation().angle(), (float)newValue, PlayerEditorInv.this.transformation.getRightRotation().y, PlayerEditorInv.this.transformation.getRightRotation().z);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        rightRotationMap.put(1, this.getCheckedAllowed(EditorItem.RIGHT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.RIGHT_ROTATION_Y){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0, 1.0);
                PlayerEditorInv.this.player.getInventory().setItem(1, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getRightRotation().setAngleAxis(PlayerEditorInv.this.transformation.getRightRotation().angle(), PlayerEditorInv.this.transformation.getRightRotation().x, (float)newValue, PlayerEditorInv.this.transformation.getRightRotation().z);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        rightRotationMap.put(2, this.getCheckedAllowed(EditorItem.RIGHT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.RIGHT_ROTATION_Z){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0, 1.0);
                PlayerEditorInv.this.player.getInventory().setItem(2, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getRightRotation().setAngleAxis(PlayerEditorInv.this.transformation.getRightRotation().angle(), PlayerEditorInv.this.transformation.getRightRotation().x, PlayerEditorInv.this.transformation.getRightRotation().y, (float)newValue);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        rightRotationMap.put(3, this.getCheckedAllowed(EditorItem.RIGHT_ROTATION, new Button.PlayerButton<Item.StepItem>(items.RIGHT_ROTATION_ANGLE){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(3, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getRightRotation().setAngleAxis((float)Math.toRadians(newValue), PlayerEditorInv.this.transformation.getRightRotation().x, PlayerEditorInv.this.transformation.getRightRotation().y, PlayerEditorInv.this.transformation.getRightRotation().z);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        rightRotationMap.put(4, this.getCheckedAllowed(EditorItem.HITBOX_SIZE, new Button.PlayerButton<Item.StepItem>(items.HITBOX_WIDTH){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(4, ((Item.StepItem)this.getItem()).getStack());
                display.setHitboxSize(true, (float)newValue, display.getHitboxHeight());
            }
        }));
        rightRotationMap.put(5, this.getCheckedAllowed(EditorItem.HITBOX_SIZE, new Button.PlayerButton<Item.StepItem>(items.HITBOX_HEIGHT){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(5, ((Item.StepItem)this.getItem()).getStack());
                display.setHitboxSize(true, display.getHitboxWidth(), (float)newValue);
            }
        }));
        this.rows.put(InventoryRows.RIGHT_ROTATION_HITBOX, rightRotationMap);
    }

    private void addScaleTranslationButtons() {
        HashMap scaleTranslationMap = new HashMap();
        final BaseDisplay display = (BaseDisplay)this.entity;
        InventoryItems.DisplayItems items = (InventoryItems.DisplayItems)this.items;
        scaleTranslationMap.put(0, this.getCheckedAllowed(EditorItem.SCALE, new Button.PlayerButton<Item.StepItem>(items.SCALE_X){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(0, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getScale().set(newValue, (double)PlayerEditorInv.this.transformation.getScale().y, (double)PlayerEditorInv.this.transformation.getScale().z);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        scaleTranslationMap.put(1, this.getCheckedAllowed(EditorItem.SCALE, new Button.PlayerButton<Item.StepItem>(items.SCALE_Y){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(1, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getScale().set((double)PlayerEditorInv.this.transformation.getScale().x, newValue, (double)PlayerEditorInv.this.transformation.getScale().z);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        scaleTranslationMap.put(2, this.getCheckedAllowed(EditorItem.SCALE, new Button.PlayerButton<Item.StepItem>(items.SCALE_Z){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(2, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getScale().set((double)PlayerEditorInv.this.transformation.getScale().x, (double)PlayerEditorInv.this.transformation.getScale().y, newValue);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        scaleTranslationMap.put(3, this.getCheckedAllowed(EditorItem.TRANSLATION, new Button.PlayerButton<Item.StepItem>(items.TRANSLATION_X){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(3, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getTranslation().set(newValue, (double)PlayerEditorInv.this.transformation.getTranslation().y, (double)PlayerEditorInv.this.transformation.getTranslation().z);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        scaleTranslationMap.put(4, this.getCheckedAllowed(EditorItem.TRANSLATION, new Button.PlayerButton<Item.StepItem>(items.TRANSLATION_Y){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(4, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getTranslation().set((double)PlayerEditorInv.this.transformation.getTranslation().x, newValue, (double)PlayerEditorInv.this.transformation.getTranslation().z);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        scaleTranslationMap.put(5, this.getCheckedAllowed(EditorItem.TRANSLATION, new Button.PlayerButton<Item.StepItem>(items.TRANSLATION_Z){

            @Override
            public void onClick(PlayerInteractEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(PlayerEditorInv.this.isLeftClick(event), event.getPlayer().isSneaking(), 0.0);
                PlayerEditorInv.this.player.getInventory().setItem(5, ((Item.StepItem)this.getItem()).getStack());
                PlayerEditorInv.this.transformation.getTranslation().set((double)PlayerEditorInv.this.transformation.getTranslation().x, (double)PlayerEditorInv.this.transformation.getTranslation().y, newValue);
                display.setTransformation(PlayerEditorInv.this.transformation);
            }
        }));
        this.rows.put(InventoryRows.SCALE_TRANSLATION, scaleTranslationMap);
    }

    private Button.PlayerButton<?> getCheckedAllowed(EditorItem requirement, Button.PlayerButton<?> button) {
        if (!this.disabledItems.contains((Object)requirement)) {
            return button;
        }
        ItemStack itemStack = ((Item)button.getItem()).getStack();
        ItemMeta meta = Objects.requireNonNull(itemStack.getItemMeta());
        meta.setDisplayName(meta.getDisplayName() + String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + " (Disabled)");
        ArrayList<Object> lore = new ArrayList<Object>();
        for (String line : Objects.requireNonNull(meta.getLore())) {
            if (!line.startsWith(String.valueOf(ChatColor.YELLOW))) continue;
            lore.add(line);
        }
        lore.remove(lore.size() - 1);
        lore.add(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "Setting disabled!");
        lore.add(String.valueOf(ChatColor.GRAY) + "You won't be able to change it");
        lore.add("");
        lore.add(String.valueOf(ChatColor.BLUE) + "Current value: " + String.valueOf(ChatColor.GRAY) + String.valueOf(((Item)button.getItem()).getValue()));
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        return new Button.PlayerButton<Item<?>>((Item)button.getItem()){

            @Override
            public void onClick(PlayerInteractEvent event) {
            }
        };
    }

    public static enum InventoryRows implements NamedEnum
    {
        SCALE_TRANSLATION("Scale & Translation"),
        LEFT_ROTATION_YAW_PITCH("Left rotation, yaw & pitch"),
        RIGHT_ROTATION_HITBOX("Right rotation & hitbox");

        private final String name;

        private InventoryRows(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

