/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.inventories;

import java.util.ArrayList;
import java.util.List;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.api.displays.EntityDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.api.displays.enums.NameVisibility;
import me.lucaaa.advanceddisplays.api.displays.enums.Property;
import me.lucaaa.advanceddisplays.api.util.ComponentSerializer;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.inventory.ADInventory;
import me.lucaaa.advanceddisplays.inventory.Button;
import me.lucaaa.advanceddisplays.inventory.inventories.DisplayEditorGUI;
import me.lucaaa.advanceddisplays.inventory.items.EditorItems;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class EntityEditorGUI
extends ADInventory {
    private final BaseEntity display;
    private final EditorItems items;
    private static final List<String> LORE = new ArrayList<String>();

    public EntityEditorGUI(AdvancedDisplays plugin, BaseEntity display, List<EditorItem> disabledSettings, DisplayEditorGUI previous, Runnable onDone) {
        super(plugin, Bukkit.createInventory(null, (int)27, (String)Utils.getColoredText("&6Editing " + display.getType().name() + " display: &e" + display.getName())), disabledSettings, previous, onDone);
        this.display = display;
        this.items = new EditorItems(display, plugin.getNmsVersion());
    }

    @Override
    public void decorate() {
        this.addIfAllowed(EditorItem.ON_FIRE, 0, new Button.InventoryButton<Item.BooleanItem>(this.items.ON_FIRE){

            @Override
            public void onClick(InventoryClickEvent event) {
                boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                EntityEditorGUI.this.getInventory().setItem(0, ((Item.BooleanItem)this.getItem()).getStack());
                EntityEditorGUI.this.display.setOnFire(newValue);
            }
        });
        this.addIfAllowed(EditorItem.SPRINTING, 9, new Button.InventoryButton<Item.BooleanItem>(this.items.SPRINTING){

            @Override
            public void onClick(InventoryClickEvent event) {
                boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                EntityEditorGUI.this.getInventory().setItem(9, ((Item.BooleanItem)this.getItem()).getStack());
                EntityEditorGUI.this.display.setSprinting(newValue);
            }
        });
        this.addIfAllowed(EditorItem.CUSTOM_NAME, 1, new Button.InventoryButton<Item.ClickableItem>(this.items.CUSTOM_NAME){

            @Override
            public void onClick(InventoryClickEvent event) {
                EntityEditorGUI.this.plugin.getPlayersManager().getPlayerData((Player)event.getWhoClicked()).setChatEditing(true);
                event.getWhoClicked().closeInventory();
                event.getWhoClicked().sendMessage(EntityEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Enter the new custom name or \"cancel\" to keep the current one."));
            }
        });
        this.addIfAllowed(EditorItem.CUSTOM_NAME_VISIBILITY, 10, new Button.InventoryButton<Item.EnumItem<NameVisibility>>(this.items.CUSTOM_NAME_VISIBILITY){

            @Override
            public void onClick(InventoryClickEvent event) {
                NameVisibility newValue = (NameVisibility)((Object)((Item.EnumItem)this.getItem()).changeValue());
                EntityEditorGUI.this.getInventory().setItem(10, ((Item.EnumItem)this.getItem()).getStack());
                EntityEditorGUI.this.display.setCustomNameVisibility(newValue);
            }
        });
        this.addIfAllowed(EditorItem.GLOW_TOGGLE, 2, new Button.InventoryButton<Item.BooleanItem>(this.items.GLOW_TOGGLE){

            @Override
            public void onClick(InventoryClickEvent event) {
                boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                EntityEditorGUI.this.getInventory().setItem(2, ((Item.BooleanItem)this.getItem()).getStack());
                EntityEditorGUI.this.display.setGlowing(newValue);
            }
        });
        this.addIfAllowed(EditorItem.GLOW_TOGGLE, 11, new Button.InventoryButton<Item.EnumItem<ChatColor>>(this.items.GLOW_COLOR){

            @Override
            public void onClick(InventoryClickEvent event) {
                ChatColor newValue = (ChatColor)((Item.EnumItem)this.getItem()).changeValue();
                while (!newValue.isColor()) {
                    newValue = (ChatColor)((Item.EnumItem)this.getItem()).changeValue();
                }
                EntityEditorGUI.this.getInventory().setItem(11, ((Item.EnumItem)this.getItem()).getStack());
                EntityEditorGUI.this.display.setGlowColor(newValue);
            }
        });
        this.addIfAllowed(EditorItem.TELEPORT, 18, new Button.InventoryButton<Item.ClickableItem>(this.items.TELEPORT){

            @Override
            public void onClick(InventoryClickEvent event) {
                event.getWhoClicked().closeInventory();
                event.getWhoClicked().teleport(EntityEditorGUI.this.display.getLocation());
            }
        });
        this.addIfAllowed(EditorItem.MOVE_HERE, 19, new Button.InventoryButton<Item.ClickableItem>(this.items.MOVE_HERE){

            @Override
            public void onClick(InventoryClickEvent event) {
                event.getWhoClicked().closeInventory();
                EntityEditorGUI.this.display.setLocation(event.getWhoClicked().getLocation());
                ((Item.ClickableItem)this.getItem()).setValue(Utils.locToString(event.getWhoClicked().getLocation()));
                EntityEditorGUI.this.getInventory().setItem(19, ((Item.ClickableItem)this.getItem()).getStack());
            }
        });
        this.addIfAllowed(EditorItem.CENTER, 20, new Button.InventoryButton<Item.ClickableItem>(this.items.CENTER){

            @Override
            public void onClick(InventoryClickEvent event) {
                Location loc = EntityEditorGUI.this.display.center();
                String location = loc.getX() + ";" + loc.getY() + ";" + loc.getZ();
                ((Item.ClickableItem)this.getItem()).setValue(location);
                EntityEditorGUI.this.getInventory().setItem(20, ((Item.ClickableItem)this.getItem()).getStack());
            }
        });
        BaseEntity baseEntity = this.display;
        if (baseEntity instanceof EntityDisplay) {
            EntityDisplay entityDisplay = (EntityDisplay)baseEntity;
            this.addMetadataButtons(entityDisplay);
        }
        this.addIfAllowed(EditorItem.REMOVE, 13, new Button.InventoryButton<Item.ClickableItem>(this.items.REMOVE){

            @Override
            public void onClick(InventoryClickEvent event) {
                EntityEditorGUI.this.shouldOpenPrevious = false;
                EntityEditorGUI.this.plugin.getDisplaysManager().removeDisplay((ADBaseEntity)EntityEditorGUI.this.display, true, true);
                event.getWhoClicked().closeInventory();
            }
        });
        super.decorate();
    }

    private void addMetadataButtons(final EntityDisplay display) {
        int i = 0;
        for (final Property<?> property : Property.getProperties()) {
            if (!display.isPropertyApplicable(property)) continue;
            Class<?> type = property.type();
            Object value = display.getPropertyValue(property);
            final int slot = (Integer)METADATA_SLOTS.get(i);
            if (type.isEnum()) {
                item = new Item.EnumItem(Material.REPEATING_COMMAND_BLOCK, property.name(), LORE, Enum.valueOf(type, value.toString().toUpperCase()), false);
                this.addButton(slot, new Button.InventoryButton<Item.EnumItem>(item){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        Object newValue = item.changeValue();
                        EntityEditorGUI.this.getInventory().setItem(slot, ((Item.EnumItem)this.getItem()).getStack());
                        display.setProperty(property, newValue);
                    }
                });
            } else if (Keyed.class.isAssignableFrom(type)) {
                item = new Item.RegistryItem(Material.REPEATING_COMMAND_BLOCK, property.name(), LORE, (Keyed)value, false, false);
                this.addButton(slot, new Button.InventoryButton<Item.RegistryItem>(item){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        Keyed newValue = item.changeValue();
                        EntityEditorGUI.this.getInventory().setItem(slot, ((Item.RegistryItem)this.getItem()).getStack());
                        display.setProperty(property, newValue);
                    }
                });
            } else if (Boolean.class.isAssignableFrom(type)) {
                item = new Item.BooleanItem(Material.REPEATING_COMMAND_BLOCK, property.name(), LORE, (boolean)((Boolean)value));
                this.addButton(slot, new Button.InventoryButton<Item.BooleanItem>(item){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        Boolean newValue = item.changeValue();
                        EntityEditorGUI.this.getInventory().setItem(slot, ((Item.BooleanItem)this.getItem()).getStack());
                        display.setProperty(property, newValue);
                    }
                });
            } else {
                item = new Item.ClickableItem(Material.REPEATING_COMMAND_BLOCK, property.name(), LORE, value.toString());
                this.addButton(slot, new Button.InventoryButton<Item.ClickableItem>(item){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                    }
                });
            }
            ++i;
        }
    }

    @Override
    public boolean handleChatEdit(Player player, String input) {
        if (!input.equalsIgnoreCase("cancel")) {
            this.display.setCustomName(input);
            Object item = this.getButton(1).getItem();
            ((Item)item).setValue((String)ComponentSerializer.getLegacyString(ComponentSerializer.deserialize(input)));
            this.getInventory().setItem(1, ((Item)item).getStack());
        }
        return true;
    }

    static {
        LORE.add("");
        LORE.add("&c&lPREVIEW FEATURE");
        LORE.add("&7Entity metadata is a WIP feature.");
        LORE.add("");
        LORE.add("&7This button has been added to the editor");
        LORE.add("&7to show how it could look like in the future.");
        LORE.add("&7Right now, changing the value will have no effect.");
        LORE.add("");
        LORE.add("&7This feature will be added in a future update!");
    }
}

