/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BaseDisplay;
import me.lucaaa.advanceddisplays.api.displays.BlockDisplay;
import me.lucaaa.advanceddisplays.api.displays.ItemDisplay;
import me.lucaaa.advanceddisplays.api.displays.TextDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import me.lucaaa.advanceddisplays.inventory.ADInventory;
import me.lucaaa.advanceddisplays.inventory.Button;
import me.lucaaa.advanceddisplays.inventory.inventories.BannerEditorGUI;
import me.lucaaa.advanceddisplays.inventory.inventories.BlockDataGUI;
import me.lucaaa.advanceddisplays.inventory.inventories.ColorGUI;
import me.lucaaa.advanceddisplays.inventory.inventories.EntityEditorGUI;
import me.lucaaa.advanceddisplays.inventory.items.ColorItems;
import me.lucaaa.advanceddisplays.inventory.items.EditorItems;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import me.lucaaa.advanceddisplays.nms_common.Version;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class DisplayEditorGUI
extends ADInventory {
    private final BaseDisplay display;
    private final Map<Player, EditAction> editMap = new HashMap<Player, EditAction>();

    public DisplayEditorGUI(AdvancedDisplays plugin, BaseDisplay display, List<EditorItem> disabledSettings) {
        super(plugin, Bukkit.createInventory(null, (int)27, (String)Utils.getColoredText("&6Editing " + display.getType().name() + " display: &e" + display.getName())), disabledSettings, null);
        this.display = display;
    }

    @Override
    public void decorate() {
        EditorItems items = new EditorItems(this.display, this.plugin.getNmsVersion());
        this.addIfAllowed(EditorItem.BLOCK_LIGHT, 0, new Button.InventoryButton<Item.StepItem>(items.BLOCK_LIGHT){

            @Override
            public void onClick(InventoryClickEvent event) {
                int newBrightness = ((Item.StepItem)this.getItem()).setNewItemBrightness(event.isLeftClick());
                DisplayEditorGUI.this.getInventory().setItem(0, ((Item.StepItem)this.getItem()).getStack());
                DisplayEditorGUI.this.display.setBrightness(new Display.Brightness(newBrightness, DisplayEditorGUI.this.display.getBrightness().getSkyLight()));
            }
        });
        this.addIfAllowed(EditorItem.SKY_LIGHT, 9, new Button.InventoryButton<Item.StepItem>(items.SKY_LIGHT){

            @Override
            public void onClick(InventoryClickEvent event) {
                int newBrightness = ((Item.StepItem)this.getItem()).setNewItemBrightness(event.isLeftClick());
                DisplayEditorGUI.this.getInventory().setItem(9, ((Item.StepItem)this.getItem()).getStack());
                DisplayEditorGUI.this.display.setBrightness(new Display.Brightness(DisplayEditorGUI.this.display.getBrightness().getBlockLight(), newBrightness));
            }
        });
        this.addIfAllowed(EditorItem.SHADOW_RADIUS, 1, new Button.InventoryButton<Item.StepItem>(items.SHADOW_RADIUS){

            @Override
            public void onClick(InventoryClickEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(event.isLeftClick(), event.isShiftClick(), 0.0);
                DisplayEditorGUI.this.getInventory().setItem(1, ((Item.StepItem)this.getItem()).getStack());
                DisplayEditorGUI.this.display.setShadow((float)newValue, DisplayEditorGUI.this.display.getShadowStrength());
            }
        });
        this.addIfAllowed(EditorItem.SHADOW_STRENGTH, 10, new Button.InventoryButton<Item.StepItem>(items.SHADOW_STRENGTH){

            @Override
            public void onClick(InventoryClickEvent event) {
                double newValue = ((Item.StepItem)this.getItem()).changeValue(event.isLeftClick(), event.isShiftClick(), 0.0);
                DisplayEditorGUI.this.getInventory().setItem(10, ((Item.StepItem)this.getItem()).getStack());
                DisplayEditorGUI.this.display.setShadow(DisplayEditorGUI.this.display.getShadowRadius(), (float)newValue);
            }
        });
        this.addIfAllowed(EditorItem.GLOW_TOGGLE, 2, new Button.InventoryButton<Item.BooleanItem>(items.GLOW_TOGGLE){

            @Override
            public void onClick(InventoryClickEvent event) {
                boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                DisplayEditorGUI.this.getInventory().setItem(2, ((Item.BooleanItem)this.getItem()).getStack());
                DisplayEditorGUI.this.display.setGlowing(newValue);
            }
        });
        this.addIfAllowed(EditorItem.GLOW_COLOR_SELECTOR, 11, new Button.InventoryButton<ColorItems.ColorPreview>(items.GLOW_COLOR_OVERRIDE){

            @Override
            public void onClick(InventoryClickEvent event) {
                DisplayEditorGUI.this.shouldOpenPrevious = false;
                ColorGUI inventory = new ColorGUI(DisplayEditorGUI.this.plugin, DisplayEditorGUI.this, DisplayEditorGUI.this.display, false, DisplayEditorGUI.this.display.getGlowColorOverride(), color -> {
                    DisplayEditorGUI.this.display.setGlowColorOverride((Color)color);
                    ((ColorItems.ColorPreview)this.getItem()).setColor(DisplayEditorGUI.this.display.getGlowColorOverride());
                    DisplayEditorGUI.this.getInventory().setItem(11, ((ColorItems.ColorPreview)this.getItem()).getStack());
                }, () -> DisplayEditorGUI.this.shouldOpenPrevious = true);
                DisplayEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
            }
        });
        this.addIfAllowed(EditorItem.BILLBOARD, 18, new Button.InventoryButton<Item.EnumItem<Display.Billboard>>(items.BILLBOARD){

            @Override
            public void onClick(InventoryClickEvent event) {
                Display.Billboard newBillboard = (Display.Billboard)((Item.EnumItem)this.getItem()).changeValue();
                DisplayEditorGUI.this.getInventory().setItem(18, ((Item.EnumItem)this.getItem()).getStack());
                DisplayEditorGUI.this.display.setBillboard(newBillboard);
            }
        });
        this.addIfAllowed(EditorItem.HITBOX_OVERRIDE, 19, new Button.InventoryButton<Item.BooleanItem>(items.HITBOX_OVERRIDE){

            @Override
            public void onClick(InventoryClickEvent event) {
                boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                DisplayEditorGUI.this.getInventory().setItem(12, ((Item.BooleanItem)this.getItem()).getStack());
                DisplayEditorGUI.this.display.setHitboxSize(newValue, DisplayEditorGUI.this.display.getHitboxWidth(), DisplayEditorGUI.this.display.getHitboxHeight());
            }
        });
        this.addButton(20, new Button.InventoryButton<Item.ClickableItem>(items.ENTITY_SETTINGS){

            @Override
            public void onClick(InventoryClickEvent event) {
                DisplayEditorGUI.this.shouldOpenPrevious = false;
                EntityEditorGUI inventory = new EntityEditorGUI(DisplayEditorGUI.this.plugin, DisplayEditorGUI.this.display, (List<EditorItem>)DisplayEditorGUI.this.disabledSettings, DisplayEditorGUI.this, () -> {
                    DisplayEditorGUI.this.updateGlowToggleItem();
                    DisplayEditorGUI.this.shouldOpenPrevious = true;
                });
                DisplayEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
            }
        });
        this.addIfAllowed(EditorItem.CURRENT_VALUE, 13, new Button.InventoryButton<Item.ClickableItem>(items.CURRENT_VALUE){

            @Override
            public void onClick(InventoryClickEvent event) {
                DisplayEditorGUI.this.plugin.getPlayersManager().getPlayerData((Player)event.getWhoClicked()).setChatEditing(true);
                event.getWhoClicked().closeInventory();
                if (DisplayEditorGUI.this.display.getType() != DisplayType.TEXT) {
                    DisplayEditorGUI.this.editMap.put((Player)event.getWhoClicked(), EditAction.CHANGE_MATERIAL);
                    if (DisplayEditorGUI.this.display.getType() == DisplayType.BLOCK) {
                        event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Enter the name of a valid block or \"cancel\" to keep the current one."));
                        event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6You can find a list of them here: &ehttps://hub.spigotmc.org/javadocs/spigot/org/bukkit/block/BlockType.html"));
                    } else {
                        event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Enter the name of a valid material or \"cancel\" to keep the current one."));
                        event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6You can find a list of them here: &ehttps://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html"));
                    }
                } else if (event.isRightClick()) {
                    DisplayEditorGUI.this.editMap.put((Player)event.getWhoClicked(), EditAction.REMOVE_TEXT);
                    event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Enter the name of the animation to remove. Valid animations: &e" + String.join((CharSequence)"&6, &e", ((TextDisplay)DisplayEditorGUI.this.display).getText().keySet())));
                    event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Type \"&ecancel&6\" to cancel the operation."));
                } else {
                    DisplayEditorGUI.this.editMap.put((Player)event.getWhoClicked(), EditAction.ADD_TEXT);
                    event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Enter the name of the animation to add along with its value. The name must not include spaces. You may use legacy color codes, minimessage format, placeholders and '\\n' to add a new line."));
                    event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Example: \"&emyAnimation3 <red>Hello %player%\\n<yellow>How are you?&6\""));
                    event.getWhoClicked().sendMessage(DisplayEditorGUI.this.plugin.getMessagesManager().getColoredMessage("&6Type \"&ecancel&6\" to cancel the operation."));
                }
            }
        });
        this.addIfAllowed(EditorItem.REMOVE, 22, new Button.InventoryButton<Item.ClickableItem>(items.REMOVE){

            @Override
            public void onClick(InventoryClickEvent event) {
                event.getWhoClicked().closeInventory();
                DisplayEditorGUI.this.plugin.getDisplaysManager().removeDisplay(DisplayEditorGUI.this.display.getName());
            }
        });
        switch (this.display.getType()) {
            case BLOCK: {
                this.setBlockData(items);
                break;
            }
            case ITEM: {
                final ItemDisplay itemDisplay = (ItemDisplay)this.display;
                this.addIfAllowed(EditorItem.ITEM_TRANSFORMATION, 8, new Button.InventoryButton<Item.EnumItem<ItemDisplay.ItemDisplayTransform>>(items.ITEM_TRANSFORMATION){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        ItemDisplay.ItemDisplayTransform newTransform = (ItemDisplay.ItemDisplayTransform)((Item.EnumItem)this.getItem()).changeValue();
                        DisplayEditorGUI.this.getInventory().setItem(8, ((Item.EnumItem)this.getItem()).getStack());
                        itemDisplay.setItemTransformation(newTransform);
                    }
                });
                this.addIfAllowed(EditorItem.ENCHANTED, 7, new Button.InventoryButton<Item.BooleanItem>(items.ENCHANTED){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        boolean isEnchanted = ((Item.BooleanItem)this.getItem()).changeValue();
                        DisplayEditorGUI.this.getInventory().setItem(7, ((Item.BooleanItem)this.getItem()).getStack());
                        itemDisplay.setEnchanted(isEnchanted);
                        DisplayEditorGUI.this.updateCurrentValue(itemDisplay.getItem().getItemMeta(), itemDisplay.getItem().getType().name());
                    }
                });
                Item<?> cmdItem = items.CUSTOM_MODEL_DATA;
                if (this.plugin.getNmsVersion().isEqualOrNewerThan(Version.v1_21_R3)) {
                    cmdItem.disable(List.of("Versions >=1.21.4 have more complex custom model data.", "Edit it through the display's config file."));
                }
                this.addIfAllowed(EditorItem.CUSTOM_MODEL_DATA, (Integer)METADATA_SLOTS.get(2), new Button.InventoryButton<Item<?>>(items.CUSTOM_MODEL_DATA){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        if (DisplayEditorGUI.this.plugin.getNmsVersion().isEqualOrNewerThan(Version.v1_21_R3)) {
                            return;
                        }
                        double newValue = ((Item.StepItem)this.getItem()).changeValue(event.isLeftClick(), event.isShiftClick(), 0.0);
                        DisplayEditorGUI.this.getInventory().setItem(((Integer)METADATA_SLOTS.get(2)).intValue(), ((Item)this.getItem()).getStack());
                        ItemStack item = itemDisplay.getItem().clone();
                        ItemMeta meta = item.getItemMeta();
                        if (meta != null) {
                            meta.setCustomModelData(Integer.valueOf((int)newValue));
                            item.setItemMeta(meta);
                            itemDisplay.setItem(item);
                            DisplayEditorGUI.this.getInventory().setItem(13, item);
                        }
                    }
                });
                this.addMetadataButtons(itemDisplay);
                break;
            }
            case TEXT: {
                final TextDisplay textDisplay = (TextDisplay)this.display;
                this.addIfAllowed(EditorItem.TEXT_ALIGNMENT, 8, new Button.InventoryButton<Item.EnumItem<TextDisplay.TextAlignment>>(items.TEXT_ALIGNMENT){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        TextDisplay.TextAlignment newAlignment = (TextDisplay.TextAlignment)((Item.EnumItem)this.getItem()).changeValue();
                        DisplayEditorGUI.this.getInventory().setItem(8, ((Item.EnumItem)this.getItem()).getStack());
                        textDisplay.setAlignment(newAlignment);
                    }
                });
                this.addIfAllowed(EditorItem.BACKGROUND_COLOR, 7, new Button.InventoryButton<ColorItems.ColorPreview>(items.BACKGROUND_COLOR){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        DisplayEditorGUI.this.shouldOpenPrevious = false;
                        ColorGUI inventory = new ColorGUI(DisplayEditorGUI.this.plugin, DisplayEditorGUI.this, DisplayEditorGUI.this.display, true, textDisplay.getBackgroundColor(), color -> {
                            textDisplay.setBackgroundColor((Color)color);
                            ((ColorItems.ColorPreview)this.getItem()).setColor((Color)color);
                            DisplayEditorGUI.this.getInventory().setItem(7, ((ColorItems.ColorPreview)this.getItem()).getStack());
                        }, () -> DisplayEditorGUI.this.shouldOpenPrevious = true);
                        DisplayEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
                    }
                });
                this.addIfAllowed(EditorItem.LINE_WIDTH, 6, new Button.InventoryButton<Item.StepItem>(items.LINE_WIDTH){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        int newValue = (int)((Item.StepItem)this.getItem()).changeValue(event.isLeftClick(), event.isShiftClick(), 0.0);
                        DisplayEditorGUI.this.getInventory().setItem(6, ((Item.StepItem)this.getItem()).getStack());
                        textDisplay.setLineWidth(newValue);
                    }
                });
                this.addIfAllowed(EditorItem.TEXT_OPACITY, 17, new Button.InventoryButton<Item.StepItem>(items.TEXT_OPACITY){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        byte newValue = (byte)((Item.StepItem)this.getItem()).changeValue(event.isLeftClick(), event.isShiftClick(), -1.0, 127.0);
                        DisplayEditorGUI.this.getInventory().setItem(17, ((Item.StepItem)this.getItem()).getStack());
                        textDisplay.setTextOpacity(newValue);
                    }
                });
                this.addIfAllowed(EditorItem.USE_DEFAULT_BACKGROUND, 16, new Button.InventoryButton<Item.BooleanItem>(items.USE_DEFAULT_BACKGROUND){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                        DisplayEditorGUI.this.getInventory().setItem(16, ((Item.BooleanItem)this.getItem()).getStack());
                        textDisplay.setUseDefaultBackground(newValue);
                    }
                });
                this.addIfAllowed(EditorItem.SEE_THROUGH, 15, new Button.InventoryButton<Item.BooleanItem>(items.SEE_THROUGH){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                        DisplayEditorGUI.this.getInventory().setItem(15, ((Item.BooleanItem)this.getItem()).getStack());
                        textDisplay.setSeeThrough(newValue);
                    }
                });
                this.addIfAllowed(EditorItem.SHADOWED, 26, new Button.InventoryButton<Item.BooleanItem>(items.SHADOWED){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        boolean newValue = ((Item.BooleanItem)this.getItem()).changeValue();
                        DisplayEditorGUI.this.getInventory().setItem(26, ((Item.BooleanItem)this.getItem()).getStack());
                        textDisplay.setShadowed(newValue);
                    }
                });
                this.addIfAllowed(EditorItem.ANIMATION_TIME, 25, new Button.InventoryButton<Item.StepItem>(items.ANIMATION_TIME){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        int newValue = (int)((Item.StepItem)this.getItem()).changeValue(event.isLeftClick(), event.isShiftClick(), 1.0);
                        DisplayEditorGUI.this.getInventory().setItem(25, ((Item.StepItem)this.getItem()).getStack());
                        textDisplay.setAnimationTime(newValue);
                    }
                });
                this.addIfAllowed(EditorItem.REFRESH_TIME, 24, new Button.InventoryButton<Item.StepItem>(items.REFRESH_TIME){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        int newValue = (int)((Item.StepItem)this.getItem()).changeValue(event.isLeftClick(), event.isShiftClick(), 0.0);
                        DisplayEditorGUI.this.getInventory().setItem(24, ((Item.StepItem)this.getItem()).getStack());
                        textDisplay.setRefreshTime(newValue);
                    }
                });
            }
        }
        super.decorate();
    }

    private void setBlockData(EditorItems items) {
        final BlockDisplay blockDisplay = (BlockDisplay)this.display;
        String data = blockDisplay.getBlock().getAsString();
        if (data.contains("[")) {
            this.addIfAllowed(EditorItem.BLOCK_DATA, 8, new Button.InventoryButton<Item.ClickableItem>(items.BLOCK_DATA){

                @Override
                public void onClick(InventoryClickEvent event) {
                    DisplayEditorGUI.this.shouldOpenPrevious = false;
                    BlockDataGUI inventory = new BlockDataGUI(DisplayEditorGUI.this.plugin, DisplayEditorGUI.this, blockDisplay, blockData -> {
                        blockDisplay.setBlock((BlockData)blockData);
                        ((Item.ClickableItem)this.getItem()).setValue(blockData.toString());
                        DisplayEditorGUI.this.getInventory().setItem(8, ((Item.ClickableItem)this.getItem()).getStack());
                    }, () -> DisplayEditorGUI.this.shouldOpenPrevious = true);
                    DisplayEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
                }
            });
            items.BLOCK_DATA.setValue(blockDisplay.getBlock().getAsString());
        } else {
            this.addIfAllowed(EditorItem.BLOCK_DATA, 8, new Button.Unclickable<Item.ClickableItem>(items.BLOCK_DATA));
            items.BLOCK_DATA.setValue("This block has no data");
        }
        this.getInventory().setItem(8, items.BLOCK_DATA.getStack());
    }

    @Override
    public boolean handleChatEdit(Player player, String input) {
        if (!input.equalsIgnoreCase("cancel")) {
            Item.ClickableItem item = (Item.ClickableItem)this.getButton(13).getItem();
            switch (this.editMap.get(player).ordinal()) {
                case 1: {
                    ADTextDisplay textDisplay = (ADTextDisplay)this.display;
                    if (!textDisplay.removeText(input)) {
                        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe animation &b" + input + " &cdoes not exist!"));
                        return false;
                    }
                    player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aThe animation &e" + input + " &a has been removed. If it didn't exist, nothing will be changed."));
                    ArrayList<String> lore = new ArrayList<String>();
                    lore.add("Changes the text that is being displayed");
                    lore.add("");
                    lore.add("&7Use &cLEFT_CLICK &7to add an animation");
                    if (textDisplay.isNotEmpty()) {
                        lore.add("&7Use &cRIGHT_CLICK &7to remove an animation");
                    }
                    lore.add("");
                    item.setLore(lore);
                    item.setValue(textDisplay.getTextsNumber() + " text animation(s)");
                    break;
                }
                case 0: {
                    String joined;
                    ADTextDisplay textDisplay = (ADTextDisplay)this.display;
                    int firstSpace = input.indexOf(" ");
                    if (firstSpace == -1) {
                        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe text you have entered is invalid. Remember that the format is &b<animation name (no spaces)> <animation text>"));
                        return false;
                    }
                    String identifier = input.substring(0, firstSpace);
                    if (!textDisplay.addText(identifier, joined = input.substring(firstSpace + 1).replace("\\n", "\n"))) {
                        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cAn animation with the name &b" + identifier + " &calready exists!"));
                        return false;
                    }
                    player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aThe animation &e" + identifier + " &ahas been created and added after the last animation."));
                    ArrayList<String> lore = new ArrayList<String>();
                    lore.add("Changes the text that is being displayed");
                    lore.add("");
                    lore.add("&7Use &cLEFT_CLICK &7to add an animation");
                    if (textDisplay.isNotEmpty()) {
                        lore.add("&7Use &cRIGHT_CLICK &7to remove an animation");
                    }
                    lore.add("");
                    item.setLore(lore);
                    item.setValue(textDisplay.getText().size() + " text animation(s)");
                    break;
                }
                case 2: {
                    Material material = Material.getMaterial((String)input.toUpperCase());
                    if (material == null) {
                        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&b" + input + " &cis not a valid material!"));
                        return false;
                    }
                    if (material == Material.AIR) {
                        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe material cannot be air!"));
                        return false;
                    }
                    if (this.display.getType() == DisplayType.ITEM) {
                        ItemDisplay itemDisplay = (ItemDisplay)this.display;
                        boolean enchanted = itemDisplay.isEnchanted();
                        itemDisplay.setItem(new ItemStack(material));
                        itemDisplay.setEnchanted(enchanted);
                        break;
                    }
                    try {
                        ((BlockDisplay)this.display).setBlock(material.createBlockData());
                        break;
                    }
                    catch (IllegalArgumentException | NullPointerException ignored) {
                        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&b" + material.name() + " &cis not a valid block!"));
                        return false;
                    }
                }
            }
            this.clearButtons();
            this.decorate();
        }
        this.editMap.remove(player);
        return true;
    }

    public void updateCurrentValue(ItemMeta meta, String value) {
        if (meta == null) {
            return;
        }
        Item.ClickableItem item = (Item.ClickableItem)this.getButton(13).getItem();
        item.setValue(value);
        item.applyMeta(meta);
        this.getInventory().setItem(13, item.getStack());
    }

    public void updateGlowToggleItem() {
        if (this.disabledSettings.contains((Object)EditorItem.GLOW_TOGGLE)) {
            return;
        }
        Item.BooleanItem item = (Item.BooleanItem)this.getButton(2).getItem();
        item.setValue(this.display.isGlowing());
        this.getInventory().setItem(2, item.getStack());
    }

    private void addMetadataButtons(final ItemDisplay display) {
        final ItemStack item = display.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        final int slot = (Integer)METADATA_SLOTS.get(3);
        if (meta instanceof PotionMeta) {
            PotionMeta potion = (PotionMeta)meta;
            final Color color = potion.getColor() == null ? Color.ORANGE : potion.getColor();
            ColorItems.ColorPreview preview = new ColorItems.ColorPreview(item.getType(), "Potion color", List.of("", "&7Use &cRIGHT_CLICK &7to reset"), color, ColorItems.ColorComponent.ALL, false);
            this.addIfAllowed(EditorItem.ITEM_META, slot, new Button.InventoryButton<ColorItems.ColorPreview>(preview){

                @Override
                public void onClick(InventoryClickEvent event) {
                    if (event.isRightClick()) {
                        ((ColorItems.ColorPreview)this.getItem()).setColor(Color.ORANGE);
                        DisplayEditorGUI.this.getInventory().setItem(slot, ((ColorItems.ColorPreview)this.getItem()).getStack());
                        DisplayEditorGUI.this.setPotionColor(display, null);
                        return;
                    }
                    DisplayEditorGUI.this.shouldOpenPrevious = false;
                    ColorGUI inventory = new ColorGUI(DisplayEditorGUI.this.plugin, DisplayEditorGUI.this, item.getType(), display, false, color, color -> {
                        ((ColorItems.ColorPreview)this.getItem()).setColor((Color)color);
                        DisplayEditorGUI.this.getInventory().setItem(slot, ((ColorItems.ColorPreview)this.getItem()).getStack());
                        DisplayEditorGUI.this.setPotionColor(display, (Color)color);
                    }, () -> DisplayEditorGUI.this.shouldOpenPrevious = true);
                    DisplayEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
                }
            });
        } else if (meta instanceof ArmorMeta) {
            ArmorMeta armor = (ArmorMeta)meta;
            final TrimPattern[] pattern = new TrimPattern[]{armor.getTrim() == null ? null : armor.getTrim().getPattern()};
            final TrimMaterial[] material = new TrimMaterial[]{armor.getTrim() == null ? null : armor.getTrim().getMaterial()};
            Item.RegistryItem patternItem = new Item.RegistryItem(this.getMatFromPattern(pattern[0]), "Armor trim pattern", List.of("Changes the armor's trim pattern"), (Keyed)(pattern[0] == null ? TrimPattern.SENTRY : pattern[0]), true, !armor.hasTrim());
            this.addIfAllowed(EditorItem.ITEM_META, slot, new Button.InventoryButton<Item.RegistryItem>(patternItem){

                @Override
                public void onClick(InventoryClickEvent event) {
                    if (TrimPattern.SENTRY == null) {
                        return;
                    }
                    pattern[0] = (TrimPattern)((Item.RegistryItem)this.getItem()).changeValue();
                    DisplayEditorGUI.this.setArmorTrim(display, pattern[0], material[0], slot, (Integer)METADATA_SLOTS.get(4));
                }
            });
            Item.RegistryItem materialItem = new Item.RegistryItem(this.getMatFromTrimMat(material[0]), "Armor trim material", List.of("Changes the armor's trim material"), (Keyed)(material[0] == null ? TrimMaterial.NETHERITE : material[0]), true, !armor.hasTrim());
            this.addIfAllowed(EditorItem.ITEM_META, (Integer)METADATA_SLOTS.get(4), new Button.InventoryButton<Item.RegistryItem>(materialItem){

                @Override
                public void onClick(InventoryClickEvent event) {
                    if (TrimMaterial.DIAMOND == null) {
                        return;
                    }
                    material[0] = (TrimMaterial)((Item.RegistryItem)this.getItem()).changeValue();
                    DisplayEditorGUI.this.setArmorTrim(display, pattern[0], material[0], slot, (Integer)METADATA_SLOTS.get(4));
                }
            });
            if (meta instanceof LeatherArmorMeta) {
                final LeatherArmorMeta leatherArmor = (LeatherArmorMeta)meta;
                ColorItems.ColorPreview preview = new ColorItems.ColorPreview(item.getType(), "Armor color", List.of("", "&7Use &cRIGHT_CLICK &7to reset"), leatherArmor.getColor(), ColorItems.ColorComponent.ALL, false);
                this.addIfAllowed(EditorItem.ITEM_META, (Integer)METADATA_SLOTS.get(5), new Button.InventoryButton<ColorItems.ColorPreview>(preview){

                    @Override
                    public void onClick(InventoryClickEvent event) {
                        if (event.isRightClick()) {
                            ((ColorItems.ColorPreview)this.getItem()).setColor(DisplayEditorGUI.this.plugin.getServer().getItemFactory().getDefaultLeatherColor());
                            DisplayEditorGUI.this.getInventory().setItem(((Integer)METADATA_SLOTS.get(5)).intValue(), ((ColorItems.ColorPreview)this.getItem()).getStack());
                            DisplayEditorGUI.this.setArmorColor(display, null);
                            return;
                        }
                        DisplayEditorGUI.this.shouldOpenPrevious = false;
                        ColorGUI inventory = new ColorGUI(DisplayEditorGUI.this.plugin, DisplayEditorGUI.this, item.getType(), display, false, leatherArmor.getColor(), color -> {
                            ((ColorItems.ColorPreview)this.getItem()).setColor((Color)color);
                            DisplayEditorGUI.this.getInventory().setItem(((Integer)METADATA_SLOTS.get(5)).intValue(), ((ColorItems.ColorPreview)this.getItem()).getStack());
                            DisplayEditorGUI.this.setArmorColor(display, (Color)color);
                        }, () -> DisplayEditorGUI.this.shouldOpenPrevious = true);
                        DisplayEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
                    }
                });
            }
        } else if (meta instanceof BannerMeta) {
            final BannerMeta banner = (BannerMeta)meta;
            Item.ClickableItem bannerItem = new Item.ClickableItem(item, "Banner patterns", List.of("Changes the banner's pattern"), null);
            this.addIfAllowed(EditorItem.ITEM_META, slot, new Button.InventoryButton<Item.ClickableItem>(bannerItem){
                private BannerMeta meta;
                {
                    super(item2);
                    this.meta = banner;
                }

                @Override
                public void onClick(InventoryClickEvent event) {
                    DisplayEditorGUI.this.shouldOpenPrevious = false;
                    BannerEditorGUI inventory = new BannerEditorGUI(DisplayEditorGUI.this.plugin, DisplayEditorGUI.this, item.getType(), this.meta, meta -> {
                        this.meta = meta;
                        ItemStack item2 = display.getItem().clone();
                        item2.setItemMeta((ItemMeta)meta);
                        display.setItem(item2);
                        ((Item.ClickableItem)this.getItem()).applyMeta(meta.clone());
                        DisplayEditorGUI.this.getInventory().setItem(slot, ((Item.ClickableItem)this.getItem()).getStack());
                        DisplayEditorGUI.this.updateCurrentValue((ItemMeta)meta, item2.getType().name());
                    }, () -> DisplayEditorGUI.this.shouldOpenPrevious = true);
                    DisplayEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
                }
            });
        } else if (meta instanceof CompassMeta) {
            CompassMeta compass = (CompassMeta)meta;
            String location = compass.hasLodestone() ? Utils.locToString(Objects.requireNonNull(compass.getLodestone())) : "No lodestone";
            Item.ClickableItem lodestoneLocation = new Item.ClickableItem(Material.LODESTONE, "Compass lodestone", List.of("Changes the compass' lodestone", "", "&7Use &cRIGHT_CLICK &7to reset"), location);
            this.addIfAllowed(EditorItem.ITEM_META, slot, new Button.InventoryButton<Item.ClickableItem>(lodestoneLocation){

                @Override
                public void onClick(InventoryClickEvent event) {
                    boolean sameWorld = event.getWhoClicked().getWorld().equals((Object)display.getLocation().getWorld());
                    if (event.isRightClick() || !sameWorld) {
                        ((Item.ClickableItem)this.getItem()).setValue(sameWorld ? "No lodestone" : "Player and display world don't match!");
                        DisplayEditorGUI.this.getInventory().setItem(slot, ((Item.ClickableItem)this.getItem()).getStack());
                        DisplayEditorGUI.this.setCompassLodestone(display, null);
                        return;
                    }
                    Location loc = event.getWhoClicked().getLocation();
                    ((Item.ClickableItem)this.getItem()).setValue(Utils.locToString(loc));
                    DisplayEditorGUI.this.getInventory().setItem(slot, ((Item.ClickableItem)this.getItem()).getStack());
                    DisplayEditorGUI.this.setCompassLodestone(display, loc);
                }
            });
        } else if (meta instanceof BundleMeta) {
            BundleMeta bundle = (BundleMeta)meta;
            Item.BooleanItem hasItems = new Item.BooleanItem(item, "Has items", List.of("Changes whether the bundle has items or not"), bundle.hasItems(), false);
            this.addIfAllowed(EditorItem.ITEM_META, slot, new Button.InventoryButton<Item.BooleanItem>(hasItems){

                @Override
                public void onClick(InventoryClickEvent event) {
                    boolean hasItems = ((Item.BooleanItem)this.getItem()).changeValue();
                    ItemStack item = display.getItem().clone();
                    ItemMeta meta = item.getItemMeta();
                    if (meta instanceof BundleMeta) {
                        BundleMeta bundleMeta = (BundleMeta)meta;
                        if (hasItems) {
                            bundleMeta.addItem(new ItemStack(Material.DIAMOND, 64));
                        } else {
                            bundleMeta.setItems(List.of());
                        }
                        item.setItemMeta(meta);
                        display.setItem(item);
                        ((Item.BooleanItem)this.getItem()).applyMeta(meta.clone());
                        DisplayEditorGUI.this.getInventory().setItem(slot, ((Item.BooleanItem)this.getItem()).getStack());
                        DisplayEditorGUI.this.updateCurrentValue(meta, item.getType().name());
                    }
                }
            });
        } else if (meta instanceof AxolotlBucketMeta) {
            AxolotlBucketMeta bucketMeta = (AxolotlBucketMeta)meta;
            Item.EnumItem<Axolotl.Variant> bucketItem = new Item.EnumItem<Axolotl.Variant>(item, "Axolotl variant", List.of("Changes the variant of the axolotl"), bucketMeta.hasVariant() ? bucketMeta.getVariant() : Axolotl.Variant.LUCY, false);
            this.addIfAllowed(EditorItem.ITEM_META, slot, new Button.InventoryButton<Item.EnumItem<Axolotl.Variant>>(bucketItem){

                @Override
                public void onClick(InventoryClickEvent event) {
                    Axolotl.Variant newVariant = (Axolotl.Variant)((Item.EnumItem)this.getItem()).changeValue();
                    ItemStack item = display.getItem().clone();
                    ItemMeta meta = item.getItemMeta();
                    if (meta instanceof AxolotlBucketMeta) {
                        AxolotlBucketMeta axolotlBucketMeta = (AxolotlBucketMeta)meta;
                        axolotlBucketMeta.setVariant(newVariant);
                        item.setItemMeta(meta);
                        display.setItem(item);
                        ((Item.EnumItem)this.getItem()).applyMeta(meta.clone());
                        DisplayEditorGUI.this.getInventory().setItem(slot, ((Item.EnumItem)this.getItem()).getStack());
                        DisplayEditorGUI.this.updateCurrentValue(meta, item.getType().name());
                    }
                }
            });
        } else if (meta instanceof CrossbowMeta) {
            ItemStack firstProjectile;
            CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
            CrossbowAmmo ammo = !crossbowMeta.getChargedProjectiles().isEmpty() ? ((firstProjectile = (ItemStack)crossbowMeta.getChargedProjectiles().get(0)).getType() == Material.FIREWORK_ROCKET ? CrossbowAmmo.ROCKET : CrossbowAmmo.ARROW) : CrossbowAmmo.NONE;
            Item.EnumItem<CrossbowAmmo> ammoItem = new Item.EnumItem<CrossbowAmmo>(item, "Crossbow ammo", List.of("Changes the ammo loaded into the crossbow"), ammo, false);
            this.addIfAllowed(EditorItem.ITEM_META, slot, new Button.InventoryButton<Item.EnumItem<CrossbowAmmo>>(ammoItem){

                @Override
                public void onClick(InventoryClickEvent event) {
                    CrossbowAmmo newAmmo = (CrossbowAmmo)((Object)((Item.EnumItem)this.getItem()).changeValue());
                    ItemStack item = display.getItem().clone();
                    ItemMeta meta = item.getItemMeta();
                    if (meta instanceof CrossbowMeta) {
                        CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
                        crossbowMeta.setChargedProjectiles(newAmmo.getItems());
                        item.setItemMeta(meta);
                        display.setItem(item);
                        ((Item.EnumItem)this.getItem()).applyMeta(meta.clone());
                        DisplayEditorGUI.this.getInventory().setItem(slot, ((Item.EnumItem)this.getItem()).getStack());
                        DisplayEditorGUI.this.updateCurrentValue(meta, item.getType().name());
                    }
                }
            });
        }
    }

    private void setPotionColor(ItemDisplay display, Color color) {
        ItemStack item = display.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setColor(color);
            item.setItemMeta(meta);
            display.setItem(item);
            this.updateCurrentValue(meta, item.getType().name());
        }
    }

    private void setArmorColor(ItemDisplay display, Color color) {
        ItemStack item = display.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmor = (LeatherArmorMeta)meta;
            leatherArmor.setColor(color);
            item.setItemMeta(meta);
            display.setItem(item);
            this.updateCurrentValue(meta, item.getType().name());
        }
    }

    private void setArmorTrim(ItemDisplay display, TrimPattern pattern, TrimMaterial material, int patternSlot, int matSlot) {
        ItemStack item = display.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof ArmorMeta) {
            ArmorMeta armorMeta = (ArmorMeta)meta;
            if (pattern == null || material == null) {
                armorMeta.setTrim(null);
            } else {
                armorMeta.setTrim(new ArmorTrim(material, pattern));
            }
            item.setItemMeta(meta);
            display.setItem(item);
            this.updateCurrentValue(meta, item.getType().name());
        }
        Item.RegistryItem patternItem = (Item.RegistryItem)this.getButton(patternSlot).getItem();
        patternItem.getStack().setType(this.getMatFromPattern(pattern));
        this.getInventory().setItem(patternSlot, patternItem.getStack());
        Item.RegistryItem materialItem = (Item.RegistryItem)this.getButton(matSlot).getItem();
        materialItem.getStack().setType(this.getMatFromTrimMat(material));
        this.getInventory().setItem(matSlot, materialItem.getStack());
    }

    private void setCompassLodestone(ItemDisplay display, Location lodestone) {
        ItemStack item = display.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof CompassMeta) {
            CompassMeta compass = (CompassMeta)meta;
            compass.setLodestone(lodestone);
            compass.setLodestoneTracked(lodestone != null);
            item.setItemMeta(meta);
            display.setItem(item);
            this.updateCurrentValue(meta, item.getType().name());
        }
    }

    private Material getMatFromPattern(TrimPattern pattern) {
        if (pattern == null) {
            return Material.BARRIER;
        }
        try {
            return Material.valueOf((String)(pattern.getKey().getKey().toUpperCase() + "_ARMOR_TRIM_SMITHING_TEMPLATE"));
        }
        catch (IllegalArgumentException e) {
            return Material.BARRIER;
        }
    }

    private Material getMatFromTrimMat(TrimMaterial mat) {
        if (mat == null) {
            return Material.BARRIER;
        }
        return switch (mat.getKey().getKey().toLowerCase()) {
            case "amethyst" -> Material.AMETHYST_SHARD;
            case "copper" -> Material.COPPER_INGOT;
            case "diamond" -> Material.DIAMOND;
            case "emerald" -> Material.EMERALD;
            case "gold" -> Material.GOLD_INGOT;
            case "iron" -> Material.IRON_INGOT;
            case "lapis" -> Material.LAPIS_LAZULI;
            case "netherite" -> Material.NETHERITE_INGOT;
            case "quartz" -> Material.QUARTZ;
            case "redstone" -> Material.REDSTONE;
            case "resin" -> Material.getMaterial((String)"RESIN_BRICK");
            default -> Material.BARRIER;
        };
    }

    private static enum EditAction {
        ADD_TEXT,
        REMOVE_TEXT,
        CHANGE_MATERIAL;

    }

    public static enum CrossbowAmmo {
        NONE(null),
        ARROW(new ItemStack(Material.ARROW)),
        ROCKET(new ItemStack(Material.FIREWORK_ROCKET));

        private final List<ItemStack> items;

        private CrossbowAmmo(ItemStack item) {
            this.items = item == null ? List.of() : List.of(item);
        }

        public List<ItemStack> getItems() {
            return this.items;
        }
    }
}

