/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.inventories;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BlockDisplay;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.inventory.ADInventory;
import me.lucaaa.advanceddisplays.inventory.Button;
import me.lucaaa.advanceddisplays.inventory.inventories.DisplayEditorGUI;
import me.lucaaa.advanceddisplays.inventory.items.GlobalItems;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class BlockDataGUI
extends ADInventory {
    private final Consumer<BlockData> onDone;
    private final Material material;
    private final Map<String, String> dataMap = new HashMap<String, String>();
    private final Map<Player, String> editMap = new HashMap<Player, String>();

    public BlockDataGUI(AdvancedDisplays plugin, DisplayEditorGUI previousInventory, BlockDisplay display, Consumer<BlockData> onDone, Runnable onClose) {
        super(plugin, Bukkit.createInventory(null, (int)27, (String)Utils.getColoredText("&6Editing block data of: &e" + display.getName())), List.of(), previousInventory, onClose);
        this.onDone = onDone;
        this.material = display.getBlock().getMaterial();
        BlockData blockData = display.getBlock();
        String fullData = blockData.getAsString().substring(blockData.getAsString().indexOf("[") + 1, blockData.getAsString().lastIndexOf("]"));
        for (String data : fullData.split(",")) {
            String[] dataPart = data.split("=");
            this.dataMap.put(dataPart[0], dataPart[1]);
        }
    }

    @Override
    public void decorate() {
        int slot = 0;
        for (final Map.Entry<String, String> entry : this.dataMap.entrySet()) {
            this.addButton(slot, new Button.InventoryButton<Item.ClickableItem>(this.create(entry.getKey(), entry.getValue())){

                @Override
                public void onClick(InventoryClickEvent event) {
                    BlockDataGUI.this.editMap.put((Player)event.getWhoClicked(), (String)entry.getKey());
                    BlockDataGUI.this.plugin.getPlayersManager().getPlayerData((Player)event.getWhoClicked()).setChatEditing(true);
                    event.getWhoClicked().closeInventory();
                    event.getWhoClicked().sendMessage(Utils.getColoredText("&6Enter the new value for the &e" + (String)entry.getKey() + " &6data value. Type &ecancel &6to cancel the operation."));
                }
            });
            ++slot;
        }
        this.addButton(18, new Button.InventoryButton<Item.ClickableItem>(GlobalItems.cancel(this.plugin)){

            @Override
            public void onClick(InventoryClickEvent event) {
                event.getWhoClicked().closeInventory();
            }
        });
        this.addButton(26, new Button.InventoryButton<Item.ClickableItem>(GlobalItems.done(this.plugin)){

            @Override
            public void onClick(InventoryClickEvent event) {
                Object blockData = "minecraft:" + BlockDataGUI.this.material.name().toLowerCase() + "[";
                ArrayList<CallSite> dataParts = new ArrayList<CallSite>();
                for (Map.Entry<String, String> entry : BlockDataGUI.this.dataMap.entrySet()) {
                    dataParts.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue())));
                }
                blockData = ((String)blockData).concat(String.join((CharSequence)",", dataParts));
                BlockDataGUI.this.onDone.accept(BlockDataGUI.this.plugin.getServer().createBlockData((String)blockData + "]"));
                event.getWhoClicked().closeInventory();
            }
        });
        super.decorate();
    }

    @Override
    public boolean handleChatEdit(Player player, String input) {
        if (!input.equalsIgnoreCase("cancel")) {
            this.dataMap.put(this.editMap.get(player), input);
            this.decorate();
        }
        this.editMap.remove(player);
        return true;
    }

    private Item.ClickableItem create(String title, String value) {
        return new Item.ClickableItem(Material.COMMAND_BLOCK, String.valueOf(ChatColor.GOLD) + title, List.of("", "&7Click to change"), value);
    }
}

