/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.inventory.ADInventory;
import me.lucaaa.advanceddisplays.inventory.Button;
import me.lucaaa.advanceddisplays.inventory.inventories.SelectorGUI;
import me.lucaaa.advanceddisplays.inventory.items.GlobalItems;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BannerEditorGUI
extends ADInventory {
    private final int startLayer;
    private final Map<Integer, Pattern> patterns;
    private final Material banner;
    private final Consumer<BannerMeta> onDone;
    private final Runnable onClose;
    private final ItemStack DISABLED_LAYER;

    public BannerEditorGUI(AdvancedDisplays plugin, ADInventory previous, Material banner, BannerMeta meta, Consumer<BannerMeta> onDone, Runnable onClose) {
        this(plugin, previous, 1, BannerEditorGUI.getPatterns(meta), banner, onDone, onClose);
    }

    public BannerEditorGUI(AdvancedDisplays plugin, ADInventory previous, int startLayer, Map<Integer, Pattern> patterns, Material banner, Consumer<BannerMeta> onDone, Runnable onClose) {
        super(plugin, Bukkit.createInventory(null, (int)54, (String)Utils.getColoredText("&6Banner editor")), List.of(), previous, onClose);
        this.startLayer = startLayer;
        this.patterns = patterns;
        this.banner = banner;
        this.onDone = onDone;
        this.onClose = onClose;
        this.DISABLED_LAYER = new ItemStack(Material.BARRIER);
        ItemMeta disabledMeta = Objects.requireNonNull(this.DISABLED_LAYER.getItemMeta());
        disabledMeta.setDisplayName(Utils.getColoredText("&cClick the button on top to add this layer."));
        Utils.hideFlags(disabledMeta);
        this.DISABLED_LAYER.setItemMeta(disabledMeta);
    }

    @Override
    public void decorate() {
        int slot = 0;
        for (int layer = this.startLayer; layer <= this.startLayer + 8; ++layer) {
            if (this.patterns.get(layer) == null) {
                this.setDisabledLayer(slot, layer);
                ++slot;
                continue;
            }
            Pattern pattern = this.patterns.get(layer);
            this.setLayerButtons(slot, layer, pattern.getPattern(), pattern.getColor());
            ++slot;
        }
        if (this.startLayer > 1) {
            this.addButton(45, new Button.InventoryButton<Item.ClickableItem>(new Item.ClickableItem(this.plugin.getHeadCacheManager().LEFT, "Previous layer", List.of("See one more layer to the bottom"), null)){

                @Override
                public void onClick(InventoryClickEvent event) {
                    BannerEditorGUI.this.shouldOpenPrevious = false;
                    BannerEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), new BannerEditorGUI(BannerEditorGUI.this.plugin, BannerEditorGUI.this.previous, BannerEditorGUI.this.startLayer - 1, BannerEditorGUI.this.patterns, BannerEditorGUI.this.banner, BannerEditorGUI.this.onDone, BannerEditorGUI.this.onClose));
                }
            });
        }
        this.addButton(48, new Button.InventoryButton<Item.ClickableItem>(GlobalItems.cancel(this.plugin)){

            @Override
            public void onClick(InventoryClickEvent event) {
                event.getWhoClicked().closeInventory();
            }
        });
        this.getInventory().setItem(49, this.previewBanner());
        this.addButton(50, new Button.InventoryButton<Item.ClickableItem>(GlobalItems.done(this.plugin)){

            @Override
            public void onClick(InventoryClickEvent event) {
                BannerEditorGUI.this.onDone.accept(BannerEditorGUI.this.getMeta());
                event.getWhoClicked().closeInventory();
            }
        });
        this.addButton(53, new Button.InventoryButton<Item.ClickableItem>(new Item.ClickableItem(this.plugin.getHeadCacheManager().RIGHT, "Next layer", List.of("See one more layer on top"), null)){

            @Override
            public void onClick(InventoryClickEvent event) {
                BannerEditorGUI.this.shouldOpenPrevious = false;
                BannerEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), new BannerEditorGUI(BannerEditorGUI.this.plugin, BannerEditorGUI.this.previous, BannerEditorGUI.this.startLayer + 1, BannerEditorGUI.this.patterns, BannerEditorGUI.this.banner, BannerEditorGUI.this.onDone, BannerEditorGUI.this.onClose));
            }
        });
        super.decorate();
    }

    private void setDisabledLayer(int topSlotIndex, int layer) {
        this.patterns.put(layer, null);
        this.removeButton(topSlotIndex + 18);
        this.removeButton(topSlotIndex + 27);
        this.getInventory().setItem(topSlotIndex + 18, this.DISABLED_LAYER);
        this.getInventory().setItem(topSlotIndex + 27, this.DISABLED_LAYER);
        this.addMoveLayerButtons(topSlotIndex, layer);
        this.addButton(topSlotIndex, this.getAddButton(topSlotIndex, layer));
        this.updatePreview();
    }

    private void setLayerButtons(final int topSlotIndex, final int layer, final PatternType pattern, final DyeColor color) {
        Pattern newPattern = new Pattern(color, pattern);
        this.patterns.put(layer, newPattern);
        this.addButton(topSlotIndex + 18, new Button.InventoryButton<Item.ClickableItem>(new Item.ClickableItem(this.previewBanner(this.banner, pattern, color), "Layer " + layer + " pattern type", List.of("Click to select another pattern type"), pattern.name())){

            @Override
            public void onClick(InventoryClickEvent event) {
                SelectorGUI<PatternType> inventory = new SelectorGUI<PatternType>(BannerEditorGUI.this.plugin, BannerEditorGUI.this, PatternType.values(), value -> {
                    ItemStack banner = new ItemStack(BannerEditorGUI.this.banner);
                    BannerMeta meta = (BannerMeta)Objects.requireNonNull(banner.getItemMeta());
                    meta.addPattern(new Pattern(color, value));
                    banner.setItemMeta((ItemMeta)meta);
                    return banner;
                }, selected -> BannerEditorGUI.this.setLayerButtons(topSlotIndex, layer, (PatternType)selected, color), () -> BannerEditorGUI.this.shouldOpenPrevious = true);
                BannerEditorGUI.this.shouldOpenPrevious = false;
                BannerEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
            }
        });
        this.addButton(topSlotIndex + 27, new Button.InventoryButton<Item.ClickableItem>(new Item.ClickableItem(Material.valueOf((String)(color.name() + "_DYE")), "Layer " + layer + " pattern color", "Click to select another color", color.name())){

            @Override
            public void onClick(InventoryClickEvent event) {
                SelectorGUI<DyeColor> inventory = new SelectorGUI<DyeColor>(BannerEditorGUI.this.plugin, BannerEditorGUI.this, (DyeColor[])color.getDeclaringClass().getEnumConstants(), value -> new ItemStack(Material.valueOf((String)(value.name() + "_DYE"))), selected -> BannerEditorGUI.this.setLayerButtons(topSlotIndex, layer, pattern, (DyeColor)selected), () -> BannerEditorGUI.this.shouldOpenPrevious = true);
                BannerEditorGUI.this.shouldOpenPrevious = false;
                BannerEditorGUI.this.plugin.getInventoryManager().handleOpen((Player)event.getWhoClicked(), inventory);
            }
        });
        this.addMoveLayerButtons(topSlotIndex, layer);
        this.addButton(topSlotIndex, this.getRemoveButton(topSlotIndex, layer));
        this.updatePreview();
    }

    private Button.InventoryButton<Item.ClickableItem> getAddButton(final int topSlotIndex, final int layer) {
        ItemStack item = this.plugin.getHeadCacheManager().ADD.clone();
        item.setAmount(Math.min(layer, 64));
        Item.ClickableItem addItem = new Item.ClickableItem(item, "Add layer " + layer, List.of("Adds a pattern in layer " + layer), null);
        return new Button.InventoryButton<Item.ClickableItem>(addItem){

            @Override
            public void onClick(InventoryClickEvent event) {
                BannerEditorGUI.this.setLayerButtons(topSlotIndex, layer, PatternType.BASE, DyeColor.ORANGE);
                BannerEditorGUI.this.updatePreview();
            }
        };
    }

    private Button.InventoryButton<Item.ClickableItem> getRemoveButton(final int topSlotIndex, final int layer) {
        ItemStack item = this.plugin.getHeadCacheManager().CANCEL.clone();
        item.setAmount(Math.min(layer, 64));
        Item.ClickableItem removeItem = new Item.ClickableItem(item, "Remove layer " + layer, List.of("Removes the pattern in layer " + layer), null);
        return new Button.InventoryButton<Item.ClickableItem>(removeItem){

            @Override
            public void onClick(InventoryClickEvent event) {
                BannerEditorGUI.this.setDisabledLayer(topSlotIndex, layer);
            }
        };
    }

    private void addMoveLayerButtons(final int topSlotIndex, final int layer) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        if (topSlotIndex < 8) {
            lore.add("&7Use &cLEFT_CLICK &7to move this layer 1 position above");
        } else {
            lore.add("&7Scroll using the button on the bottom right");
            lore.add("&7to be able to move this layer up");
        }
        if (layer > 1 && topSlotIndex > 0) {
            lore.add("&7Use &cRIGHT_CLICK &7to move this layer 1 position below");
        } else if (layer > 1) {
            lore.add("&7Scroll using the button on the bottom left");
            lore.add("&7to be able to move this layer below");
        } else {
            lore.add("&7You cannot move the bottom layer further below");
        }
        this.addButton(topSlotIndex + 9, new Button.InventoryButton<Item.ClickableItem>(new Item.ClickableItem(Material.PISTON, "Move layer", lore, null)){

            @Override
            public void onClick(InventoryClickEvent event) {
                if (event.isLeftClick() && topSlotIndex < 8) {
                    BannerEditorGUI.this.handleReplaceLayers(layer, topSlotIndex, layer + 1, topSlotIndex + 1);
                } else if (event.isRightClick() && layer > 1 && topSlotIndex > 0) {
                    BannerEditorGUI.this.handleReplaceLayers(layer, topSlotIndex, layer - 1, topSlotIndex - 1);
                }
            }
        });
    }

    private void handleReplaceLayers(int layer1, int topSlotIndex1, int layer2, int topSlotIndex2) {
        Pattern layer1Pattern = this.patterns.get(layer1);
        Pattern layer2Pattern = this.patterns.get(layer2);
        if (layer1Pattern == null) {
            this.setDisabledLayer(topSlotIndex2, layer2);
        } else {
            this.setLayerButtons(topSlotIndex2, layer2, layer1Pattern.getPattern(), layer1Pattern.getColor());
        }
        if (layer2Pattern == null) {
            this.setDisabledLayer(topSlotIndex1, layer1);
        } else {
            this.setLayerButtons(topSlotIndex1, layer1, layer2Pattern.getPattern(), layer2Pattern.getColor());
        }
    }

    private ItemStack previewBanner(Material bannerMat, PatternType pattern, DyeColor color) {
        ItemStack banner = new ItemStack(bannerMat);
        BannerMeta meta = (BannerMeta)Objects.requireNonNull(banner.getItemMeta());
        meta.addPattern(new Pattern(color, pattern));
        banner.setItemMeta((ItemMeta)meta);
        return banner;
    }

    private BannerMeta getMeta() {
        BannerMeta meta = (BannerMeta)Objects.requireNonNull(this.plugin.getServer().getItemFactory().getItemMeta(this.banner));
        ArrayList<Pattern> patternsList = new ArrayList<Pattern>();
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(this.patterns.keySet());
        sortedKeys.sort(Integer::compareTo);
        if (!sortedKeys.isEmpty()) {
            int min = (Integer)sortedKeys.get(0);
            int max = (Integer)sortedKeys.get(sortedKeys.size() - 1);
            for (int i = min; i <= max; ++i) {
                Pattern pattern = this.patterns.get(i);
                if (pattern == null) continue;
                patternsList.add(pattern);
            }
        }
        meta.setPatterns(patternsList);
        return meta;
    }

    private static Map<Integer, Pattern> getPatterns(BannerMeta meta) {
        HashMap<Integer, Pattern> patterns = new HashMap<Integer, Pattern>();
        int layer = 1;
        for (Pattern pattern : meta.getPatterns()) {
            patterns.put(layer, pattern);
            ++layer;
        }
        return patterns;
    }

    private void updatePreview() {
        this.getInventory().setItem(49, this.previewBanner());
    }

    private ItemStack previewBanner() {
        ItemStack bannerItem = new ItemStack(this.banner);
        BannerMeta meta = this.getMeta();
        meta.setDisplayName(Utils.getColoredText("&6Banner preview"));
        bannerItem.setItemMeta((ItemMeta)meta);
        return bannerItem;
    }
}

