/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.inventory.Button;
import me.lucaaa.advanceddisplays.inventory.items.Item;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class ADInventory {
    protected final AdvancedDisplays plugin;
    private final Inventory inventory;
    protected final List<EditorItem> disabledSettings;
    private final Map<Integer, Button<?>> buttons = new HashMap();
    private boolean loaded = false;
    protected final ADInventory previous;
    protected boolean shouldOpenPrevious = true;
    protected final Runnable onDone;
    protected static final ItemStack FILLER;
    protected static final List<Integer> METADATA_SLOTS;

    public ADInventory(AdvancedDisplays plugin, Inventory inventory, List<EditorItem> disabledSettings, ADInventory previous) {
        this(plugin, inventory, disabledSettings, previous, null);
    }

    public ADInventory(AdvancedDisplays plugin, Inventory inventory, List<EditorItem> disabledSettings, ADInventory previous, Runnable onDone) {
        this.plugin = plugin;
        this.inventory = inventory;
        this.disabledSettings = disabledSettings;
        this.previous = previous;
        this.onDone = onDone;
    }

    public void onOpen() {
        if (this.loaded) {
            return;
        }
        this.decorate();
        this.loaded = true;
    }

    public void onClose(Player player) {
        if (this.previous != null && this.shouldOpenPrevious) {
            this.plugin.getTasksManager().runTask((Plugin)this.plugin, () -> this.plugin.getInventoryManager().handleOpen(player, this.previous));
        }
    }

    public void onClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Button<?> button = this.buttons.get(event.getSlot());
        if (button instanceof Button.InventoryButton) {
            Button.InventoryButton inventoryButton = (Button.InventoryButton)button;
            inventoryButton.onClick(event);
        }
    }

    protected void addButton(int slot, Button<?> button) {
        this.buttons.put(slot, button);
        this.inventory.setItem(slot, ((Item)button.getItem()).getStack());
    }

    protected void removeButton(int slot) {
        this.getInventory().setItem(slot, null);
        this.buttons.remove(slot);
    }

    protected void clearButtons() {
        for (int slot : this.buttons.keySet()) {
            this.getInventory().setItem(slot, null);
        }
        this.buttons.clear();
    }

    protected Button<?> getButton(int slot) {
        return this.buttons.get(slot);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void decorate() {
        for (int i = 0; i < this.getInventory().getSize(); ++i) {
            if (this.getInventory().getItem(i) != null) continue;
            this.getInventory().setItem(i, FILLER);
        }
    }

    public boolean handleChatEdit(Player player, String input) {
        return true;
    }

    protected void addIfAllowed(EditorItem requirement, int slot, Button.InventoryButton<?> button) {
        if (!this.disabledSettings.contains((Object)requirement)) {
            this.addButton(slot, button);
            return;
        }
        ((Item)button.getItem()).disable(List.of());
        this.addButton(slot, new Button.Unclickable(button.getItem()));
    }

    static {
        METADATA_SLOTS = List.of(Integer.valueOf(8), Integer.valueOf(7), Integer.valueOf(6), Integer.valueOf(17), Integer.valueOf(16), Integer.valueOf(15), Integer.valueOf(26), Integer.valueOf(25), Integer.valueOf(24));
        FILLER = new ItemStack(Material.ORANGE_STAINED_GLASS_PANE);
        ItemMeta meta = Objects.requireNonNull(FILLER.getItemMeta());
        meta.setDisplayName(" ");
        Utils.hideFlags(meta);
        FILLER.setItemMeta(meta);
    }
}

