/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.events;

import java.util.HashMap;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.ADAPIImplementation;
import me.lucaaa.advanceddisplays.data.AttachedDisplay;
import me.lucaaa.advanceddisplays.data.PlayerData;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class PlayerEventsListener
implements Listener {
    private final AdvancedDisplays plugin;
    private final HashMap<Player, Long> pastInteractions = new HashMap();

    public PlayerEventsListener(AdvancedDisplays plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        ConfigurationSection saved;
        Player player = event.getPlayer();
        ConfigManager savedConfig = this.plugin.getSavesConfig();
        YamlConfiguration config = savedConfig.getConfig();
        if (!config.contains("saved")) {
            config.createSection("saved");
        }
        if ((saved = Objects.requireNonNull(config.getConfigurationSection("saved"))).contains(player.getName())) {
            player.getInventory().clear();
            ConfigurationSection playerSection = Objects.requireNonNull(saved.getConfigurationSection(player.getName()));
            for (String key : playerSection.getKeys(false)) {
                player.getInventory().setItem(Integer.parseInt(key), playerSection.getItemStack(key));
            }
            saved.set(player.getName(), null);
            this.plugin.getSavesConfig().save();
        }
        this.plugin.getPacketsManager().add(player);
        this.plugin.getPlayersManager().addPlayer(player);
        this.plugin.getDisplaysManager().spawnDisplays(player);
        for (ADAPIImplementation implementation : this.plugin.getApiDisplays().getApiMap().values()) {
            implementation.getDisplaysManager().spawnDisplays(player);
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        this.plugin.getDisplaysManager().spawnDisplays(player);
        for (ADAPIImplementation implementation : this.plugin.getApiDisplays().getApiMap().values()) {
            implementation.getDisplaysManager().spawnDisplays(player);
        }
        this.plugin.getPlayersManager().getPlayerData(player).stopRunnables();
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = this.plugin.getPlayersManager().getPlayerData(player);
        this.plugin.getPacketsManager().remove(player);
        if (playerData.isEditing()) {
            playerData.finishEditing();
        }
        this.plugin.getDisplaysManager().removeAttachingDisplay(player);
        this.plugin.getInventoryManager().onQuit(player);
        this.plugin.getPlayersManager().removePlayer(player);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.plugin.getPlayersManager().getPlayerData(event.getPlayer()).isChatEditing()) {
            return;
        }
        this.plugin.getTasksManager().runTask((Plugin)this.plugin, () -> this.plugin.getInventoryManager().handleChatEdit(event.getPlayer(), event.getMessage()));
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        PlayerData playerData = this.plugin.getPlayersManager().getPlayerData(player);
        Action action = event.getAction();
        DisplaysManager manager = this.plugin.getDisplaysManager();
        if (manager.isPlayerAttaching(player) && action == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
            AttachedDisplay display = manager.getAttachingDisplay(player);
            ADTextDisplay newDisplay = manager.createAttachedDisplay(event, display);
            if (newDisplay == null) {
                player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cA display with the name &b" + display.name() + " &calready exists!"));
            } else {
                player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aThe display &e" + display.name() + " &ahas been successfully created."));
            }
        }
        if (!playerData.isEditing()) {
            return;
        }
        if (action == Action.RIGHT_CLICK_AIR) {
            if (this.pastInteractions.containsKey(player)) {
                long now = System.currentTimeMillis();
                if (now - this.pastInteractions.remove(player) <= 500L) {
                    return;
                }
            } else {
                this.pastInteractions.put(player, System.currentTimeMillis());
            }
        }
        event.setCancelled(true);
        playerData.handleClick(event);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        if (!this.plugin.getPlayersManager().getPlayerData(event.getPlayer()).isEditing()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.plugin.getPlayersManager().getPlayerData(player).isEditing()) {
            return;
        }
        event.setCancelled(true);
    }
}

