/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.common.ITask;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import me.lucaaa.advanceddisplays.nms_common.PacketInterface;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AnimatedTextRunnable {
    private final AdvancedDisplays plugin;
    private final PacketInterface packets;
    private final ADTextDisplay display;
    private List<String> textsList;
    private int animationTime = 0;
    private int refreshTime = 0;
    private final Consumer<String> updateDisplay;
    private final List<Player> excludedPlayers = new ArrayList<Player>();
    private ITask displayTask;
    private int index = 0;

    public AnimatedTextRunnable(AdvancedDisplays plugin, ADTextDisplay display) {
        this.plugin = plugin;
        this.packets = plugin.getPacketsManager().getPackets();
        this.display = display;
        this.updateDisplay = text -> {
            for (Player onlinePlayer : plugin.getServer().getOnlinePlayers()) {
                if (this.excludedPlayers.contains(onlinePlayer)) continue;
                this.packets.setMetadata(display.getEntityId(), onlinePlayer, plugin.metadata.TEXT, plugin.getMessagesManager().parseColorsAndPlaceholders(onlinePlayer, (String)text));
            }
        };
    }

    public AnimatedTextRunnable(AdvancedDisplays plugin, ADTextDisplay display, Player player) {
        this.plugin = plugin;
        this.packets = plugin.getPacketsManager().getPackets();
        this.display = display;
        this.updateDisplay = text -> this.packets.setMetadata(display.getEntityId(), player, plugin.metadata.TEXT, plugin.getMessagesManager().parseColorsAndPlaceholders(player, (String)text));
        this.textsList = new ArrayList<String>(display.getText().values());
        this.index = display.getTextRunnable().getCurrentIndex();
    }

    public void start() {
        this.start(0);
    }

    private void start(int startIndex) {
        this.stop();
        this.textsList = new ArrayList<String>(this.display.getText().values());
        this.animationTime = this.display.getAnimationTime();
        this.refreshTime = this.display.getRefreshTime();
        this.index = startIndex;
        if (this.textsList.isEmpty()) {
            return;
        }
        this.updateDisplay.accept(this.textsList.get(this.index));
        if (this.animationTime <= 0 && this.refreshTime <= 0) {
            return;
        }
        this.displayTask = this.plugin.getTasksManager().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){
            private int animationTicks = 0;
            private int refreshTicks = 0;

            @Override
            public void run() {
                boolean shouldUpdate = false;
                boolean nextPage = false;
                if (AnimatedTextRunnable.this.animationTime > 0 && AnimatedTextRunnable.this.textsList.size() > 1) {
                    ++this.animationTicks;
                    if (this.animationTicks >= AnimatedTextRunnable.this.animationTime) {
                        this.animationTicks = 0;
                        shouldUpdate = true;
                        nextPage = true;
                    }
                }
                if (AnimatedTextRunnable.this.refreshTime > 0) {
                    ++this.refreshTicks;
                    if (this.refreshTicks >= AnimatedTextRunnable.this.refreshTime) {
                        this.refreshTicks = 0;
                        shouldUpdate = true;
                    }
                }
                if (shouldUpdate) {
                    if (nextPage) {
                        AnimatedTextRunnable.this.index = AnimatedTextRunnable.this.getNextIndex();
                    }
                    AnimatedTextRunnable.this.updateDisplay.accept(AnimatedTextRunnable.this.textsList.get(AnimatedTextRunnable.this.index));
                }
            }
        }, 0L, 0L);
    }

    public void stop() {
        if (this.displayTask != null && !this.displayTask.isCancelled()) {
            this.displayTask.cancel();
            this.displayTask = null;
        }
        this.textsList = null;
    }

    public int nextPage() {
        int nextIndex = this.getNextIndex();
        this.start(nextIndex);
        return nextIndex;
    }

    public int previousPage() {
        int previousIndex = this.getPreviousIndex();
        this.start(previousIndex);
        return previousIndex;
    }

    public void setPage(int index) {
        this.start(index);
    }

    public void sendToPlayer(Player player) {
        this.packets.setMetadata(this.display.getEntityId(), player, this.plugin.metadata.TEXT, this.plugin.getMessagesManager().parseColorsAndPlaceholders(player, this.textsList.get(this.index)));
    }

    public int getCurrentIndex() {
        return this.index;
    }

    public int getNextIndex() {
        return (this.index + 1) % this.textsList.size();
    }

    public int getPreviousIndex() {
        if (this.textsList.size() <= 1) {
            return 0;
        }
        if (this.index == 0) {
            return this.textsList.size() - 1;
        }
        return this.index - 1;
    }

    public void excludePlayer(Player player) {
        if (!this.excludedPlayers.contains(player)) {
            this.excludedPlayers.add(player);
        }
    }

    public void resetPlayer(Player player) {
        if (this.excludedPlayers.contains(player)) {
            this.excludedPlayers.remove(player);
            this.packets.setMetadata(this.display.getEntityId(), player, this.plugin.metadata.TEXT, this.plugin.getMessagesManager().parseColorsAndPlaceholders(player, this.textsList.get(this.index)));
        }
    }
}

