/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.util.HashMap;
import java.util.Map;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.conditions.Condition;
import me.lucaaa.advanceddisplays.api.displays.visibility.Visibility;
import me.lucaaa.advanceddisplays.api.displays.visibility.VisibilityManager;
import me.lucaaa.advanceddisplays.conditions.ConditionsHandler;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ADVisibilityManager
implements VisibilityManager {
    private final ADBaseEntity display;
    private final ConditionsHandler conditionsHandler;
    private final Map<String, Visibility> individualVis = new HashMap<String, Visibility>();
    private Visibility globalVisibility = Visibility.SHOW;
    private final Map<Player, Boolean> cachedVis = new HashMap<Player, Boolean>();

    public ADVisibilityManager(AdvancedDisplays plugin, ADBaseEntity display) {
        this.display = display;
        this.conditionsHandler = display.isApi() ? new ConditionsHandler(plugin, display) : new ConditionsHandler(plugin, display, display.getConfigManager().getConfig().getConfigurationSection("view-conditions"));
    }

    @Override
    public void setGlobalVisibility(Visibility visibility) {
        this.globalVisibility = visibility;
    }

    @Override
    public Visibility getGlobalVisibility() {
        return this.globalVisibility;
    }

    @Override
    public void setVisibility(Visibility visibility, Player player) {
        this.individualVis.put(player.getName(), visibility);
    }

    @Override
    public boolean isVisibleByPlayer(Player player) {
        if (!player.getWorld().equals((Object)this.display.getLocation().getWorld())) {
            return false;
        }
        boolean def = this.globalVisibility == Visibility.SHOW;
        boolean individual = this.individualVis.get(player.getName()) == Visibility.SHOW;
        boolean meetsConditions = this.conditionsHandler.checkConditions(player);
        return (def || individual) && meetsConditions;
    }

    @Override
    public void removeIndividualVisibility(Player player) {
        this.individualVis.remove(player.getName());
    }

    @Override
    public void clearPlayerVisibilities() {
        this.individualVis.clear();
    }

    @Override
    public void addViewCondition(Condition condition) {
        this.conditionsHandler.addCondition(condition);
    }

    @Override
    public void clearConditions() {
        this.conditionsHandler.clearConditions();
    }

    public void updateVisibility() {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            boolean isSeen = this.isVisibleByPlayer(onlinePlayer);
            Boolean cached = this.cachedVis.get(onlinePlayer);
            if (cached == null) {
                if (isSeen) {
                    this.display.spawnToPlayer(onlinePlayer);
                } else {
                    this.display.removeToPlayer(onlinePlayer);
                }
            } else if (cached.booleanValue() && !isSeen) {
                this.display.removeToPlayer(onlinePlayer);
            } else if (!cached.booleanValue() && isSeen) {
                this.display.spawnToPlayer(onlinePlayer);
            }
            this.cachedVis.put(onlinePlayer, isSeen);
        }
        this.cachedVis.keySet().removeIf(player -> !player.isOnline());
    }
}

