/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.TextDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.data.PlayerData;
import me.lucaaa.advanceddisplays.displays.ADBaseDisplay;
import me.lucaaa.advanceddisplays.displays.AnimatedTextRunnable;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import me.lucaaa.advanceddisplays.nms_common.Metadata;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import shaded.net.kyori.adventure.text.Component;
import shaded.net.kyori.adventure.text.minimessage.MiniMessage;

public class ADTextDisplay
extends ADBaseDisplay
implements TextDisplay {
    private final AnimatedTextRunnable textRunnable;
    private int animationTime;
    private int refreshTime;
    private Map<String, String> texts = new LinkedHashMap<String, String>();
    private boolean isEmpty = false;
    private TextDisplay.TextAlignment alignment;
    private Color backgroundColor;
    private int lineWidth;
    private byte textOpacity;
    private boolean defaultBackground;
    private boolean seeThrough;
    private boolean shadowed;

    public ADTextDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, ConfigManager configManager, String name) {
        super(plugin, displaysManager, configManager, name, DisplayType.TEXT, EntityType.TEXT_DISPLAY);
        this.textRunnable = new AnimatedTextRunnable(plugin, this);
        if (this.settings != null) {
            this.animationTime = this.config.getOrDefault("animationTime", 20, this.settings);
            this.refreshTime = this.config.getOrDefault("refreshTime", 10, this.settings);
            ConfigurationSection textSection = this.config.getSection("texts", this.settings);
            if (textSection == null) {
                plugin.log(Level.WARNING, "The text display \"" + configManager.getFile().getName() + "\" does not have a valid \"texts\" section! Check the wiki for more information.");
                this.texts.put("error", "&cError! No valid \"texts\" section found. Check the wiki for more information.");
                this.isEmpty = true;
            } else if (textSection.getKeys(false).isEmpty()) {
                plugin.log(Level.WARNING, "The text display \"" + configManager.getFile().getName() + "\" has an empty \"texts\" section!");
                this.texts.put("empty", "&cThere are no texts to display");
                this.isEmpty = true;
            } else {
                for (String sectionName : textSection.getKeys(false)) {
                    if (!textSection.isList(sectionName)) continue;
                    this.texts.put(sectionName, String.join((CharSequence)"\n", textSection.getStringList(sectionName)));
                }
            }
            this.lineWidth = this.config.getOrDefault("lineWidth", 250, this.settings);
            this.textOpacity = (byte)this.config.getOrDefault("textOpacity", -1, this.settings).intValue();
            this.defaultBackground = this.config.getOrDefault("defaultBackground", true, this.settings);
            this.seeThrough = this.config.getOrDefault("seeThrough", true, this.settings);
            this.shadowed = this.config.getOrDefault("shadowed", true, this.settings);
            try {
                this.alignment = TextDisplay.TextAlignment.valueOf((String)this.config.getOrDefault("alignment", TextDisplay.TextAlignment.CENTER.name(), this.settings));
                String[] colorParts = this.config.getOrDefault("backgroundColor", "255;170;0;255", this.settings).split(";");
                this.backgroundColor = Color.fromARGB((int)Integer.parseInt(colorParts[3]), (int)Integer.parseInt(colorParts[0]), (int)Integer.parseInt(colorParts[1]), (int)Integer.parseInt(colorParts[2]));
            }
            catch (IllegalArgumentException e) {
                this.errors.add("Invalid text alignment type or invalid background color - make sure none of the color components are lower than 0 or higher than 255");
                return;
            }
            this.textRunnable.start();
        }
    }

    public ADTextDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, String name, Location location, boolean saveToConfig) {
        super(plugin, displaysManager, name, location, DisplayType.TEXT, EntityType.TEXT_DISPLAY, saveToConfig);
        this.textRunnable = new AnimatedTextRunnable(plugin, this);
    }

    @Override
    public void sendMetadataPackets(Player player) {
        super.sendMetadataPackets(player);
        this.textRunnable.sendToPlayer(player);
        this.packets.setMetadata(this.entityId, player, new Metadata.DataPair<Integer>(this.metadata.BG_COLOR, this.backgroundColor.asARGB()), new Metadata.DataPair<Integer>(this.metadata.LINE_WIDTH, this.lineWidth), new Metadata.DataPair<Byte>(this.metadata.TEXT_OPACITY, this.textOpacity), new Metadata.DataPair<Byte>(this.metadata.TEXT_PROPERTIES, Metadata.getTextProperties(this.shadowed, this.seeThrough, this.defaultBackground, this.alignment)));
    }

    public ADTextDisplay create(String text) {
        this.create();
        this.setSingleText("animation1", text);
        this.setInitialValues();
        return this;
    }

    public ADTextDisplay create(Component text) {
        this.create();
        this.setSingleText("animation1", text);
        this.setInitialValues();
        return this;
    }

    private void setInitialValues() {
        this.setRefreshTime(10);
        this.setAnimationTime(20);
        this.setAlignment(TextDisplay.TextAlignment.CENTER);
        this.setBackgroundColor(Color.ORANGE);
        this.setLineWidth(250);
        this.setTextOpacity((byte)-1);
        this.setUseDefaultBackground(true);
        this.setSeeThrough(true);
        this.setShadowed(true);
    }

    @Override
    public TextDisplay.TextAlignment getAlignment() {
        return this.alignment;
    }

    @Override
    public void setAlignment(TextDisplay.TextAlignment alignment) {
        this.alignment = alignment;
        if (this.config != null) {
            this.settings.set("alignment", (Object)alignment.name());
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setAlignment(alignment, onlinePlayer);
        }
    }

    @Override
    public void setAlignment(TextDisplay.TextAlignment alignment, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.TEXT_PROPERTIES, Metadata.getTextProperties(this.shadowed, this.seeThrough, this.defaultBackground, alignment));
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        if (this.config != null) {
            this.settings.set("backgroundColor", (Object)(color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + ";" + color.getAlpha()));
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setBackgroundColor(color, onlinePlayer);
        }
    }

    @Override
    public void setBackgroundColor(Color color, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.BG_COLOR, color.asARGB());
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
        if (this.config != null) {
            this.settings.set("lineWidth", (Object)width);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setLineWidth(width, onlinePlayer);
        }
    }

    @Override
    public void setLineWidth(int width, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.LINE_WIDTH, width);
    }

    @Override
    public Map<String, String> getText() {
        return this.texts;
    }

    @Override
    public void setAnimatedText(Map<String, String> text) {
        this.texts.clear();
        this.texts = text;
        if (this.config != null) {
            ConfigurationSection textSection = this.settings.createSection("texts");
            for (Map.Entry<String, String> entry : text.entrySet()) {
                textSection.set(entry.getKey(), (Object)entry.getValue().split(Pattern.quote("\n")));
            }
            this.settings.set("texts", (Object)textSection);
            this.save();
        }
        this.textRunnable.start();
    }

    @Override
    public void setAnimatedTextComponent(Map<String, Component> text) {
        HashMap<String, String> parsedTexts = new HashMap<String, String>();
        for (Map.Entry<String, Component> entry : text.entrySet()) {
            parsedTexts.put(entry.getKey(), (String)MiniMessage.miniMessage().serialize(entry.getValue()));
        }
        this.setAnimatedText(parsedTexts);
    }

    @Override
    public void setSingleText(String identifier, String text) {
        this.texts.clear();
        this.texts.put(identifier, text);
        if (this.config != null) {
            ConfigurationSection textSection = this.settings.createSection("texts");
            textSection.set(identifier, (Object)text.split(Pattern.quote("\n")));
            this.save();
        }
        this.textRunnable.start();
    }

    @Override
    public boolean addText(String identifier, String text) {
        if (this.texts.containsKey(identifier)) {
            return false;
        }
        this.texts.put(identifier, text);
        if (this.isEmpty) {
            this.texts.remove("empty");
            this.isEmpty = false;
        }
        if (this.config != null) {
            ConfigurationSection textSection = this.settings.createSection("texts");
            for (Map.Entry<String, String> entry : this.texts.entrySet()) {
                textSection.set(entry.getKey(), (Object)entry.getValue().split(Pattern.quote("\n")));
            }
            this.settings.set("texts", (Object)textSection);
            this.save();
        }
        this.textRunnable.start();
        return true;
    }

    @Override
    public boolean addText(String identifier, Component text) {
        return this.addText(identifier, (String)MiniMessage.miniMessage().serialize(text));
    }

    @Override
    public boolean removeText(String identifier) {
        if (!this.texts.containsKey(identifier)) {
            return false;
        }
        this.texts.remove(identifier);
        if (this.config != null) {
            ConfigurationSection textSection = this.settings.createSection("texts");
            for (Map.Entry<String, String> entry : this.texts.entrySet()) {
                textSection.set(entry.getKey(), (Object)entry.getValue().split(Pattern.quote("\n")));
            }
            this.settings.set("texts", (Object)textSection);
            this.save();
        }
        if (this.texts.isEmpty()) {
            this.texts.put("empty", "&cThere are no texts to display");
            this.isEmpty = true;
        }
        this.textRunnable.start();
        return true;
    }

    @Override
    public void nextPage() {
        this.textRunnable.nextPage();
    }

    @Override
    public void nextPage(Player player) {
        this.textRunnable.excludePlayer(player);
        PlayerData playerData = this.plugin.getPlayersManager().getPlayerData(player);
        int newIndex = playerData.getRunnable(this.plugin, this).nextPage();
        if (newIndex == this.textRunnable.getCurrentIndex()) {
            this.resetPlayer(player);
        }
    }

    @Override
    public void previousPage() {
        this.textRunnable.previousPage();
    }

    @Override
    public void previousPage(Player player) {
        this.textRunnable.excludePlayer(player);
        PlayerData playerData = this.plugin.getPlayersManager().getPlayerData(player);
        int newIndex = playerData.getRunnable(this.plugin, this).previousPage();
        if (newIndex == this.textRunnable.getCurrentIndex()) {
            this.resetPlayer(player);
        }
    }

    @Override
    public void setPage(String page) {
        if (!this.texts.containsKey(page)) {
            throw new IllegalArgumentException("The display " + this.getName() + " does not have a page called " + page);
        }
        this.textRunnable.setPage(this.texts.keySet().stream().toList().indexOf(page));
    }

    @Override
    public void setPage(String page, Player player) {
        if (!this.texts.containsKey(page)) {
            throw new IllegalArgumentException("The display " + this.getName() + " does not have a page called " + page);
        }
        this.textRunnable.excludePlayer(player);
        PlayerData playerData = this.plugin.getPlayersManager().getPlayerData(player);
        int newIndex = this.texts.keySet().stream().toList().indexOf(page);
        if (newIndex == this.textRunnable.getCurrentIndex()) {
            this.resetPlayer(player);
        } else {
            playerData.getRunnable(this.plugin, this).setPage(newIndex);
        }
    }

    @Override
    public void resetPlayer(Player player) {
        this.plugin.getPlayersManager().resetDisplay(player, this);
        this.textRunnable.resetPlayer(player);
    }

    @Override
    public byte getTextOpacity() {
        return this.textOpacity;
    }

    @Override
    public void setTextOpacity(byte opacity) {
        this.textOpacity = opacity;
        if (this.config != null) {
            this.settings.set("textOpacity", (Object)opacity);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setTextOpacity(opacity, onlinePlayer);
        }
    }

    @Override
    public void setTextOpacity(byte opacity, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.TEXT_OPACITY, opacity);
    }

    @Override
    public boolean getUseDefaultBackground() {
        return this.defaultBackground;
    }

    @Override
    public void setUseDefaultBackground(boolean defaultBackground) {
        this.defaultBackground = defaultBackground;
        if (this.config != null) {
            this.settings.set("defaultBackground", (Object)defaultBackground);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setUseDefaultBackground(defaultBackground, onlinePlayer);
        }
    }

    @Override
    public void setUseDefaultBackground(boolean defaultBackground, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.TEXT_PROPERTIES, Metadata.getTextProperties(this.shadowed, this.seeThrough, defaultBackground, this.alignment));
    }

    @Override
    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    @Override
    public void setSeeThrough(boolean seeThrough) {
        this.seeThrough = seeThrough;
        if (this.config != null) {
            this.settings.set("seeThrough", (Object)seeThrough);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setSeeThrough(seeThrough, onlinePlayer);
        }
    }

    @Override
    public void setSeeThrough(boolean seeThrough, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.TEXT_PROPERTIES, Metadata.getTextProperties(this.shadowed, seeThrough, this.defaultBackground, this.alignment));
    }

    @Override
    public boolean isShadowed() {
        return this.shadowed;
    }

    @Override
    public void setShadowed(boolean shadowed) {
        this.shadowed = shadowed;
        if (this.config != null) {
            this.settings.set("shadowed", (Object)shadowed);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setShadowed(shadowed, onlinePlayer);
        }
    }

    @Override
    public void setShadowed(boolean shadowed, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.TEXT_PROPERTIES, Metadata.getTextProperties(shadowed, this.seeThrough, this.defaultBackground, this.alignment));
    }

    @Override
    public int getAnimationTime() {
        return this.animationTime;
    }

    @Override
    public void setAnimationTime(int animationTime) {
        this.animationTime = animationTime;
        if (this.config != null) {
            this.settings.set("animationTime", (Object)animationTime);
            this.save();
        }
        this.textRunnable.start();
    }

    @Override
    public int getRefreshTime() {
        return this.refreshTime;
    }

    @Override
    public void setRefreshTime(int refreshTime) {
        this.refreshTime = refreshTime;
        if (this.config != null) {
            this.settings.set("refreshTime", (Object)refreshTime);
            this.save();
        }
        this.textRunnable.start();
    }

    public AnimatedTextRunnable getTextRunnable() {
        return this.textRunnable;
    }

    public void stopRunnable() {
        this.textRunnable.stop();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty;
    }

    public int getTextsNumber() {
        return this.isEmpty ? 0 : this.texts.size();
    }
}

