/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.ItemDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.common.ITask;
import me.lucaaa.advanceddisplays.data.DisplayHeadType;
import me.lucaaa.advanceddisplays.data.HeadUtils;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.displays.ADBaseDisplay;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ADItemDisplay
extends ADBaseDisplay
implements ItemDisplay {
    private ItemStack item;
    private DisplayHeadType displayHeadType;
    private String displayHeadValue;
    private boolean enchanted;
    private ItemDisplay.ItemDisplayTransform itemTransformation;
    private final Map<Player, ITask> headLoadTasks = new HashMap<Player, ITask>();

    public ADItemDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, ConfigManager configManager, String name) {
        super(plugin, displaysManager, configManager, name, DisplayType.ITEM, EntityType.ITEM_DISPLAY);
        if (this.settings != null) {
            String material = this.config.getOrDefault("item", Material.BARRIER.name(), this.settings);
            try {
                this.item = new ItemStack(Material.valueOf((String)material));
                Utils.loadItemData(this.item, this.settings, this.getLocation().getWorld(), plugin);
            }
            catch (IllegalArgumentException e) {
                this.errors.add("Invalid material set: " + material);
            }
            this.enchanted = !this.item.getEnchantments().isEmpty();
            this.itemTransformation = ItemDisplay.ItemDisplayTransform.valueOf((String)this.config.getOrDefault("itemTransformation", ItemDisplay.ItemDisplayTransform.FIXED.name(), this.settings));
            if (this.item.getType() == Material.PLAYER_HEAD && this.settings.contains("head")) {
                ConfigurationSection headSection = this.settings.getConfigurationSection("head");
                if (Objects.requireNonNull(headSection).contains("player")) {
                    this.displayHeadType = DisplayHeadType.PLAYER;
                    this.displayHeadValue = headSection.getString("player");
                } else {
                    this.displayHeadType = DisplayHeadType.BASE64;
                    this.displayHeadValue = headSection.getString("base64");
                }
                this.item = plugin.getHeadCacheManager().LOADING;
                if (!this.displayHeadValue.equalsIgnoreCase("%player%")) {
                    plugin.getHeadCacheManager().loadHead(this, this.displayHeadType, this.displayHeadValue);
                }
            }
        }
    }

    public ADItemDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, String name, Location location, boolean saveToConfig) {
        super(plugin, displaysManager, name, location, DisplayType.ITEM, EntityType.ITEM_DISPLAY, saveToConfig);
    }

    @Override
    public void sendMetadataPackets(Player player) {
        super.sendMetadataPackets(player);
        if (this.displayHeadType == DisplayHeadType.PLAYER && this.displayHeadValue.equalsIgnoreCase("%player%")) {
            this.setHead(this.displayHeadType, this.displayHeadValue, player, this.enchanted);
        } else {
            this.packets.setMetadata(this.entityId, player, this.metadata.ITEM, this.item);
        }
        this.packets.setMetadata(this.entityId, player, this.metadata.ITEM_TRANSFORM, (byte)this.itemTransformation.ordinal());
    }

    public ADItemDisplay create(Material item) {
        this.create();
        if (item == Material.PLAYER_HEAD) {
            this.setViewerHead();
        } else {
            this.setItem(new ItemStack(item));
        }
        this.setEnchanted(false);
        this.setItemTransformation(ItemDisplay.ItemDisplayTransform.FIXED);
        return this;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void setItem(ItemStack item) {
        this.item = item;
        if (this.config != null) {
            this.settings.set("item", (Object)item.getType().name());
            Utils.saveItemData(item, this.settings, this.plugin.getNmsVersion());
            this.save();
        }
        this.enchanted = !item.getEnchantments().isEmpty();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setItem(item, onlinePlayer);
        }
    }

    @Override
    public void setItem(ItemStack item, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.ITEM, item);
    }

    @Override
    public void setBase64Head(String base64) {
        this.item = new ItemStack(Material.PLAYER_HEAD);
        this.displayHeadType = DisplayHeadType.BASE64;
        this.displayHeadValue = base64;
        if (this.config != null) {
            this.settings.set("item", (Object)this.item.getType().name());
            ConfigurationSection headSection = this.settings.createSection("head");
            headSection.set(this.displayHeadType.getConfigName(), (Object)base64);
            this.save();
        }
        this.plugin.getHeadCacheManager().loadHead(this, this.displayHeadType, this.displayHeadValue);
    }

    @Override
    public void setBase64Head(String base64, Player player) {
        this.setHead(DisplayHeadType.BASE64, base64, player, false);
    }

    @Override
    public void setPlayerHead(String playerName) {
        this.item = new ItemStack(Material.PLAYER_HEAD);
        this.displayHeadType = DisplayHeadType.PLAYER;
        this.displayHeadValue = playerName;
        if (this.config != null) {
            this.settings.set("item", (Object)this.item.getType().name());
            ConfigurationSection headSection = this.settings.createSection("head");
            headSection.set(this.displayHeadType.getConfigName(), (Object)playerName);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setHead(DisplayHeadType.PLAYER, playerName, onlinePlayer, true);
        }
    }

    @Override
    public void setPlayerHead(String playerName, Player player) {
        this.setHead(DisplayHeadType.PLAYER, playerName, player, false);
    }

    @Override
    public void setViewerHead() {
        this.setPlayerHead("%player%");
    }

    @Override
    public boolean isEnchanted() {
        return this.enchanted;
    }

    @Override
    public void setEnchanted(boolean enchanted) {
        this.enchanted = enchanted;
        if (enchanted) {
            ItemMeta meta = this.item.getItemMeta();
            if (meta != null) {
                meta.addEnchant(Enchantment.MENDING, 1, true);
                this.item.setItemMeta(meta);
            }
        } else {
            for (Enchantment enchantment : this.item.getEnchantments().keySet()) {
                this.item.removeEnchantment(enchantment);
            }
        }
        if (this.config != null) {
            this.settings.set("enchanted", (Object)enchanted);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setItem(this.item, onlinePlayer);
        }
    }

    @Override
    public void setEnchanted(boolean enchanted, Player player) {
        ItemStack clone = this.item.clone();
        if (enchanted) {
            clone.addUnsafeEnchantment(Enchantment.MENDING, 1);
        }
        this.packets.setMetadata(this.entityId, player, this.metadata.ITEM, clone);
    }

    @Override
    public ItemDisplay.ItemDisplayTransform getItemTransformation() {
        return this.itemTransformation;
    }

    @Override
    public void setItemTransformation(ItemDisplay.ItemDisplayTransform transformation) {
        this.itemTransformation = transformation;
        if (this.config != null) {
            this.settings.set("itemTransformation", (Object)transformation.name());
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setItemTransformation(transformation, onlinePlayer);
        }
    }

    @Override
    public void setItemTransformation(ItemDisplay.ItemDisplayTransform transformation, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.ITEM_TRANSFORM, (byte)transformation.ordinal());
    }

    @Override
    public void remove() {
        super.remove();
        this.plugin.getHeadCacheManager().cancelTask(this);
        for (ITask task : this.headLoadTasks.values()) {
            task.cancel();
        }
        this.headLoadTasks.clear();
    }

    public void setHead(ItemStack item) {
        if (this.enchanted) {
            item.addUnsafeEnchantment(Enchantment.MENDING, 1);
        }
        this.item = item;
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setItem(item, onlinePlayer);
        }
    }

    private void setHead(DisplayHeadType type, String value, Player player, boolean useCache) {
        this.item = this.plugin.getHeadCacheManager().LOADING;
        this.packets.setMetadata(this.entityId, player, this.metadata.ITEM, this.item);
        if (type == DisplayHeadType.PLAYER && value.equalsIgnoreCase("%player%")) {
            ITask task = this.plugin.getTasksManager().runTaskAsynchronously((Plugin)this.plugin, () -> {
                ItemStack head = HeadUtils.getPlayerHead(player.getName(), this.plugin);
                if (this.enchanted) {
                    head.addUnsafeEnchantment(Enchantment.MENDING, 1);
                }
                this.packets.setMetadata(this.entityId, player, this.metadata.ITEM, head);
                this.headLoadTasks.remove(player);
            });
            this.headLoadTasks.put(player, task);
            return;
        }
        if (!useCache) {
            ITask task = this.plugin.getTasksManager().runTaskAsynchronously((Plugin)this.plugin, () -> {
                ItemStack head = type == DisplayHeadType.PLAYER ? HeadUtils.getPlayerHead(value, this.plugin) : HeadUtils.getBase64Head(value, this.plugin);
                if (this.enchanted) {
                    head.addUnsafeEnchantment(Enchantment.MENDING, 1);
                }
                this.packets.setMetadata(this.entityId, player, this.metadata.ITEM, head);
                this.headLoadTasks.remove(player);
            });
            this.headLoadTasks.put(player, task);
        }
    }
}

