/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.EntityDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.api.displays.enums.Property;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ADEntityDisplay
extends ADBaseEntity
implements EntityDisplay {
    private final Map<Property<?>, Object> properties = new HashMap();

    public ADEntityDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, ConfigManager config, String name, EntityType entityType) {
        super(plugin, displaysManager, config, name, DisplayType.ENTITY, entityType);
        ConfigurationSection dataSection = config.getSection("data", true, this.entitySection);
        for (Property<?> property : Property.getProperties()) {
            Object data;
            block11: {
                data = dataSection.get(property.name());
                if (data == null || !property.ownerEntity().isAssignableFrom(this.entity.getClass())) continue;
                if (property.type().isEnum()) {
                    try {
                        data = Enum.valueOf(property.type(), data.toString().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        this.errors.add("Invalid value set for property \"" + property.name() + "\": " + String.valueOf(data));
                        return;
                    }
                }
                if (Keyed.class.isAssignableFrom(property.type())) {
                    Class<?> clazz = property.type();
                    for (Class<?> interfaceClass : property.type().getInterfaces()) {
                        if (!Keyed.class.isAssignableFrom(interfaceClass) || interfaceClass == Keyed.class) continue;
                        clazz = interfaceClass;
                    }
                    NamespacedKey key = NamespacedKey.minecraft((String)data.toString().toLowerCase());
                    data = Objects.requireNonNull(plugin.getServer().getRegistry(clazz)).get(key);
                } else {
                    if (ItemStack.class.isAssignableFrom(property.type())) {
                        try {
                            ConfigurationSection itemSection = Objects.requireNonNull(dataSection.getConfigurationSection(property.name()));
                            ItemStack item = new ItemStack(Material.valueOf((String)itemSection.getString("material")));
                            data = Utils.loadItemData(item, itemSection, this.getLocation().getWorld(), plugin);
                            break block11;
                        }
                        catch (IllegalArgumentException e) {
                            plugin.log(Level.WARNING, "Invalid material set for an item for entity display \"" + this.getName() + "\"!");
                            continue;
                        }
                    }
                    if (!property.type().isInstance(data)) {
                        plugin.log(Level.WARNING, "Data \"" + property.name() + "\" is not a \"" + property.type().getSimpleName() + "\" value for entity display \"" + this.getName() + "\"!");
                        continue;
                    }
                }
            }
            this.properties.put(property, property.type().cast(data));
        }
    }

    public ADEntityDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, String name, Location location, EntityType entityType, boolean saveToConfig) {
        super(plugin, displaysManager, name, DisplayType.ENTITY, entityType, location, saveToConfig);
    }

    @Override
    protected ConfigManager createConfig(Location location) {
        ConfigManager config = super.createConfig(location);
        this.entitySection = Objects.requireNonNull(config.getConfig().getConfigurationSection("entity"));
        this.entitySection.createSection("data");
        this.entitySection.setComments("data", List.of("PREVIEW FEATURE - Entity metadata is a WIP feature.", "Modifying this section will do nothing for now."));
        config.save();
        return config;
    }

    @Override
    public void sendMetadataPackets(Player player) {
        super.sendMetadataPackets(player);
    }

    @Override
    public ADEntityDisplay create() {
        super.create();
        return this;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public void setEntityType(EntityType type) {
        if (this.config != null) {
            this.entitySection.set("type", (Object)type.name());
            this.save();
        }
        this.entityType = type;
        this.packets.removeEntity(this.entityId);
        this.plugin.getInteractionsManager().removeInteraction(this.getInteractionId());
        this.entity = this.packets.createEntity(type, this.location);
        this.entityId = this.entity.getEntityId();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.sendMetadataPackets(onlinePlayer);
        }
        this.plugin.getInteractionsManager().addInteraction(this.getInteractionId(), this);
    }

    @Override
    public <T> void setProperty(Property<T> property, T value) {
        if (!property.ownerEntity().isAssignableFrom(this.entity.getClass())) {
            return;
        }
        if (!this.isPropertyApplicable(property)) {
            return;
        }
        this.properties.put(property, value);
        ConfigurationSection dataSection = this.config.getSection("data", true, this.entitySection);
        Class<T> type = property.type();
        if (type.isEnum()) {
            dataSection.set(property.name(), (Object)((Enum)value).name());
        } else if (Keyed.class.isAssignableFrom(type)) {
            dataSection.set(property.name(), (Object)((Keyed)value).getKey().getKey());
        } else if (ItemStack.class.isAssignableFrom(type)) {
            ConfigurationSection itemSection = dataSection.createSection(property.name());
            itemSection.set("material", (Object)((ItemStack)value).getType().name());
            Utils.saveItemData((ItemStack)value, itemSection, this.plugin.getNmsVersion());
        } else {
            dataSection.set(property.name(), value);
        }
        this.save();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setProperty(property, value, onlinePlayer);
        }
    }

    @Override
    public <T> void setProperty(Property<T> property, T value, Player player) {
    }

    @Override
    public <T> T getPropertyValue(Property<T> property) {
        return (T)(this.properties.containsKey(property) ? this.properties.get(property) : property.getDefaultValue());
    }

    @Override
    public <T> Map<Property<T>, T> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isPropertyApplicable(Property<?> property) {
        return property.ownerEntity().isAssignableFrom(this.entity.getClass());
    }
}

