/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BlockDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.data.Compatibility;
import me.lucaaa.advanceddisplays.displays.ADBaseDisplay;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class ADBlockDisplay
extends ADBaseDisplay
implements BlockDisplay {
    private BlockData block;
    private String oraxenId;
    private String itemsAdderId;

    public ADBlockDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, ConfigManager configManager, String name) {
        super(plugin, displaysManager, configManager, name, DisplayType.BLOCK, EntityType.BLOCK_DISPLAY);
        if (this.settings != null) {
            if (this.settings.isString("oraxen") && plugin.isIntegrationLoaded(Compatibility.ORAXEN)) {
                this.oraxenId = this.settings.getString("oraxen");
                this.block = plugin.getIntegration(Compatibility.ORAXEN).getBlockData(this.oraxenId);
                return;
            }
            if (this.settings.isString("itemsAdder") && plugin.isIntegrationLoaded(Compatibility.ITEMS_ADDER)) {
                this.itemsAdderId = this.settings.getString("itemsAdder");
                this.block = plugin.getIntegration(Compatibility.ITEMS_ADDER).getBlockData(this.itemsAdderId);
                return;
            }
            Object blockData = "minecraft:" + this.config.getOrDefault("block", Material.BARRIER.name(), this.settings).toLowerCase() + "[";
            ConfigurationSection dataSection = this.config.getSection("blockData", this.settings);
            ArrayList<CallSite> dataParts = new ArrayList<CallSite>();
            for (String dataKey : dataSection.getKeys(false)) {
                dataParts.add((CallSite)((Object)(dataKey + "=" + String.valueOf(dataSection.get(dataKey)))));
            }
            blockData = ((String)blockData).concat(String.join((CharSequence)",", dataParts));
            try {
                this.block = plugin.getServer().createBlockData((String)blockData + "]");
            }
            catch (IllegalArgumentException e) {
                this.errors.add("Invalid block data set! Make sure the block exists and that all of its properties are valid.");
            }
        }
    }

    public ADBlockDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, String name, Location location, boolean saveToConfig) {
        super(plugin, displaysManager, name, location, DisplayType.BLOCK, EntityType.BLOCK_DISPLAY, saveToConfig);
    }

    @Override
    public void sendMetadataPackets(Player player) {
        super.sendMetadataPackets(player);
        this.packets.setMetadata(this.entityId, player, this.metadata.BLOCK, this.block);
    }

    public ADBlockDisplay create(BlockData block) {
        this.create();
        this.setBlock(block);
        return this;
    }

    @Override
    public BlockData getBlock() {
        return this.block;
    }

    @Override
    public void setBlock(BlockData block) {
        this.block = block;
        if (this.config != null) {
            if (this.oraxenId != null) {
                this.settings.set("oraxen", (Object)this.oraxenId);
            }
            if (this.itemsAdderId != null) {
                this.settings.set("itemsAdder", (Object)this.itemsAdderId);
            }
            this.settings.set("block", (Object)block.getMaterial().name());
            ConfigurationSection dataSection = this.settings.createSection("blockData");
            if (block.getAsString().indexOf("[") > 0) {
                String fullData = block.getAsString().substring(block.getAsString().indexOf("[") + 1, block.getAsString().lastIndexOf("]"));
                for (String data : fullData.split(",")) {
                    String[] dataPart = data.split("=");
                    dataSection.set(dataPart[0], (Object)dataPart[1]);
                }
            }
            this.settings.setComments("blockData", List.of("For more information about what these values are, visit https://hub.spigotmc.org/javadocs/spigot/org/bukkit/block/data/BlockData.html"));
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setBlock(block, onlinePlayer);
        }
    }

    @Override
    public void setBlock(BlockData block, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.BLOCK, block);
    }
}

