/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.ActionsHandler;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionType;
import me.lucaaa.advanceddisplays.api.actions.DisplayActions;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.api.displays.BlockDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.api.displays.enums.NameVisibility;
import me.lucaaa.advanceddisplays.api.displays.visibility.VisibilityManager;
import me.lucaaa.advanceddisplays.data.PlayerData;
import me.lucaaa.advanceddisplays.data.Ticking;
import me.lucaaa.advanceddisplays.displays.ADVisibilityManager;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import me.lucaaa.advanceddisplays.nms_common.Metadata;
import me.lucaaa.advanceddisplays.nms_common.PacketInterface;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import shaded.net.kyori.adventure.text.Component;

public class ADBaseEntity
extends Ticking
implements BaseEntity {
    protected final AdvancedDisplays plugin;
    protected final Metadata metadata;
    private final DisplaysManager displaysManager;
    protected final PacketInterface packets;
    protected final ConfigManager config;
    private final ActionsHandler actionsHandler;
    private final ADVisibilityManager visibilityManager;
    protected ConfigurationSection entitySection;
    private final String name;
    protected final DisplayType type;
    protected Entity entity;
    protected EntityType entityType;
    protected int entityId;
    private final boolean isApi;
    private boolean isRemoved = false;
    protected List<String> errors = new ArrayList<String>();
    protected Location location;
    protected float yaw;
    protected float pitch;
    private boolean isOnFire;
    private boolean isSprinting;
    protected boolean isGlowing;
    protected ChatColor glowColor;
    private String customName;
    private NameVisibility customNameVisibility;

    protected ADBaseEntity(AdvancedDisplays plugin, DisplaysManager displaysManager, ConfigManager config, String name, DisplayType type, EntityType entityType) {
        super(plugin);
        this.startTicking();
        this.plugin = plugin;
        this.metadata = plugin.metadata;
        this.displaysManager = displaysManager;
        this.packets = plugin.getPacketsManager().getPackets();
        this.name = name;
        this.type = type;
        this.entityType = entityType;
        this.isApi = displaysManager.isApi();
        this.config = config;
        ConfigurationSection rotationSection = config.getSection("rotation");
        this.yaw = (float)config.getOrDefault("yaw", 0.0, rotationSection).doubleValue();
        this.pitch = (float)config.getOrDefault("pitch", 0.0, rotationSection).doubleValue();
        ConfigurationSection locationSection = config.getSection("location");
        String world = locationSection.getString("world", ((World)plugin.getServer().getWorlds().get(0)).getName());
        double x = locationSection.getDouble("x");
        double y = locationSection.getDouble("y");
        double z = locationSection.getDouble("z");
        this.location = new Location(plugin.getServer().getWorld(world), x, y, z, this.yaw, this.pitch);
        this.actionsHandler = new ActionsHandler(plugin, this, config);
        this.visibilityManager = new ADVisibilityManager(plugin, this);
        this.entitySection = config.getSection("entity", false, (ConfigurationSection)config.getConfig());
        this.isOnFire = config.getOrDefault("onFire", false, this.entitySection);
        this.isSprinting = config.getOrDefault("sprinting", false, this.entitySection);
        ConfigurationSection glowSection = config.getSection("glow", this.entitySection);
        this.isGlowing = config.getOrDefault("glowing", false, glowSection);
        this.customName = config.getOrDefault("custom-name", entityType.name(), this.entitySection);
        try {
            this.glowColor = ChatColor.valueOf((String)config.getOrDefault("color", ChatColor.GOLD.name(), glowSection));
            this.customNameVisibility = NameVisibility.valueOf(config.getOrDefault("name-visibility", NameVisibility.HIDDEN.name(), this.entitySection));
        }
        catch (IllegalArgumentException e) {
            this.errors.add("Invalid glow color or name visibility.");
            return;
        }
        this.entity = this.packets.createEntity(entityType, this.location);
        this.entity.teleport(this.location);
        this.entityId = this.entity.getEntityId();
    }

    protected ADBaseEntity(AdvancedDisplays plugin, DisplaysManager displaysManager, String name, DisplayType type, EntityType entityType, Location location, boolean saveToConfig) {
        super(plugin);
        this.startTicking();
        this.plugin = plugin;
        this.metadata = plugin.metadata;
        this.displaysManager = displaysManager;
        this.packets = plugin.getPacketsManager().getPackets();
        this.name = name;
        this.type = type;
        this.entity = this.packets.createEntity(entityType, location);
        this.entityType = entityType;
        this.entityId = this.entity.getEntityId();
        this.isApi = displaysManager.isApi();
        this.config = saveToConfig ? this.createConfig(location) : null;
        Location noRotation = location.clone();
        noRotation.setYaw(0.0f);
        noRotation.setPitch(0.0f);
        this.location = noRotation;
        this.actionsHandler = new ActionsHandler(plugin, this, this.config);
        this.visibilityManager = new ADVisibilityManager(plugin, this);
        this.yaw = 0.0f;
        this.pitch = 0.0f;
        this.isGlowing = this.entity.isGlowing();
        this.glowColor = ChatColor.GOLD;
        this.customName = null;
        this.customNameVisibility = NameVisibility.HIDDEN;
        if (this.config != null) {
            this.entitySection = this.config.getSection("entity", false, (ConfigurationSection)this.config.getConfig());
        }
    }

    protected ConfigManager createConfig(Location location) {
        ConfigManager displayConfigManager = new ConfigManager(this.plugin, this.displaysManager.getConfigsFolder() + File.separator + this.name + ".yml", false);
        YamlConfiguration displayConfig = displayConfigManager.getConfig();
        displayConfig.set("type", (Object)this.type.name());
        ConfigurationSection viewConditionsSection = displayConfig.createSection("view-conditions");
        viewConditionsSection.set("distance", (Object)0.0);
        viewConditionsSection.set("has-permission", (Object)"none");
        viewConditionsSection.set("lacks-permission", (Object)"none");
        ConfigurationSection locationSection = displayConfig.createSection("location");
        locationSection.set("world", (Object)Objects.requireNonNull(location.getWorld()).getName());
        locationSection.set("x", (Object)location.getX());
        locationSection.set("y", (Object)location.getY());
        locationSection.set("z", (Object)location.getZ());
        ConfigurationSection rotationSection = displayConfig.createSection("rotation");
        rotationSection.set("yaw", (Object)0.0);
        rotationSection.set("pitch", (Object)0.0);
        ConfigurationSection entitySection = displayConfig.createSection("entity");
        entitySection.set("type", (Object)this.entityType.name());
        entitySection.set("onFire", (Object)false);
        entitySection.set("sprinting", (Object)false);
        entitySection.set("custom-name", (Object)this.entityType.name());
        entitySection.set("name-visibility", (Object)NameVisibility.HIDDEN.name());
        ConfigurationSection glowSection = entitySection.createSection("glow");
        glowSection.set("glowing", (Object)false);
        glowSection.set("color", (Object)ChatColor.GOLD.name());
        ConfigurationSection actionsSection = displayConfig.createSection("actions");
        ConfigurationSection anySection = actionsSection.createSection("ANY");
        ConfigurationSection actionSetting = anySection.createSection("messagePlayer");
        actionSetting.set("type", (Object)ActionType.MESSAGE.getConfigName());
        actionSetting.set("message", (Object)"You clicked me, %player_name%!");
        actionSetting.set("global", (Object)false);
        actionSetting.set("global-placeholders", (Object)true);
        actionSetting.set("delay", (Object)0);
        actionSetting.set("cooldown", (Object)0);
        actionSetting.set("cooldown-message", (Object)"&cAction cooling down!");
        actionSetting.setInlineComments("delay", List.of("In ticks"));
        actionSetting.setInlineComments("cooldown", List.of("In ticks"));
        displayConfigManager.save();
        return displayConfigManager;
    }

    public void sendMetadataPackets(Player player) {
        this.packets.setLocation(this.entity, this.location, player);
        Metadata.DataPair<Optional<Object>> customNamePair = this.customName == null || this.customNameVisibility == NameVisibility.HIDDEN ? new Metadata.DataPair(this.metadata.CUSTOM_NAME, Optional.empty()) : new Metadata.DataPair<Optional<Component>>(this.metadata.CUSTOM_NAME, Optional.of(this.plugin.getMessagesManager().parseColorsAndPlaceholders(player, this.customName)));
        this.packets.setMetadata(this.entityId, player, new Metadata.DataPair<Byte>(this.metadata.PROPERTIES, Metadata.getProperties(this.isOnFire, this.isSprinting, this.isGlowing)), customNamePair, new Metadata.DataPair<Boolean>(this.metadata.CUSTOM_NAME_VISIBLE, this.customNameVisibility == NameVisibility.SHOWN));
        this.packets.setGlowingColor(this.entity, this.glowColor, player);
    }

    public ADBaseEntity create() {
        if (this.config != null) {
            this.entitySection.set("type", (Object)this.entityType.name());
            this.save();
        }
        return this;
    }

    public int getInteractionId() {
        return this.entityId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DisplayType getType() {
        return this.type;
    }

    @Override
    public VisibilityManager getVisibilityManager() {
        return this.visibilityManager;
    }

    @Override
    public void openEditor(Player player) {
        this.openEditor(player, List.of());
    }

    @Override
    public void openEditor(Player player, List<EditorItem> disabledSettings) {
        this.plugin.getPlayersManager().getPlayerData(player).startEditing(this, disabledSettings);
        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aYou are now editing the display &e" + this.name + "&a. Run &e/ad finish &ato get your old inventory back."));
    }

    @Override
    public void closeEditor(Player player) {
        PlayerData playerData = this.plugin.getPlayersManager().getPlayerData(player);
        if (!playerData.isEditing()) {
            return;
        }
        playerData.finishEditing();
        player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aYour old inventory has been given back to you."));
    }

    @Override
    public void setClickActions(DisplayActions actions) {
        this.actionsHandler.setClickActions(actions);
    }

    public void runActions(Player player, ClickType clickType) {
        this.actionsHandler.runActions(player, clickType, this);
    }

    public void spawnToPlayer(Player player) {
        this.packets.spawnEntity(this.entity, player);
        this.sendMetadataPackets(player);
    }

    public void removeToPlayer(Player player) {
        this.packets.removeEntity(this.entityId, player);
    }

    public void destroy() {
        this.packets.removeEntity(this.entityId);
        this.stopTicking();
    }

    @Override
    public void remove() {
        this.displaysManager.removeDisplay(this, true, true);
    }

    public void setRemoved() {
        this.isRemoved = true;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isApi() {
        return this.isApi;
    }

    public ConfigManager getConfigManager() {
        return this.config;
    }

    protected void save() {
        this.config.save();
    }

    @Override
    public void tick() {
        this.visibilityManager.updateVisibility();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        if (this.config != null) {
            ConfigurationSection locationSection = this.config.getSection("location", (ConfigurationSection)this.config.getConfig());
            locationSection.set("world", (Object)Objects.requireNonNull(location.getWorld()).getName());
            locationSection.set("x", (Object)location.getX());
            locationSection.set("y", (Object)location.getY());
            locationSection.set("z", (Object)location.getZ());
            this.save();
        }
        location.setYaw(this.yaw);
        location.setPitch(this.pitch);
        if (this.location.getWorld() == location.getWorld()) {
            this.entity.teleport(location);
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                this.packets.setLocation(this.entity, location, onlinePlayer);
            }
        } else {
            this.packets.removeEntity(this.entityId);
            this.plugin.getInteractionsManager().removeInteraction(this.getInteractionId());
            this.entity = this.packets.createEntity(this.entityType, location);
            this.entityId = this.entity.getEntityId();
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                this.sendMetadataPackets(onlinePlayer);
            }
            this.plugin.getInteractionsManager().addInteraction(this.getInteractionId(), this);
        }
        this.location = location;
    }

    @Override
    public Location center() {
        Location centered = this.location.clone();
        centered.setX((double)this.location.getBlockX());
        centered.setY((double)this.location.getBlockY());
        centered.setZ((double)this.location.getBlockZ());
        if (!(this instanceof BlockDisplay)) {
            centered.add(0.5, 0.0, 0.5);
        }
        this.setLocation(centered);
        return centered;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.location.setYaw(yaw);
        this.yaw = yaw;
        this.location.setPitch(pitch);
        this.pitch = pitch;
        if (this.config != null) {
            ConfigurationSection rotationSection = this.config.getSection("rotation");
            rotationSection.set("yaw", (Object)Float.valueOf(yaw));
            rotationSection.set("pitch", (Object)Float.valueOf(pitch));
            this.save();
        }
        this.entity.teleport(this.location);
        this.entity.setRotation(yaw, pitch);
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.packets.setLocation(this.entity, this.location, onlinePlayer);
        }
    }

    @Override
    public boolean isOnFire() {
        return this.isOnFire;
    }

    @Override
    public void setOnFire(boolean onFire) {
        this.isOnFire = onFire;
        if (this.config != null) {
            this.entitySection.set("onFire", (Object)onFire);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setOnFire(onFire, onlinePlayer);
        }
    }

    @Override
    public void setOnFire(boolean onFire, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.PROPERTIES, Metadata.getProperties(onFire, this.isSprinting, this.isGlowing));
    }

    @Override
    public boolean isSprinting() {
        return this.isSprinting;
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.isSprinting = sprinting;
        if (this.config != null) {
            this.entitySection.set("sprinting", (Object)sprinting);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setSprinting(sprinting, onlinePlayer);
        }
    }

    @Override
    public void setSprinting(boolean sprinting, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.PROPERTIES, Metadata.getProperties(this.isOnFire, sprinting, this.isGlowing));
    }

    @Override
    public boolean isGlowing() {
        return this.isGlowing;
    }

    @Override
    public void setGlowing(boolean isGlowing) {
        this.isGlowing = isGlowing;
        if (this.config != null) {
            ConfigurationSection glowSection = this.config.getSection("glow", this.entitySection);
            glowSection.set("glowing", (Object)isGlowing);
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setGlowing(isGlowing, onlinePlayer);
        }
    }

    @Override
    public void setGlowing(boolean isGlowing, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.PROPERTIES, Metadata.getProperties(this.isOnFire, this.isSprinting, isGlowing));
    }

    @Override
    public ChatColor getGlowColor() {
        return this.glowColor;
    }

    @Override
    public void setGlowColor(ChatColor color) {
        if (color.isFormat()) {
            return;
        }
        this.glowColor = color;
        if (this.config != null) {
            ConfigurationSection glowSection = this.config.getSection("glow", this.entitySection);
            glowSection.set("color", (Object)color.name());
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setGlowColor(this.glowColor, onlinePlayer);
        }
    }

    @Override
    public void setGlowColor(ChatColor color, Player player) {
        if (color.isFormat()) {
            return;
        }
        this.packets.setGlowingColor(this.entity, this.glowColor, player);
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public void setCustomName(String customName, NameVisibility visibility) {
        this.customName = customName;
        this.customNameVisibility = visibility;
        if (this.config != null) {
            this.entitySection.set("custom-name", (Object)customName);
            this.entitySection.set("name-visibility", (Object)visibility.name());
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setCustomName(customName, visibility, onlinePlayer);
        }
    }

    @Override
    public void setCustomName(String customName, NameVisibility visibility, Player player) {
        Metadata.DataPair<Optional<Object>> customNamePair = customName == null || visibility == NameVisibility.HIDDEN ? new Metadata.DataPair(this.metadata.CUSTOM_NAME, Optional.empty()) : new Metadata.DataPair<Optional<Component>>(this.metadata.CUSTOM_NAME, Optional.of(this.plugin.getMessagesManager().parseColorsAndPlaceholders(player, customName)));
        this.packets.setMetadata(this.entityId, player, customNamePair, new Metadata.DataPair<Boolean>(this.metadata.CUSTOM_NAME_VISIBLE, visibility == NameVisibility.SHOWN));
    }

    @Override
    public NameVisibility getCustomNameVisibility() {
        return this.customNameVisibility;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrorsOnLoad() {
        return !this.errors.isEmpty();
    }
}

