/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.displays;

import java.util.Arrays;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.BaseDisplay;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.data.ConfigAxisAngle4f;
import me.lucaaa.advanceddisplays.data.ConfigVector3f;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import me.lucaaa.advanceddisplays.nms_common.Metadata;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ADBaseDisplay
extends ADBaseEntity
implements BaseDisplay {
    protected ConfigurationSection displaySection = null;
    protected ConfigurationSection settings = null;
    private Display.Billboard billboard;
    private Display.Brightness brightness;
    private float shadowRadius;
    private float shadowStrength;
    private Transformation transformation;
    private Interaction hitbox;
    private boolean overrideHitboxSize;
    private float hitboxWidth;
    private float hitboxHeight;
    private Color glowColorOverride;

    protected ADBaseDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, ConfigManager config, String name, DisplayType type, EntityType entityType) {
        super(plugin, displaysManager, config, name, type, entityType);
        this.displaySection = config.getSection("display", false, (ConfigurationSection)config.getConfig());
        this.settings = config.getSection("settings", false, this.displaySection);
        ConfigurationSection brightnessSection = config.getSection("brightness", this.displaySection);
        this.brightness = new Display.Brightness(config.getOrDefault("block", 15, brightnessSection).intValue(), config.getOrDefault("sky", 15, brightnessSection).intValue());
        ConfigurationSection shadowSection = config.getSection("shadow", this.displaySection);
        this.shadowRadius = (float)config.getOrDefault("radius", 1.0, shadowSection).doubleValue();
        this.shadowStrength = (float)config.getOrDefault("strength", 1.0, shadowSection).doubleValue();
        ConfigurationSection transformationSection = config.getSection("transformation", this.displaySection);
        this.transformation = new Transformation(new ConfigVector3f(config.getSection("translation", transformationSection).getValues(false)).toVector3f(), new ConfigAxisAngle4f(config.getSection("leftRotation", transformationSection).getValues(false)).toAxisAngle4f(), new ConfigVector3f(config.getSection("scale", transformationSection).getValues(false)).toVector3f(), new ConfigAxisAngle4f(config.getSection("rightRotation", transformationSection).getValues(false)).toAxisAngle4f());
        Location location1 = this.location.clone();
        if (type == DisplayType.BLOCK) {
            double x1 = this.transformation.getScale().x / 2.0f;
            double z1 = this.transformation.getScale().z / 2.0f;
            location1.add(x1, 0.0, z1);
        }
        this.hitbox = (Interaction)this.packets.createEntity(EntityType.INTERACTION, location1);
        ConfigurationSection hitboxSection = config.getSection("hitbox", this.displaySection);
        this.overrideHitboxSize = config.getOrDefault("override", false, hitboxSection);
        this.hitboxWidth = (float)config.getOrDefault("width", 1.0, hitboxSection).doubleValue();
        this.hitboxHeight = (float)config.getOrDefault("height", 1.0, hitboxSection).doubleValue();
        try {
            this.billboard = Display.Billboard.valueOf((String)config.getOrDefault("billboard", "FIXED", this.displaySection));
            String[] colorParts = config.getOrDefault("glow-color-override", "255;170;0", this.displaySection).split(";");
            this.glowColorOverride = Color.fromRGB((int)Integer.parseInt(colorParts[0]), (int)Integer.parseInt(colorParts[1]), (int)Integer.parseInt(colorParts[2]));
        }
        catch (IllegalArgumentException e) {
            this.errors.add("Invalid billboard type or invalid glow color override - make sure none of the color components are lower than 0 or higher than 255");
        }
    }

    protected ADBaseDisplay(AdvancedDisplays plugin, DisplaysManager displaysManager, String name, Location location, DisplayType type, EntityType entityType, boolean saveToConfig) {
        super(plugin, displaysManager, name, type, entityType, location, saveToConfig);
        Display display = (Display)this.entity;
        this.billboard = Display.Billboard.CENTER;
        this.brightness = new Display.Brightness(15, 15);
        this.shadowRadius = display.getShadowRadius();
        this.shadowStrength = display.getShadowStrength();
        this.transformation = display.getTransformation();
        Location location1 = location.clone();
        if (this.type == DisplayType.BLOCK) {
            double x1 = this.transformation.getScale().x / 2.0f;
            double z1 = this.transformation.getScale().z / 2.0f;
            location1.add(x1, 0.0, z1);
        }
        this.hitbox = (Interaction)this.packets.createEntity(EntityType.INTERACTION, location1);
        this.overrideHitboxSize = false;
        this.hitboxWidth = this.transformation.getScale().x;
        this.hitboxHeight = this.transformation.getScale().z;
        this.glowColorOverride = Color.ORANGE;
        if (this.config != null) {
            this.displaySection = this.config.getSection("display", false, (ConfigurationSection)this.config.getConfig());
            this.settings = this.config.getSection("settings", false, this.displaySection);
        }
    }

    @Override
    protected ConfigManager createConfig(Location location) {
        ConfigManager config = super.createConfig(location);
        YamlConfiguration displayConfig = config.getConfig();
        this.displaySection = displayConfig.createSection("display");
        this.settings = this.displaySection.createSection("settings");
        this.displaySection.set("billboard", (Object)Display.Billboard.CENTER.name());
        ConfigurationSection brightnessSection = this.displaySection.createSection("brightness");
        brightnessSection.set("block", (Object)15);
        brightnessSection.set("sky", (Object)15);
        ConfigurationSection shadowSection = this.displaySection.createSection("shadow");
        shadowSection.set("radius", (Object)5.0);
        shadowSection.set("strength", (Object)1.0);
        ConfigurationSection transformationSection = this.displaySection.createSection("transformation");
        transformationSection.createSection("translation", new ConfigVector3f().serialize());
        transformationSection.createSection("leftRotation", new ConfigAxisAngle4f().serialize());
        transformationSection.createSection("scale", new ConfigVector3f(1.0f, 1.0f, 1.0f).serialize());
        transformationSection.createSection("rightRotation", new ConfigAxisAngle4f().serialize());
        ConfigurationSection hitboxSection = this.displaySection.createSection("hitbox");
        hitboxSection.set("override", (Object)false);
        hitboxSection.set("width", (Object)Float.valueOf(1.0f));
        hitboxSection.set("height", (Object)Float.valueOf(1.0f));
        this.displaySection.setComments("hitbox", Arrays.asList("Displays don't have hitboxes of their own, so to have click actions independent entities have to be created.", "These settings allow you to control the hitbox of the display.", "(Use F3 + B to see the hitboxes)"));
        this.displaySection.set("glow-color-override", (Object)"255;170;0");
        config.save();
        return config;
    }

    @Override
    public void sendMetadataPackets(Player player) {
        super.sendMetadataPackets(player);
        if (!this.overrideHitboxSize) {
            this.packets.setMetadata(this.hitbox.getEntityId(), player, new Metadata.DataPair<Float>(this.metadata.HITBOX_WIDTH, Float.valueOf(this.transformation.getScale().x)), new Metadata.DataPair<Float>(this.metadata.HITBOX_HEIGHT, Float.valueOf(this.transformation.getScale().y)));
        } else {
            this.packets.setMetadata(this.hitbox.getEntityId(), player, new Metadata.DataPair<Float>(this.metadata.HITBOX_WIDTH, Float.valueOf(this.hitboxWidth)), new Metadata.DataPair<Float>(this.metadata.HITBOX_HEIGHT, Float.valueOf(this.hitboxHeight)));
        }
        this.packets.setMetadata(this.entityId, player, new Metadata.DataPair<Vector3f>(this.metadata.TRANSLATION, this.transformation.getTranslation()), new Metadata.DataPair<Vector3f>(this.metadata.SCALE, this.transformation.getScale()), new Metadata.DataPair<Quaternionf>(this.metadata.LEFT_ROTATION, this.transformation.getLeftRotation()), new Metadata.DataPair<Quaternionf>(this.metadata.RIGHT_ROTATION, this.transformation.getRightRotation()), new Metadata.DataPair<Byte>(this.metadata.BILLBOARD, Metadata.getBillboardByte(this.billboard)), new Metadata.DataPair<Integer>(this.metadata.BRIGHTNESS, this.brightness.getBlockLight() << 4 | this.brightness.getSkyLight() << 20), new Metadata.DataPair<Float>(this.metadata.SHADOW_RADIUS, Float.valueOf(this.shadowRadius)), new Metadata.DataPair<Float>(this.metadata.SHADOW_STRENGTH, Float.valueOf(this.shadowStrength)), new Metadata.DataPair<Byte>(this.metadata.PROPERTIES, (byte)(this.isGlowing ? 64 : 0)), new Metadata.DataPair<Integer>(this.metadata.GLOW_COLOR, this.glowColorOverride.asRGB()));
    }

    @Override
    public int getInteractionId() {
        return this.hitbox.getEntityId();
    }

    @Override
    public void setLocation(Location location) {
        if (this.config != null) {
            ConfigurationSection locationSection = this.config.getSection("location", (ConfigurationSection)this.config.getConfig());
            locationSection.set("world", (Object)Objects.requireNonNull(location.getWorld()).getName());
            locationSection.set("x", (Object)location.getX());
            locationSection.set("y", (Object)location.getY());
            locationSection.set("z", (Object)location.getZ());
            this.save();
        }
        location.setYaw(this.yaw);
        location.setPitch(this.pitch);
        if (this.location.getWorld() == location.getWorld()) {
            location1 = location.clone();
            if (this.type == DisplayType.BLOCK) {
                double x1 = this.transformation.getScale().x / 2.0f;
                double z1 = this.transformation.getScale().z / 2.0f;
                location1.add(x1, 0.0, z1);
            }
            this.entity.teleport(location);
            this.hitbox.teleport(location1);
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                this.packets.setLocation(this.entity, location, onlinePlayer);
                this.packets.setLocation((Entity)this.hitbox, location1, onlinePlayer);
            }
        } else {
            this.packets.removeEntity(this.entityId);
            this.packets.removeEntity(this.hitbox.getEntityId());
            this.plugin.getInteractionsManager().removeInteraction(this.getInteractionId());
            this.entity = this.packets.createEntity(this.entityType, location);
            this.entityId = this.entity.getEntityId();
            location1 = location.clone();
            if (this.type == DisplayType.BLOCK) {
                double x1 = this.transformation.getScale().x / 2.0f;
                double z1 = this.transformation.getScale().z / 2.0f;
                location1.add(x1, 0.0, z1);
            }
            this.hitbox = (Interaction)this.packets.createEntity(EntityType.INTERACTION, location1);
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                this.sendMetadataPackets(onlinePlayer);
            }
            this.plugin.getInteractionsManager().addInteraction(this.getInteractionId(), this);
        }
        this.location = location;
    }

    @Override
    public Display.Billboard getBillboard() {
        return this.billboard;
    }

    @Override
    public void setBillboard(Display.Billboard billboard) {
        this.billboard = billboard;
        if (this.config != null) {
            this.displaySection.set("billboard", (Object)billboard.name());
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setBillboard(billboard, onlinePlayer);
        }
    }

    @Override
    public void setBillboard(Display.Billboard billboard, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.BILLBOARD, Metadata.getBillboardByte(billboard));
    }

    @Override
    public Display.Brightness getBrightness() {
        return this.brightness;
    }

    @Override
    public void setBrightness(Display.Brightness brightness) {
        this.brightness = brightness;
        if (this.config != null) {
            ConfigurationSection brightnessSection = this.config.getSection("brightness", this.displaySection);
            brightnessSection.set("block", (Object)brightness.getBlockLight());
            brightnessSection.set("sky", (Object)brightness.getSkyLight());
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setBrightness(brightness, onlinePlayer);
        }
    }

    @Override
    public void setBrightness(Display.Brightness brightness, Player player) {
        this.packets.setMetadata(this.entityId, player, this.metadata.BRIGHTNESS, brightness.getBlockLight() << 4 | brightness.getSkyLight() << 20);
    }

    @Override
    public float getShadowRadius() {
        return this.shadowRadius;
    }

    @Override
    public float getShadowStrength() {
        return this.shadowStrength;
    }

    @Override
    public void setShadow(float shadowRadius, float shadowStrength) {
        this.shadowRadius = shadowRadius;
        this.shadowStrength = shadowStrength;
        if (this.config != null) {
            ConfigurationSection shadowSection = this.config.getSection("shadow", this.displaySection);
            shadowSection.set("radius", (Object)Float.valueOf(shadowRadius));
            shadowSection.set("strength", (Object)Float.valueOf(shadowStrength));
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setShadow(shadowRadius, shadowStrength, onlinePlayer);
        }
    }

    @Override
    public void setShadow(float shadowRadius, float shadowStrength, Player player) {
        this.packets.setMetadata(this.entityId, player, new Metadata.DataPair<Float>(this.metadata.SHADOW_RADIUS, Float.valueOf(shadowRadius)), new Metadata.DataPair<Float>(this.metadata.SHADOW_STRENGTH, Float.valueOf(shadowStrength)));
    }

    @Override
    public Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
        if (!this.overrideHitboxSize) {
            this.hitbox.setInteractionWidth(transformation.getScale().x);
            this.hitbox.setInteractionHeight(transformation.getScale().y);
        }
        if (this.config != null) {
            ConfigurationSection transformationSection = this.config.getSection("transformation", this.displaySection);
            transformationSection.createSection("translation", new ConfigVector3f(transformation.getTranslation()).serialize());
            transformationSection.createSection("leftRotation", new ConfigAxisAngle4f(transformation.getLeftRotation()).serialize());
            transformationSection.createSection("scale", new ConfigVector3f(transformation.getScale()).serialize());
            transformationSection.createSection("rightRotation", new ConfigAxisAngle4f(transformation.getRightRotation()).serialize());
            this.save();
        }
        Location location1 = this.location.clone();
        if (this.type == DisplayType.BLOCK) {
            double x1 = transformation.getScale().x / 2.0f;
            double z1 = transformation.getScale().z / 2.0f;
            location1.add(x1, 0.0, z1);
        }
        this.hitbox.teleport(location1);
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setTransformation(transformation, onlinePlayer);
            this.packets.setLocation((Entity)this.hitbox, this.location, onlinePlayer);
        }
    }

    @Override
    public void setTransformation(Transformation transformation, Player player) {
        this.packets.setMetadata(this.entityId, player, new Metadata.DataPair<Vector3f>(this.metadata.TRANSLATION, transformation.getTranslation()), new Metadata.DataPair<Vector3f>(this.metadata.SCALE, transformation.getScale()), new Metadata.DataPair<Quaternionf>(this.metadata.LEFT_ROTATION, transformation.getLeftRotation()), new Metadata.DataPair<Quaternionf>(this.metadata.RIGHT_ROTATION, transformation.getRightRotation()));
        if (!this.overrideHitboxSize) {
            this.packets.setMetadata(this.hitbox.getEntityId(), player, new Metadata.DataPair<Float>(this.metadata.HITBOX_WIDTH, Float.valueOf(transformation.getScale().x)), new Metadata.DataPair<Float>(this.metadata.HITBOX_HEIGHT, Float.valueOf(transformation.getScale().y)));
        }
    }

    @Override
    public void setHitboxSize(boolean override, float width, float height) {
        this.overrideHitboxSize = override;
        this.hitboxWidth = override ? width : this.transformation.getScale().x;
        float f = this.hitboxHeight = override ? height : this.transformation.getScale().y;
        if (this.config != null) {
            ConfigurationSection hitboxSection = this.config.getSection("hitbox", this.displaySection);
            hitboxSection.set("override", (Object)override);
            hitboxSection.set("width", (Object)Float.valueOf(width));
            hitboxSection.set("height", (Object)Float.valueOf(height));
            this.save();
        }
        this.hitbox.setInteractionWidth(this.hitboxWidth);
        this.hitbox.setInteractionHeight(this.hitboxHeight);
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.packets.setMetadata(this.hitbox.getEntityId(), onlinePlayer, new Metadata.DataPair<Float>(this.metadata.HITBOX_WIDTH, Float.valueOf(this.hitboxWidth)), new Metadata.DataPair<Float>(this.metadata.HITBOX_HEIGHT, Float.valueOf(this.hitboxHeight)));
        }
    }

    @Override
    public Color getGlowColorOverride() {
        return this.glowColorOverride;
    }

    @Override
    public void setGlowColorOverride(Color color) {
        this.glowColorOverride = color;
        if (this.config != null) {
            this.displaySection.set("glow-color-override", (Object)(color.getRed() + ";" + color.getGreen() + ";" + color.getBlue()));
            this.save();
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            this.setGlowColorOverride(color, onlinePlayer);
        }
    }

    @Override
    public void setGlowColorOverride(Color color, Player player) {
        this.packets.setMetadata(this.entityId, player, new Metadata.DataPair<Byte>(this.metadata.PROPERTIES, (byte)(this.isGlowing ? 64 : 0)), new Metadata.DataPair<Integer>(this.metadata.GLOW_COLOR, this.glowColorOverride.asRGB()));
    }

    @Override
    public float getHitboxWidth() {
        return this.hitboxWidth;
    }

    @Override
    public float getHitboxHeight() {
        return this.hitboxHeight;
    }

    @Override
    public boolean isHitboxSizeOverriden() {
        return this.overrideHitboxSize;
    }

    @Override
    public void setGlowing(boolean isGlowing, Player player) {
        this.packets.setMetadata(this.entityId, player, new Metadata.DataPair<Byte>(this.metadata.PROPERTIES, (byte)(isGlowing ? 64 : 0)), new Metadata.DataPair<Integer>(this.metadata.GLOW_COLOR, this.glowColorOverride.asRGB()));
    }

    @Override
    public void spawnToPlayer(Player player) {
        this.packets.spawnEntity((Entity)this.hitbox, player);
        super.spawnToPlayer(player);
    }

    @Override
    public void removeToPlayer(Player player) {
        super.removeToPlayer(player);
        this.packets.removeEntity(this.getInteractionId(), player);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.plugin.getInteractionsManager().removeInteraction(this.getInteractionId());
        this.packets.removeEntity(this.getInteractionId());
    }
}

