/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.data;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.util.ComponentSerializer;
import me.lucaaa.advanceddisplays.data.Compatibility;
import me.lucaaa.advanceddisplays.inventory.inventories.DisplayEditorGUI;
import me.lucaaa.advanceddisplays.nms_common.Version;
import me.lucaaa.advanceddisplays.v1_21_R5.VersionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import shaded.net.kyori.adventure.text.Component;

public class Utils {
    public static String getColoredText(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String getTextString(String message, Player clickedPlayer, Player globalPlayer, boolean useGlobalPlaceholders) {
        return ComponentSerializer.getLegacyString(Utils.getText(message, clickedPlayer, globalPlayer, useGlobalPlaceholders));
    }

    public static Component getText(String message, Player clickedPlayer, Player globalPlayer, boolean useGlobalPlaceholders) {
        Player placeholderPlayer;
        message = message.replace("%player%", clickedPlayer.getName());
        if (globalPlayer != null) {
            message = message.replace("%global_player%", globalPlayer.getName());
        }
        Player player = placeholderPlayer = useGlobalPlaceholders ? globalPlayer : clickedPlayer;
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            message = PlaceholderAPI.setPlaceholders((Player)placeholderPlayer, (String)message);
        }
        return ComponentSerializer.deserialize(message);
    }

    public static Component combine(Component component1, Component component2) {
        return component1.appendNewline().append(component2);
    }

    public static void saveItemData(ItemStack item, ConfigurationSection settings, Version version) {
        AxolotlBucketMeta bucketMeta;
        PotionMeta potion;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (version.isEqualOrNewerThan(Version.v1_21_R3)) {
            VersionUtils.saveMetaCustomModelData(meta, settings);
        } else {
            int customModelData = meta.hasCustomModelData() ? meta.getCustomModelData() : 0;
            settings.set("customModelData", (Object)customModelData);
        }
        if (meta instanceof PotionMeta && (potion = (PotionMeta)meta).getColor() != null) {
            settings.set("color", (Object)(potion.getColor().getRed() + ";" + potion.getColor().getGreen() + ";" + potion.getColor().getBlue()));
        } else if (meta instanceof ArmorMeta) {
            ArmorMeta armor = (ArmorMeta)meta;
            if (armor.getTrim() == null) {
                settings.set("trim", null);
            } else {
                settings.set("trim", (Object)(armor.getTrim().getPattern().getKey().getKey() + ":" + armor.getTrim().getMaterial().getKey().getKey()));
            }
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmor = (LeatherArmorMeta)meta;
                settings.set("color", (Object)(leatherArmor.getColor().getRed() + ";" + leatherArmor.getColor().getGreen() + ";" + leatherArmor.getColor().getBlue()));
            }
        } else if (meta instanceof BannerMeta) {
            BannerMeta banner = (BannerMeta)meta;
            ArrayList<CallSite> patterns = new ArrayList<CallSite>();
            for (Pattern pattern : banner.getPatterns()) {
                patterns.add((CallSite)((Object)(pattern.getPattern().name() + ":" + pattern.getColor().name())));
            }
            settings.set("patterns", patterns);
        } else if (meta instanceof CompassMeta) {
            CompassMeta compass = (CompassMeta)meta;
            if (compass.getLodestone() == null) {
                settings.set("lodestone", null);
            } else {
                Location lodestone = compass.getLodestone();
                settings.set("lodestone", (Object)(lodestone.getX() + ";" + lodestone.getY() + ";" + lodestone.getZ()));
            }
        } else if (meta instanceof BundleMeta) {
            BundleMeta bundle = (BundleMeta)meta;
            settings.set("hasItems", (Object)bundle.hasItems());
        } else if (meta instanceof AxolotlBucketMeta && (bucketMeta = (AxolotlBucketMeta)meta).hasVariant()) {
            settings.set("axolotl-bucket", (Object)bucketMeta.getVariant().name());
        } else if (meta instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
            List chargedProjectiles = crossbowMeta.getChargedProjectiles();
            if (!chargedProjectiles.isEmpty()) {
                ItemStack firstProjectile = (ItemStack)chargedProjectiles.get(0);
                if (firstProjectile.getType() == Material.FIREWORK_ROCKET) {
                    settings.set("crossbow-ammo", (Object)DisplayEditorGUI.CrossbowAmmo.ROCKET.name());
                } else {
                    settings.set("crossbow-ammo", (Object)DisplayEditorGUI.CrossbowAmmo.ARROW.name());
                }
            } else {
                settings.set("crossbow-ammo", (Object)DisplayEditorGUI.CrossbowAmmo.NONE.name());
            }
        }
        if (!item.getEnchantments().isEmpty()) {
            settings.set("enchanted", (Object)(!item.getEnchantments().isEmpty() ? 1 : 0));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ItemStack loadItemData(ItemStack item, ConfigurationSection settings, World compassWorld, AdvancedDisplays plugin) {
        ItemMeta meta;
        block20: {
            Iterator saved3;
            BannerMeta banner;
            block23: {
                block26: {
                    block25: {
                        block24: {
                            block22: {
                                block21: {
                                    block19: {
                                        meta = item.getItemMeta();
                                        if (meta == null) {
                                            return item;
                                        }
                                        if (settings.isString("oraxen") && plugin.isIntegrationLoaded(Compatibility.ORAXEN)) {
                                            return plugin.getIntegration(Compatibility.ORAXEN).getItemStack(settings.getString("oraxen"));
                                        }
                                        if (settings.isString("itemsAdder") && plugin.isIntegrationLoaded(Compatibility.ORAXEN)) {
                                            return plugin.getIntegration(Compatibility.ITEMS_ADDER).getItemStack(settings.getString("itemsAdder"));
                                        }
                                        if (plugin.getNmsVersion().isEqualOrNewerThan(Version.v1_21_R3)) {
                                            VersionUtils.loadMetaCustomModelData(meta, settings);
                                        } else {
                                            int customModelData = settings.getInt("customModelData");
                                            if (customModelData != 0) {
                                                meta.setCustomModelData(Integer.valueOf(customModelData));
                                            }
                                        }
                                        if (!(meta instanceof PotionMeta)) break block19;
                                        PotionMeta potion = (PotionMeta)meta;
                                        if (!settings.isString("color")) break block19;
                                        String[] saved2 = settings.getString("color", "255;255;255").split(";");
                                        Color color = Color.fromRGB((int)Integer.parseInt(saved2[0]), (int)Integer.parseInt(saved2[1]), (int)Integer.parseInt(saved2[2]));
                                        potion.setColor(color);
                                        break block20;
                                    }
                                    if (!(meta instanceof ArmorMeta)) break block21;
                                    ArmorMeta armor = (ArmorMeta)meta;
                                    if (settings.isString("trim")) {
                                        String[] trim = settings.getString("trim", "sentry:netherite").toLowerCase().split(":");
                                        TrimMaterial material = (TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.minecraft((String)trim[1]));
                                        TrimPattern pattern = (TrimPattern)Registry.TRIM_PATTERN.get(NamespacedKey.minecraft((String)trim[0]));
                                        if (material == null || pattern == null) {
                                            plugin.log(Level.WARNING, "Invalid armor trim material and/or pattern: Material: " + trim[1] + " - Pattern: " + trim[0]);
                                        } else {
                                            armor.setTrim(new ArmorTrim(material, pattern));
                                        }
                                    }
                                    if (!(meta instanceof LeatherArmorMeta)) break block20;
                                    LeatherArmorMeta leatherArmor = (LeatherArmorMeta)meta;
                                    if (!settings.isString("color")) break block20;
                                    String[] saved3 = settings.getString("color", "255;255;255").split(";");
                                    Color color = Color.fromRGB((int)Integer.parseInt(saved3[0]), (int)Integer.parseInt(saved3[1]), (int)Integer.parseInt(saved3[2]));
                                    leatherArmor.setColor(color);
                                    break block20;
                                }
                                if (!(meta instanceof BannerMeta)) break block22;
                                banner = (BannerMeta)meta;
                                if (!settings.isList("patterns")) break block22;
                                List patterns = settings.getStringList("patterns");
                                saved3 = patterns.iterator();
                                break block23;
                            }
                            if (!(meta instanceof CompassMeta)) break block24;
                            CompassMeta compass = (CompassMeta)meta;
                            if (!settings.isString("lodestone")) break block24;
                            String[] location = settings.getString("lodestone", "0.0;0.0;0.0").split(";");
                            Location lodestone = new Location(compassWorld, Double.parseDouble(location[0]), Double.parseDouble(location[1]), Double.parseDouble(location[2]));
                            compass.setLodestone(lodestone);
                            break block20;
                        }
                        if (!(meta instanceof BundleMeta)) break block25;
                        BundleMeta bundle = (BundleMeta)meta;
                        if (settings.getBoolean("hasItems")) {
                            bundle.addItem(new ItemStack(Material.DIAMOND, 64));
                        }
                        break block20;
                    }
                    if (!(meta instanceof AxolotlBucketMeta)) break block26;
                    AxolotlBucketMeta bucketMeta = (AxolotlBucketMeta)meta;
                    if (settings.isString("axolotl-bucket")) {
                        String variant = settings.getString("axolotl-bucket", "").toUpperCase();
                        try {
                            bucketMeta.setVariant(Axolotl.Variant.valueOf((String)variant));
                        }
                        catch (IllegalArgumentException e) {
                            plugin.log(Level.WARNING, "Invalid axolotl variant: " + variant);
                        }
                    }
                    break block20;
                }
                if (!(meta instanceof CrossbowMeta)) break block20;
                CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
                if (!settings.isString("crossbow-ammo")) break block20;
                String ammo = settings.getString("crossbow-ammo");
                try {
                    DisplayEditorGUI.CrossbowAmmo crossbowAmmo = DisplayEditorGUI.CrossbowAmmo.valueOf(ammo);
                    crossbowMeta.setChargedProjectiles(crossbowAmmo.getItems());
                }
                catch (IllegalArgumentException e) {
                    plugin.log(Level.WARNING, "Invalid crossbow ammo: " + ammo);
                }
                break block20;
            }
            while (saved3.hasNext()) {
                String configPattern = (String)saved3.next();
                if (configPattern.isBlank()) continue;
                String[] parts = configPattern.split(":");
                try {
                    PatternType pattern = PatternType.valueOf((String)parts[0]);
                    DyeColor color = DyeColor.valueOf((String)parts[1]);
                    banner.addPattern(new Pattern(color, pattern));
                }
                catch (IllegalArgumentException e) {
                    plugin.log(Level.WARNING, "Invalid banner pattern type and/or color: " + configPattern);
                }
            }
        }
        if (settings.getBoolean("enchanted")) {
            meta.addEnchant(Enchantment.MENDING, 1, true);
        }
        Utils.hideFlags(meta);
        item.setItemMeta(meta);
        return item;
    }

    public static void hideFlags(ItemMeta meta) {
        for (ItemFlag flag : ItemFlag.values()) {
            meta.addItemFlags(new ItemFlag[]{flag});
        }
    }

    public static String locToString(Location loc) {
        return Utils.round(loc.getX()) + ";" + Utils.round(loc.getY()) + ";" + Utils.round(loc.getZ());
    }

    public static double round(double toRound) {
        return BigDecimal.valueOf(toRound).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public static List<String> isStringValidLoc(String loc) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!loc.matches("^[0-9~*;]+$")) {
            errors.add("The location can only have numbers, \";\", \"~\" or \"*\"! For decimals use dots (\".\"), NOT commas (\",\").");
        } else if (loc.split(";").length != 3) {
            errors.add("The location has an invalid format! It must be x;y;z");
        }
        return errors;
    }

    public static Double parsePosition(String toParse, CoordComponent component, Location relative, CommandSender sender) throws NumberFormatException {
        double parsedArg = 0.0;
        if (toParse.contains("~") && sender instanceof Player) {
            Player player = (Player)sender;
            toParse = toParse.replace("~", "");
            parsedArg = switch (component.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> player.getLocation().getX();
                case 1 -> player.getLocation().getY();
                case 2 -> player.getLocation().getZ();
            };
        } else if (toParse.contains("*")) {
            toParse = toParse.replace("*", "");
            parsedArg = switch (component.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> relative.getX();
                case 1 -> relative.getY();
                case 2 -> relative.getZ();
            };
        }
        double parsed = toParse.isBlank() ? 0.0 : Double.parseDouble(toParse);
        return Utils.round(parsedArg + parsed);
    }

    public static enum CoordComponent {
        X,
        Y,
        Z;

    }
}

