/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.Action;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import me.lucaaa.advanceddisplays.displays.AnimatedTextRunnable;
import me.lucaaa.advanceddisplays.inventory.inventories.PlayerEditorInv;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerData {
    private final AdvancedDisplays plugin;
    private final Player player;
    private final ConfigManager savesConfig;
    private BaseEntity editingDisplay;
    private ItemStack[] savedInventory;
    private PlayerEditorInv playerEditorInventory;
    private boolean isChatEditing = false;
    private final Map<ADTextDisplay, AnimatedTextRunnable> runnables = new HashMap<ADTextDisplay, AnimatedTextRunnable>();
    private final Map<Action, Long> cooldowns = new HashMap<Action, Long>();

    public PlayerData(Player player, AdvancedDisplays plugin) {
        this.plugin = plugin;
        this.player = player;
        this.savesConfig = plugin.getSavesConfig();
    }

    public void startEditing(BaseEntity display, List<EditorItem> disabledSettings) {
        if (this.isEditing()) {
            this.finishEditing();
        }
        this.editingDisplay = display;
        this.savedInventory = this.player.getInventory().getContents();
        YamlConfiguration config = this.savesConfig.getConfig();
        if (!config.contains("saved")) {
            config.createSection("saved");
        }
        ConfigurationSection saved = Objects.requireNonNull(config.getConfigurationSection("saved"));
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.player.getInventory().getContents().length; ++i) {
            if (this.player.getInventory().getItem(i) == null) continue;
            items.put(i, this.player.getInventory().getItem(i));
        }
        saved.set(this.player.getName(), items);
        this.savesConfig.save();
        this.playerEditorInventory = new PlayerEditorInv(this.plugin, this.player, display, disabledSettings);
    }

    public void finishEditing() {
        this.player.closeInventory();
        this.player.getInventory().setContents(this.savedInventory);
        this.editingDisplay = null;
        YamlConfiguration config = this.savesConfig.getConfig();
        if (!config.contains("saved")) {
            config.createSection("saved");
        }
        Objects.requireNonNull(config.getConfigurationSection("saved")).set(this.player.getName(), null);
        this.savesConfig.save();
    }

    public boolean isEditing() {
        return this.editingDisplay != null;
    }

    public void setChatEditing(boolean chatEditing) {
        this.isChatEditing = chatEditing;
    }

    public boolean isChatEditing() {
        return this.isChatEditing;
    }

    public void handleClick(PlayerInteractEvent event) {
        this.playerEditorInventory.handleClick(this.player.getInventory().getHeldItemSlot(), event);
    }

    public BaseEntity getEditingDisplay() {
        return this.editingDisplay;
    }

    public AnimatedTextRunnable getRunnable(AdvancedDisplays plugin, ADTextDisplay display) {
        AnimatedTextRunnable runnable;
        AnimatedTextRunnable animatedTextRunnable = runnable = this.runnables.containsKey(display) ? this.runnables.get(display) : new AnimatedTextRunnable(plugin, display, this.player);
        if (!this.runnables.containsKey(display)) {
            this.runnables.put(display, runnable);
        }
        return runnable;
    }

    public void stopRunnable(ADTextDisplay display) {
        if (this.runnables.containsKey(display)) {
            this.runnables.remove(display).stop();
        }
    }

    public void stopRunnables() {
        for (AnimatedTextRunnable runnable : this.runnables.values()) {
            runnable.stop();
        }
        this.runnables.clear();
    }

    public void setActionUsed(Action action) {
        this.cooldowns.put(action, System.currentTimeMillis());
    }

    public boolean isCoolingDown(Action action, int cooldown) {
        if (!this.cooldowns.containsKey(action)) {
            return false;
        }
        return System.currentTimeMillis() - this.cooldowns.get(action) < (long)cooldown * 50L;
    }
}

