/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.data;

import java.util.HashMap;
import java.util.Map;
import me.lucaaa.advanceddisplays.data.Utils;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;

public class ConfigAxisAngle4f {
    private final float a;
    private final float x;
    private final float y;
    private final float z;

    public ConfigAxisAngle4f() {
        this.a = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public ConfigAxisAngle4f(Quaternionf angle) {
        this.a = (float)Math.toDegrees(angle.angle());
        float sinHalfAngle = (float)Math.sqrt(1.0 - (double)(angle.w * angle.w));
        if (sinHalfAngle < 1.0E-6f) {
            this.x = angle.x;
            this.y = angle.y;
            this.z = angle.z;
        } else {
            this.x = angle.x / sinHalfAngle;
            this.y = angle.y / sinHalfAngle;
            this.z = angle.z / sinHalfAngle;
        }
    }

    public ConfigAxisAngle4f(Map<String, Object> map) {
        this.a = map.get("angle") instanceof Float ? ((Float)map.get("angle")).floatValue() : ((Double)map.get("angle")).floatValue();
        this.x = map.get("x") instanceof Float ? ((Float)map.get("x")).floatValue() : ((Double)map.get("x")).floatValue();
        this.y = map.get("y") instanceof Float ? ((Float)map.get("y")).floatValue() : ((Double)map.get("y")).floatValue();
        this.z = map.get("z") instanceof Float ? ((Float)map.get("z")).floatValue() : ((Double)map.get("z")).floatValue();
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("angle", Utils.round(this.a));
        map.put("x", Utils.round(this.x));
        map.put("y", Utils.round(this.y));
        map.put("z", Utils.round(this.z));
        return map;
    }

    public AxisAngle4f toAxisAngle4f() {
        return new AxisAngle4f((float)Math.toRadians(this.a), this.x, this.y, this.z);
    }
}

