/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.conditions;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.conditions.Condition;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.conditions.ADCondition;
import me.lucaaa.advanceddisplays.conditions.conditionTypes.ConditionType;
import me.lucaaa.advanceddisplays.conditions.conditionTypes.DistanceCondition;
import me.lucaaa.advanceddisplays.conditions.conditionTypes.HasPermissionCondition;
import me.lucaaa.advanceddisplays.conditions.conditionTypes.LacksPermissionCondition;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ConditionsHandler {
    private final AdvancedDisplays plugin;
    private final BaseEntity display;
    private final List<Condition> conditionsList = new ArrayList<Condition>();

    public ConditionsHandler(AdvancedDisplays plugin, BaseEntity display, ConfigurationSection conditionsSection) {
        this.plugin = plugin;
        this.display = display;
        for (String conditionTypeKey : conditionsSection.getKeys(false)) {
            this.addCondition(conditionTypeKey, conditionsSection.get(conditionTypeKey));
        }
    }

    public ConditionsHandler(AdvancedDisplays plugin, BaseEntity display) {
        this.plugin = plugin;
        this.display = display;
    }

    private void addCondition(String key, Object value) {
        ADCondition condition;
        ConditionType conditionType = ConditionType.getFromConfigName(key);
        if (conditionType == null) {
            this.plugin.log(Level.WARNING, "Invalid condition type detected for display \"" + this.display.getName() + "\": " + key);
            return;
        }
        if (!value.getClass().equals(conditionType.getType())) {
            this.plugin.log(Level.WARNING, "Your condition \"" + key + "\" is not a valid " + conditionType.getType().getSimpleName() + " for display \"" + this.display.getName() + "\"!");
            return;
        }
        switch (conditionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DISTANCE: {
                ADCondition aDCondition = new DistanceCondition((Double)value);
                break;
            }
            case HAS_PERMISSION: {
                ADCondition aDCondition = new HasPermissionCondition((String)value);
                break;
            }
            case LACKS_PERMISSION: {
                ADCondition aDCondition = condition = new LacksPermissionCondition((String)value);
            }
        }
        if (!condition.isCorrect()) {
            return;
        }
        this.conditionsList.add(condition);
    }

    public void addCondition(Condition condition) {
        this.conditionsList.add(condition);
    }

    public void clearConditions() {
        this.conditionsList.clear();
    }

    public boolean checkConditions(Player player) {
        for (Condition condition : this.conditionsList) {
            if (condition.meetsCondition(this.display, player)) continue;
            return false;
        }
        return true;
    }
}

