/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.commands.subcommands;

import java.util.List;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.commands.subcommands.SubCommandsFormat;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.displays.ADTextDisplay;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetPageSubCommand
extends SubCommandsFormat {
    public SetPageSubCommand(AdvancedDisplays plugin) {
        super(plugin);
        this.name = "setPage";
        this.description = "Switches to the given page of a text display.";
        this.usage = "/ad setPage [name] [page] <player> <silent>";
        this.minArguments = 2;
        this.executableByConsole = true;
        this.neededPermission = "ad.page";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return this.plugin.getDisplaysManager().getDisplays().values().stream().filter(display -> display.getType() == DisplayType.TEXT).map(ADBaseEntity::getName).toList();
        }
        if (args.length == 3) {
            ADBaseEntity display2 = this.plugin.getDisplaysManager().getDisplayFromMap(args[1]);
            if (!(display2 instanceof ADTextDisplay)) {
                return List.of();
            }
            ADTextDisplay textDisplay = (ADTextDisplay)display2;
            return textDisplay.getText().keySet().stream().toList();
        }
        if (args.length == 4) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toList();
        }
        return List.of("true", "false");
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        ADBaseEntity display = this.plugin.getDisplaysManager().getDisplayFromMap(args[1]);
        if (display == null) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe display &b" + args[1] + " &cdoes not exist!"));
            return;
        }
        if (!(display instanceof ADTextDisplay)) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe display &b" + args[1] + " &cis not a text display!"));
            return;
        }
        ADTextDisplay textDisplay = (ADTextDisplay)display;
        if (!textDisplay.getText().containsKey(args[2])) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe display &b" + args[1] + " &cdoes not have a page named &b" + args[2] + "&c!"));
            return;
        }
        if (args.length >= 4) {
            Player player = this.plugin.getServer().getPlayer(args[3]);
            if (player == null) {
                sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe player &b" + args[3] + " &cdoes not exist or was not found!"));
            } else {
                textDisplay.setPage(args[2], player);
            }
        } else {
            textDisplay.setPage(args[2]);
        }
        if (!Boolean.parseBoolean(args[args.length - 1])) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aThe display &e" + args[1] + " &ais now showing its next page."));
        }
    }
}

