/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.commands.subcommands;

import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.commands.subcommands.SubCommandsFormat;
import me.lucaaa.advanceddisplays.data.PlayerData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FinishSubCommand
extends SubCommandsFormat {
    public FinishSubCommand(AdvancedDisplays plugin) {
        super(plugin);
        this.name = "finish";
        this.description = "Stops what you are currently doing (creating an ATTACHED display or editing a display).";
        this.usage = "/ad finish";
        this.minArguments = 0;
        this.executableByConsole = false;
        this.neededPermission = null;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        PlayerData playerData;
        Player player = (Player)sender;
        boolean sendError = true;
        if (this.plugin.getDisplaysManager().isPlayerAttaching(player)) {
            sendError = false;
            this.plugin.getDisplaysManager().removeAttachingDisplay(player);
            player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aYou are no longer creating an ATTACHED display."));
        }
        if ((playerData = this.plugin.getPlayersManager().getPlayerData(player)).isEditing()) {
            sendError = false;
            playerData.finishEditing();
            player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aYour old inventory has been given back to you."));
        }
        if (sendError) {
            player.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cYou are not editing or creating any display!"));
        }
    }
}

