/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.commands.subcommands;

import java.util.List;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.commands.subcommands.SubCommandsFormat;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EditSubCommand
extends SubCommandsFormat {
    public EditSubCommand(AdvancedDisplays plugin) {
        super(plugin);
        this.name = "edit";
        this.description = "Opens the GUI editor for a certain display.";
        this.usage = "/ad edit [name]";
        this.minArguments = 1;
        this.executableByConsole = false;
        this.neededPermission = "ad.edit";
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        return this.plugin.getDisplaysManager().getDisplays().keySet().stream().toList();
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        ADBaseEntity display = this.plugin.getDisplaysManager().getDisplays().get(args[1]);
        if (display == null) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe display &b" + args[1] + " &cdoes not exist!"));
            return;
        }
        this.plugin.getPlayersManager().getPlayerData((Player)sender).startEditing(display, this.plugin.getInventoryManager().getDisabledItems());
        sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aYou are now editing the display &e" + display.getName() + "&a. Run &e/ad finish &ato get your old inventory back."));
    }
}

