/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.commands.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.commands.subcommands.SubCommandsFormat;
import me.lucaaa.advanceddisplays.data.AttachedDisplay;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class CreateSubCommand
extends SubCommandsFormat {
    private final List<String> blocksList = new ArrayList<String>();

    public CreateSubCommand(AdvancedDisplays plugin) {
        super(plugin);
        this.name = "create";
        this.description = "Creates a new display.";
        this.usage = "/ad create [type] [name] [value]";
        this.minArguments = 3;
        this.executableByConsole = false;
        this.neededPermission = "ad.create";
        for (Material material : Material.values()) {
            try {
                material.createBlockData();
                this.blocksList.add(material.name());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.stream(DisplayType.values()).map(Enum::name).toList());
            completions.add("ATTACHED");
            return completions;
        }
        if (args.length == 4) {
            if (args[1].equalsIgnoreCase("ITEM")) {
                return Arrays.stream(Material.values()).map(Enum::name).toList();
            }
            if (args[1].equalsIgnoreCase("BLOCK")) {
                return this.blocksList;
            }
            if (args[1].equalsIgnoreCase("ATTACHED")) {
                return Arrays.stream(AttachedDisplay.Side.values()).map(Enum::name).toList();
            }
            if (args[1].equalsIgnoreCase("ENTITY")) {
                return Arrays.stream(EntityType.values()).filter(entityType -> !DisplaysManager.FORBIDDEN_ENTITIES.contains(entityType)).map(Enum::name).toList();
            }
        }
        return List.of();
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        DisplayType type;
        Player player = (Player)sender;
        if (this.plugin.getDisplaysManager().existsDisplay(args[2])) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cA display with the name &b" + args[2] + " &calready exists!"));
            return;
        }
        if (args[1].equalsIgnoreCase("ATTACHED")) {
            AttachedDisplay.Side side;
            try {
                side = AttachedDisplay.Side.valueOf(args[3].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe side &b" + args[3] + " &cis not a valid side."));
                return;
            }
            String value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 4, args.length));
            this.plugin.getDisplaysManager().addAttachingPlayer(player, new AttachedDisplay(args[2], side, value, true));
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&6Right-click the block where you want your display to be attached or run &e/ad finish &6to cancel the action."));
            return;
        }
        try {
            type = DisplayType.valueOf(args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe type &b" + args[1] + " &cis not a valid display type."));
            return;
        }
        String value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
        if ((type == DisplayType.BLOCK || type == DisplayType.ITEM) && Material.getMaterial((String)value) == null) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&b" + value + " &cis not a valid material!"));
            return;
        }
        if (type == DisplayType.ENTITY) {
            try {
                EntityType.valueOf((String)value);
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&b" + value + " &cis not a valid material!"));
                return;
            }
            if (DisplaysManager.FORBIDDEN_ENTITIES.contains(EntityType.valueOf((String)value))) {
                sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cYou cannot create an entity display with this entity!"));
                return;
            }
        }
        if (type == DisplayType.BLOCK) {
            try {
                Objects.requireNonNull(Material.getMaterial((String)value)).createBlockData();
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe material &b" + value + " &cis not a valid block."));
                return;
            }
        }
        EntityType parsedValue = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DisplayType.BLOCK -> Objects.requireNonNull(Material.getMaterial((String)value)).createBlockData();
            case DisplayType.ENTITY -> EntityType.valueOf((String)value);
            case DisplayType.ITEM -> Material.getMaterial((String)value);
            case DisplayType.TEXT -> value.replace("\\n", "\n");
        };
        this.plugin.getDisplaysManager().createDisplay(type, player.getLocation(), args[2], parsedValue, true);
        sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aThe display &e" + args[2] + " &ahas been successfully created."));
    }
}

