/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.commands.subcommands;

import java.io.File;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.commands.subcommands.SubCommandsFormat;
import me.lucaaa.advanceddisplays.managers.ConversionManager;
import org.bukkit.command.CommandSender;

public class ConvertSubCommand
extends SubCommandsFormat {
    private boolean hasRunOnce = false;

    public ConvertSubCommand(AdvancedDisplays plugin) {
        super(plugin);
        this.name = "convert";
        this.description = "Converts old display configurations to newer versions.";
        this.usage = "/ad convert";
        this.minArguments = 0;
        this.executableByConsole = true;
        this.neededPermission = "ad.convert";
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!ConversionManager.isConversionNeeded()) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aConfiguration files seem to be up-to-date. If this is an error, please report it on GitHub."));
            return;
        }
        if (!this.hasRunOnce) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aRun the command again to confirm the conversion. It is highly recommended to create a backup of the displays folder before running the command again."));
            this.hasRunOnce = true;
            return;
        }
        this.loopFiles(new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "displays"));
        ConversionManager.setConversionNeeded(this.plugin, false);
        this.plugin.reloadConfigs();
        sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&aThe displays have been successfully converted!"));
        this.hasRunOnce = false;
    }

    private void loopFiles(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            for (File insideFileOrDir : Objects.requireNonNull(fileOrDir.listFiles())) {
                this.loopFiles(insideFileOrDir);
            }
        } else {
            ConversionManager.convert(this.plugin, fileOrDir);
        }
    }
}

