/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.commands.subcommands.ConvertSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.CreateSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.EditSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.FinishSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.HelpSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.ListSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.MoveHereSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.MoveToSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.NextPageSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.PreviousPageSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.ReloadSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.RemoveSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.ResetSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.SetPageSubCommand;
import me.lucaaa.advanceddisplays.commands.subcommands.SubCommandsFormat;
import me.lucaaa.advanceddisplays.commands.subcommands.TeleportSubCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class MainCommand
implements TabExecutor {
    private final AdvancedDisplays plugin;
    private final HashMap<String, SubCommandsFormat> subCommands = new HashMap();

    public MainCommand(AdvancedDisplays plugin) {
        this.plugin = plugin;
        this.subCommands.put("reload", new ReloadSubCommand(plugin));
        this.subCommands.put("create", new CreateSubCommand(plugin));
        this.subCommands.put("remove", new RemoveSubCommand(plugin));
        this.subCommands.put("movehere", new MoveHereSubCommand(plugin));
        this.subCommands.put("moveto", new MoveToSubCommand(plugin));
        this.subCommands.put("teleport", new TeleportSubCommand(plugin));
        this.subCommands.put("convert", new ConvertSubCommand(plugin));
        this.subCommands.put("list", new ListSubCommand(plugin));
        this.subCommands.put("edit", new EditSubCommand(plugin));
        this.subCommands.put("finish", new FinishSubCommand(plugin));
        this.subCommands.put("nextPage", new NextPageSubCommand(plugin));
        this.subCommands.put("previousPage", new PreviousPageSubCommand(plugin));
        this.subCommands.put("setPage", new SetPageSubCommand(plugin));
        this.subCommands.put("reset", new ResetSubCommand(plugin));
        this.subCommands.put("help", new HelpSubCommand(plugin, this.subCommands));
    }

    public boolean onCommand(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String label, @Nonnull String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cYou need to enter more arguments to run this command!"));
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cUse &b/ad help &cto see the list of existing commands."));
            return true;
        }
        if (!this.subCommands.containsKey(args[0])) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cThe command " + args[0] + " &cdoes not exist!"));
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cUse &b/ad help &cto see the list of existing commands."));
            return true;
        }
        SubCommandsFormat subCommand = this.subCommands.get(args[0]);
        if (subCommand.neededPermission != null && !sender.hasPermission(subCommand.neededPermission)) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cYou don't have permission to execute this command!"));
            return true;
        }
        if (!(sender instanceof Player) && !subCommand.executableByConsole) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cOnly players can execute this command!"));
            return true;
        }
        if (args.length - 1 < subCommand.minArguments) {
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&cYou need to enter more arguments to run this command!"));
            sender.sendMessage(this.plugin.getMessagesManager().getColoredMessage("&7Correct usage: &c" + subCommand.usage));
            return true;
        }
        subCommand.run(sender, args);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@Nonnull CommandSender sender, @Nonnull Command command, @Nonnull String alias, @Nonnull String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Map.Entry<String, SubCommandsFormat> entry : this.subCommands.entrySet()) {
                if (entry.getValue().neededPermission != null && !sender.hasPermission(entry.getValue().neededPermission)) continue;
                completions.add(entry.getKey());
            }
        }
        SubCommandsFormat subcommand = this.subCommands.get(args[0]);
        if (args.length >= 2 && subcommand != null && sender.hasPermission(subcommand.neededPermission)) {
            completions = this.subCommands.get(args[0]).getTabCompletions(sender, args);
        }
        return completions.stream().filter(completion -> completion.toLowerCase().contains(args[args.length - 1].toLowerCase())).toList();
    }
}

