/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.api.util;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import shaded.net.kyori.adventure.text.Component;
import shaded.net.kyori.adventure.text.TextComponent;
import shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import shaded.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import shaded.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ComponentSerializer {
    @ApiStatus.Internal
    private static final MiniMessage mm = MiniMessage.miniMessage();
    @ApiStatus.Internal
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().character('&').build();
    @ApiStatus.Internal
    private static final LegacyComponentSerializer legacySectionSerializer = LegacyComponentSerializer.legacySection();
    @ApiStatus.Internal
    private static final GsonComponentSerializer gsonSerializer = GsonComponentSerializer.gson();

    private ComponentSerializer() {
    }

    public static Component deserialize(String text) {
        text = text.replace("\\n", "\n").replace('\u00a7', '&');
        TextComponent legacy = legacySerializer.deserialize(text);
        String minimessage = ((String)mm.serialize(legacy)).replace("\\", "");
        return mm.deserialize(minimessage);
    }

    public static Component deserialize(List<String> text) {
        return ComponentSerializer.deserialize(String.join((CharSequence)"\n", text));
    }

    @Deprecated
    public static List<String> serialize(Component component) {
        return Arrays.stream(((String)mm.serialize(component)).split(Pattern.quote("\n"))).toList();
    }

    public static String getLegacyString(Component component) {
        return legacySectionSerializer.serialize(component);
    }

    public static String toJSONString(Component component) {
        return (String)gsonSerializer.serialize(component);
    }

    public static JsonElement toJSON(Component component) {
        return gsonSerializer.serializeToTree(component);
    }
}

