/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.api.displays.enums;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Art;
import org.bukkit.entity.Painting;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
@Beta
public class Property<T> {
    private final String name;
    private final T def;
    private final Class<T> type;
    private final BytePack bytePack;
    private final Class<?> ownerEntity;
    private static final Map<String, Property<?>> REGISTRY = new ConcurrentHashMap();
    public static final Property<Art> PAINTING_ART = new Property<Art>("painting", Art.KEBAB, Painting.class);

    private Property(String name, T def, Class<?> ownerEntity) {
        this(name, def, null, ownerEntity);
    }

    private Property(String name, T def, BytePack bytePack, Class<?> ownerEntity) {
        this.name = name;
        this.def = def;
        this.type = def.getClass();
        this.bytePack = bytePack;
        this.ownerEntity = ownerEntity;
        REGISTRY.put(name, this);
    }

    public String name() {
        return this.name;
    }

    public Class<T> type() {
        return this.type;
    }

    @ApiStatus.Internal
    public byte getByteFlags(Map<Property<?>, Object> properties) {
        if (this.bytePack == null) {
            return 0;
        }
        byte options = 0;
        return options;
    }

    @ApiStatus.Internal
    public boolean hasBytePack() {
        return this.bytePack != null;
    }

    public Class<?> ownerEntity() {
        return this.ownerEntity;
    }

    public T getDefaultValue() {
        return this.def;
    }

    public static Collection<Property<?>> getProperties() {
        return REGISTRY.values();
    }

    @ApiStatus.Internal
    static enum BytePack {
        TAMEABLE_FLAGS;

    }
}

