/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.api.displays;

import java.util.List;
import javax.annotation.Nullable;
import me.lucaaa.advanceddisplays.api.actions.DisplayActions;
import me.lucaaa.advanceddisplays.api.conditions.Condition;
import me.lucaaa.advanceddisplays.api.displays.enums.DisplayType;
import me.lucaaa.advanceddisplays.api.displays.enums.EditorItem;
import me.lucaaa.advanceddisplays.api.displays.enums.NameVisibility;
import me.lucaaa.advanceddisplays.api.displays.visibility.VisibilityManager;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import shaded.net.kyori.adventure.text.Component;
import shaded.net.kyori.adventure.text.minimessage.MiniMessage;

public interface BaseEntity {
    @ApiStatus.Internal
    public static final MiniMessage minimessage = MiniMessage.miniMessage();

    public String getName();

    public DisplayType getType();

    public VisibilityManager getVisibilityManager();

    public void openEditor(Player var1);

    public void openEditor(Player var1, List<EditorItem> var2);

    public void closeEditor(Player var1);

    default public void addViewCondition(Condition condition) {
        this.getVisibilityManager().addViewCondition(condition);
    }

    default public void clearConditions() {
        this.getVisibilityManager().clearConditions();
    }

    public void setClickActions(DisplayActions var1);

    public void remove();

    public boolean isRemoved();

    public Location getLocation();

    public void setLocation(Location var1);

    public Location center();

    public float getYaw();

    public float getPitch();

    public void setRotation(float var1, float var2);

    public boolean isOnFire();

    public void setOnFire(boolean var1);

    public void setOnFire(boolean var1, Player var2);

    public boolean isSprinting();

    public void setSprinting(boolean var1);

    public void setSprinting(boolean var1, Player var2);

    public boolean isGlowing();

    public void setGlowing(boolean var1);

    public void setGlowing(boolean var1, Player var2);

    public ChatColor getGlowColor();

    public void setGlowColor(ChatColor var1);

    public void setGlowColor(ChatColor var1, Player var2);

    @Nullable
    public String getCustomName();

    default public void setCustomName(@Nullable String customName) {
        this.setCustomName(customName, this.getCustomNameVisibility());
    }

    default public void setCustomName(@Nullable String customName, Player player) {
        this.setCustomName(customName, this.getCustomNameVisibility(), player);
    }

    default public void setCustomName(Component customName) {
        this.setCustomName((String)minimessage.serialize(customName));
    }

    default public void setCustomName(Component customName, Player player) {
        this.setCustomName((String)minimessage.serialize(customName), player);
    }

    public void setCustomName(String var1, NameVisibility var2);

    default public void setCustomName(Component customName, NameVisibility visibility) {
        this.setCustomName((String)minimessage.serialize(customName), visibility);
    }

    public void setCustomName(String var1, NameVisibility var2, Player var3);

    default public void setCustomName(Component customName, NameVisibility visibility, Player player) {
        this.setCustomName((String)minimessage.serialize(customName), visibility, player);
    }

    public NameVisibility getCustomNameVisibility();

    default public void setCustomNameVisibility(NameVisibility visibility) {
        this.setCustomName(this.getCustomName(), visibility);
    }

    default public void setCustomNameVisibility(NameVisibility visibility, Player player) {
        this.setCustomName(this.getCustomName(), visibility, player);
    }
}

