/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.actions.actionTypes;

import java.util.List;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.Action;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionType;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.api.util.ComponentSerializer;
import me.lucaaa.advanceddisplays.data.Utils;
import org.bukkit.Material;
import org.bukkit.advancement.AdvancementDisplayType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import shaded.net.kyori.adventure.text.Component;

public class ToastAction
extends Action {
    private final ItemStack item;
    private final String title;
    private final String description;
    private final AdvancementDisplayType frame;
    private final boolean animate;

    public ToastAction(AdvancedDisplays plugin, ConfigurationSection actionSection, BaseEntity display) {
        super(plugin, ActionType.TOAST, actionSection, List.of(new Action.Field("item", ConfigurationSection.class), new Action.Field("title", String.class), new Action.Field("description", String.class), new Action.Field("frame", String.class)));
        ItemMeta meta;
        AdvancementDisplayType frame;
        ConfigurationSection itemSection = actionSection.getConfigurationSection("item");
        if (itemSection == null) {
            this.item = new ItemStack(Material.BARRIER);
        } else {
            Material material;
            try {
                material = Material.valueOf((String)itemSection.getString("material"));
            }
            catch (IllegalArgumentException exception) {
                material = Material.BARRIER;
                this.errors.add("Invalid material: " + actionSection.getString("material"));
            }
            this.item = Utils.loadItemData(new ItemStack(material), itemSection, display.getLocation().getWorld(), plugin);
        }
        this.title = actionSection.getString("title", "No message set");
        this.description = actionSection.getString("description", "No message set");
        try {
            frame = AdvancementDisplayType.valueOf((String)actionSection.getString("frame"));
        }
        catch (IllegalArgumentException exception) {
            frame = AdvancementDisplayType.TASK;
            this.errors.add("Invalid frame: " + actionSection.getString("frame"));
        }
        this.frame = frame;
        this.animate = actionSection.getBoolean("animate", true);
        int customModelData = actionSection.getInt("customModelData", 0);
        if (customModelData > 0 && (meta = this.item.getItemMeta()) != null) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
            this.item.setItemMeta(meta);
        }
    }

    @Override
    public void runAction(Player clickedPlayer, Player actionPlayer, BaseEntity display) {
        Component title = this.getText(this.title, clickedPlayer, actionPlayer);
        Component description = this.getText(this.description, clickedPlayer, actionPlayer);
        if (this.animate) {
            title = Utils.combine(title, description);
        }
        this.plugin.getPacketsManager().getPackets().sendToast(task -> this.plugin.getTasksManager().runTaskLater((Plugin)this.plugin, (Runnable)task, 1L), actionPlayer, this.item, ComponentSerializer.toJSONString(title), ComponentSerializer.toJSONString(description), this.frame);
    }
}

