/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.actions.actionTypes;

import java.util.List;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.Action;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionType;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.data.Utils;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class SoundAction
extends Action {
    private final String sound;
    private final String[] unparsedLoc;
    private final float volume;
    private final float pitch;

    public SoundAction(AdvancedDisplays plugin, ConfigurationSection section) {
        super(plugin, ActionType.PLAY_SOUND, section, List.of(new Action.Field("sound", String.class), new Action.Field("volume", Double.class), new Action.Field("pitch", Double.class)));
        this.sound = section.getString("sound", "");
        String unparsedLocString = section.getString("location", "*;*;*");
        this.unparsedLoc = unparsedLocString.split(";");
        this.errors.addAll(Utils.isStringValidLoc(unparsedLocString));
        this.volume = (float)section.getDouble("volume");
        this.pitch = (float)section.getDouble("pitch");
    }

    @Override
    public void runAction(Player clickedPlayer, Player actionPlayer, BaseEntity display) {
        try {
            Location loc = display.getLocation();
            double x = Utils.parsePosition(this.unparsedLoc[0], Utils.CoordComponent.X, loc, (CommandSender)actionPlayer);
            double y = Utils.parsePosition(this.unparsedLoc[1], Utils.CoordComponent.Y, loc, (CommandSender)actionPlayer);
            double z = Utils.parsePosition(this.unparsedLoc[2], Utils.CoordComponent.Z, loc, (CommandSender)actionPlayer);
            Location location = new Location(actionPlayer.getWorld(), x, y, z);
            try {
                Sound soundEnum = Sound.valueOf((String)this.sound);
                actionPlayer.playSound(location, soundEnum, this.volume, this.pitch);
            }
            catch (IllegalArgumentException e) {
                actionPlayer.playSound(location, this.sound, this.volume, this.pitch);
            }
        }
        catch (NumberFormatException e) {
            this.plugin.log(Level.WARNING, "One of the coordinates is not a valid number or relative position! For decimals use dots (\".\"), NOT commas (\",\").");
        }
    }
}

