/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.actions.actionTypes;

import java.util.List;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.Action;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionType;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.data.Utils;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ParticleAction
extends Action {
    private final Particle particle;
    private final String[] unparsedLoc;
    private final int count;
    private String[] unparsedOffset = new String[0];
    private final double speed;

    public ParticleAction(AdvancedDisplays plugin, ConfigurationSection section) {
        super(plugin, ActionType.PARTICLE, section, List.of(new Action.Field("particle", String.class), new Action.Field("location", String.class), new Action.Field("count", Integer.class)));
        Particle particle1;
        String configParticle = section.getString("particle", "");
        try {
            particle1 = Particle.valueOf((String)configParticle.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            particle1 = null;
            this.errors.add("Invalid particle type: " + configParticle);
        }
        this.particle = particle1;
        String unparsedLocString = section.getString("location", "");
        this.unparsedLoc = unparsedLocString.split(";");
        this.errors.addAll(Utils.isStringValidLoc(unparsedLocString));
        this.count = section.getInt("count");
        if (section.isString("offset")) {
            String unparsedOffsetString = section.getString("offset", "");
            this.unparsedOffset = unparsedOffsetString.split(";");
            this.errors.addAll(Utils.isStringValidLoc(unparsedOffsetString));
        }
        if (this.particle.getDataType() != Void.class) {
            this.errors.add("Unsupported particle - contact developer.");
        }
        this.speed = section.getDouble("speed", 0.0);
    }

    @Override
    public void runAction(Player clickedPlayer, Player actionPlayer, BaseEntity display) {
        try {
            Location loc = display.getLocation();
            double x = Utils.parsePosition(this.unparsedLoc[0], Utils.CoordComponent.X, loc, (CommandSender)actionPlayer);
            double y = Utils.parsePosition(this.unparsedLoc[1], Utils.CoordComponent.Y, loc, (CommandSender)actionPlayer);
            double z = Utils.parsePosition(this.unparsedLoc[2], Utils.CoordComponent.Z, loc, (CommandSender)actionPlayer);
            Location location = new Location(actionPlayer.getWorld(), x, y, z);
            if (this.unparsedOffset.length != 0) {
                double offsetX = Double.parseDouble(this.unparsedOffset[0]);
                double offsetY = Double.parseDouble(this.unparsedOffset[1]);
                double offsetZ = Double.parseDouble(this.unparsedOffset[2]);
                actionPlayer.spawnParticle(this.particle, location, this.count, offsetX, offsetY, offsetZ, this.speed);
            } else {
                actionPlayer.spawnParticle(this.particle, location, this.count);
            }
        }
        catch (NumberFormatException e) {
            this.plugin.log(Level.WARNING, "One of the coordinates is not a valid number or relative position! For decimals use dots (\".\"), NOT commas (\",\").");
        }
    }
}

