/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.actions.actionTypes;

import java.util.List;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.Action;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionType;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EffectAction
extends Action {
    private final PotionEffect effect;

    public EffectAction(AdvancedDisplays plugin, ConfigurationSection actionSection) {
        super(plugin, ActionType.EFFECT, actionSection, List.of(new Action.Field("effect", String.class), new Action.Field("duration", Integer.class), new Action.Field("amplifier", Integer.class)));
        PotionEffectType type = PotionEffectType.getByName((String)Objects.requireNonNull(actionSection.getString("effect")));
        if (type == null) {
            this.errors.add("Invalid effect: " + actionSection.getString("effect"));
            this.effect = null;
            return;
        }
        int duration = actionSection.getInt("duration");
        int amplifier = actionSection.getInt("amplifier");
        boolean ambient = actionSection.getBoolean("ambient", true);
        boolean particles = actionSection.getBoolean("particles", true);
        boolean icon = actionSection.getBoolean("icon", true);
        this.effect = new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }

    @Override
    public void runAction(Player clickedPlayer, Player actionPlayer, BaseEntity display) {
        actionPlayer.addPotionEffect(this.effect);
    }
}

