/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.actions;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.Action;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionType;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionbarAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.ConsoleCommandAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.EffectAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.MessageAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.ParticleAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.PlayerCommandAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.SoundAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.TitleAction;
import me.lucaaa.advanceddisplays.actions.actionTypes.ToastAction;
import me.lucaaa.advanceddisplays.api.actions.DisplayActions;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.conditions.ConditionsHandler;
import me.lucaaa.advanceddisplays.data.Utils;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class ActionsHandler {
    private final AdvancedDisplays plugin;
    private final BaseEntity display;
    private final ConditionsHandler conditionsHandler;
    private final String conditionsNotMetMessage;
    private final Map<ClickType, List<Action>> actionsMap = new EnumMap<ClickType, List<Action>>(ClickType.class);
    private DisplayActions clickActions = null;

    public ActionsHandler(AdvancedDisplays plugin, BaseEntity display, ConfigManager configManager) {
        this.plugin = plugin;
        this.display = display;
        if (configManager == null) {
            this.conditionsHandler = new ConditionsHandler(plugin, display);
            this.conditionsNotMetMessage = null;
            return;
        }
        ConfigurationSection actionsSection = configManager.getSection("actions", false, (ConfigurationSection)configManager.getConfig());
        if (actionsSection == null) {
            this.conditionsHandler = new ConditionsHandler(plugin, display);
            this.conditionsNotMetMessage = null;
            return;
        }
        ConfigurationSection conditionsSection = configManager.getSection("conditions", false, actionsSection);
        this.conditionsHandler = conditionsSection == null ? null : new ConditionsHandler(plugin, display, conditionsSection);
        this.conditionsNotMetMessage = actionsSection.getString("conditions-not-met", null);
        List<ClickType> validClickTypes = List.of(ClickType.LEFT, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        for (String clickTypeKey : actionsSection.getKeys(false)) {
            if (!actionsSection.isConfigurationSection(clickTypeKey) || clickTypeKey.equalsIgnoreCase("conditions")) continue;
            ConfigurationSection actionSection = Objects.requireNonNull(actionsSection.getConfigurationSection(clickTypeKey));
            List<Action> validActions = this.getActions(actionSection);
            if (clickTypeKey.equalsIgnoreCase("ANY")) {
                for (ClickType clickType : validClickTypes) {
                    this.addActions(clickType, validActions);
                }
                continue;
            }
            if (clickTypeKey.contains(";")) {
                String[] clickTypes;
                for (String clickType : clickTypes = clickTypeKey.split(";")) {
                    try {
                        this.addActions(ClickType.valueOf((String)clickType), validActions);
                    }
                    catch (IllegalArgumentException e) {
                        plugin.log(Level.WARNING, "Invalid click type found for display \"" + display.getName() + "\": " + clickType);
                    }
                }
                continue;
            }
            try {
                this.addActions(ClickType.valueOf((String)clickTypeKey), validActions);
            }
            catch (IllegalArgumentException e) {
                plugin.log(Level.WARNING, "Invalid click type found for display \"" + display.getName() + "\": " + clickTypeKey);
            }
        }
    }

    private void addActions(ClickType clickType, List<Action> actions) {
        this.actionsMap.computeIfAbsent(clickType, k -> new ArrayList());
        this.actionsMap.get(clickType).addAll(actions);
    }

    private List<Action> getActions(ConfigurationSection actionsSection) {
        ArrayList<Action> validActions = new ArrayList<Action>();
        for (Map.Entry actions : actionsSection.getValues(false).entrySet()) {
            ConfigurationSection actionSection = (ConfigurationSection)actions.getValue();
            Action action = this.createAction((String)actions.getKey(), actionSection);
            if (action == null) continue;
            validActions.add(action);
        }
        return validActions;
    }

    private Action createAction(String name, ConfigurationSection actionSection) {
        Action action;
        String typeName = actionSection.getString("type");
        if (typeName == null) {
            this.plugin.log(Level.WARNING, "Action \"" + name + "\" for display " + this.display.getName() + " does not have a type set!");
            return null;
        }
        ActionType actionType = ActionType.getFromConfigName(actionSection.getString("type"));
        if (actionType == null) {
            this.plugin.log(Level.WARNING, "Action \"" + name + "\" for display " + this.display.getName() + " does not have a type set: " + typeName);
            return null;
        }
        switch (actionType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MESSAGE: {
                Action action2 = new MessageAction(this.plugin, actionSection);
                break;
            }
            case CONSOLE_COMMAND: {
                Action action2 = new ConsoleCommandAction(this.plugin, actionSection);
                break;
            }
            case PLAYER_COMMAND: {
                Action action2 = new PlayerCommandAction(this.plugin, actionSection);
                break;
            }
            case TITLE: {
                Action action2 = new TitleAction(this.plugin, actionSection);
                break;
            }
            case ACTIONBAR: {
                Action action2 = new ActionbarAction(this.plugin, actionSection);
                break;
            }
            case PLAY_SOUND: {
                Action action2 = new SoundAction(this.plugin, actionSection);
                break;
            }
            case EFFECT: {
                Action action2 = new EffectAction(this.plugin, actionSection);
                break;
            }
            case TOAST: {
                Action action2 = new ToastAction(this.plugin, actionSection, this.display);
                break;
            }
            case PARTICLE: {
                Action action2 = action = new ParticleAction(this.plugin, actionSection);
            }
        }
        if (action.hasErrors()) {
            this.plugin.log(Level.WARNING, "=== Found errors for action \"" + name + "\" ===");
            for (String error : action.getErrors()) {
                this.plugin.log(Level.WARNING, " - " + error);
            }
            return null;
        }
        return action;
    }

    public void runActions(Player player, ClickType clickType, ADBaseEntity display) {
        boolean meetsConditions;
        if (this.clickActions != null) {
            this.clickActions.onClick(player, clickType, display);
            return;
        }
        if (display.isApi()) {
            return;
        }
        boolean bl = meetsConditions = this.conditionsHandler == null || this.conditionsHandler.checkConditions(player);
        if (!meetsConditions) {
            if (this.conditionsNotMetMessage != null && !this.conditionsNotMetMessage.isBlank()) {
                this.plugin.getAudience(player).sendMessage(Utils.getText(this.conditionsNotMetMessage, player, null, false));
            }
            return;
        }
        List<Action> actionsToRun = this.actionsMap.get(clickType);
        if (actionsToRun == null) {
            return;
        }
        for (Action action : actionsToRun) {
            if (action.getDelay() > 0) {
                this.plugin.getTasksManager().runTaskLater((Plugin)this.plugin, () -> this.executeAction(action, player), action.getDelay());
                continue;
            }
            this.executeAction(action, player);
        }
    }

    public void executeAction(Action action, Player clickedPlayer) {
        if (action.isGlobal()) {
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                action.run(clickedPlayer, onlinePlayer, this.display);
            }
        } else {
            action.run(clickedPlayer, clickedPlayer, this.display);
        }
    }

    public void setClickActions(DisplayActions clickActions) {
        this.clickActions = clickActions;
    }
}

