/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.lucaaa.advanceddisplays.AdvancedDisplays;
import me.lucaaa.advanceddisplays.actions.actionTypes.ActionType;
import me.lucaaa.advanceddisplays.api.displays.BaseEntity;
import me.lucaaa.advanceddisplays.data.Utils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import shaded.net.kyori.adventure.text.Component;

public abstract class Action {
    protected final AdvancedDisplays plugin;
    protected final List<String> errors = new ArrayList<String>();
    private final ActionType type;
    private final boolean isGlobal;
    private final boolean globalPlaceholders;
    private final int delay;
    private final int cooldown;
    private final String cooldownMessage;

    public Action(AdvancedDisplays plugin, ActionType type, ConfigurationSection section, List<Field> requiredFields) {
        this.plugin = plugin;
        this.type = type;
        this.isGlobal = section.getBoolean("global", false);
        this.globalPlaceholders = section.getBoolean("global-placeholders", true);
        this.delay = section.getInt("delay", 0);
        this.cooldown = section.getInt("cooldown", 0);
        this.cooldownMessage = section.getString("cooldown-message", null);
        for (Field field : requiredFields) {
            if (!section.contains(field.name)) {
                this.errors.add("Missing field \"" + field.name + "\" of type " + field.getTypesParsed());
                break;
            }
            Object value = Objects.requireNonNull(section.get(field.name));
            if (field.isAssignable(value.getClass())) continue;
            this.errors.add("Invalid field type for field \"" + field.name + "\". It must be: " + field.getTypesParsed());
            break;
        }
    }

    public ActionType getType() {
        return this.type;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void run(Player clickedPlayer, Player actionPlayer, BaseEntity display) {
        if (this.plugin.getPlayersManager().getPlayerData(clickedPlayer).isCoolingDown(this, this.cooldown)) {
            if (this.cooldownMessage != null && !this.cooldownMessage.isBlank()) {
                this.plugin.getAudience(clickedPlayer).sendMessage(Utils.getText(this.cooldownMessage, clickedPlayer, null, false));
            }
            return;
        }
        this.runAction(clickedPlayer, actionPlayer, display);
        if (this.cooldown > 0) {
            this.plugin.getPlayersManager().getPlayerData(clickedPlayer).setActionUsed(this);
        }
    }

    public abstract void runAction(Player var1, Player var2, BaseEntity var3);

    public int getDelay() {
        return this.delay;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean useGlobalPlaceholders() {
        return this.globalPlaceholders;
    }

    public String getTextString(String message, Player clickedPlayer, Player actionPlayer) {
        return Utils.getTextString(message, clickedPlayer, actionPlayer, this.useGlobalPlaceholders());
    }

    public Component getText(String message, Player clickedPlayer, Player actionPlayer) {
        return Utils.getText(message, clickedPlayer, actionPlayer, this.useGlobalPlaceholders());
    }

    public record Field(String name, Class<?>[] types) {
        public String getTypesParsed() {
            return String.join((CharSequence)" OR ", Arrays.stream(this.types).map(Class::getSimpleName).toList());
        }

        public boolean isAssignable(Class<?> clazz) {
            for (Class<?> fieldType : this.types) {
                if (!fieldType.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }
}

