/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.api.ADAPIProvider;
import me.lucaaa.advanceddisplays.api.ADAPIProviderImplementation;
import me.lucaaa.advanceddisplays.commands.MainCommand;
import me.lucaaa.advanceddisplays.common.TasksManager;
import me.lucaaa.advanceddisplays.data.Compatibility;
import me.lucaaa.advanceddisplays.displays.ADBaseEntity;
import me.lucaaa.advanceddisplays.events.InventoryEventsListener;
import me.lucaaa.advanceddisplays.events.PlayerEventsListener;
import me.lucaaa.advanceddisplays.integrations.Integration;
import me.lucaaa.advanceddisplays.integrations.ItemsAdderCompat;
import me.lucaaa.advanceddisplays.integrations.OraxenCompat;
import me.lucaaa.advanceddisplays.managers.ConfigManager;
import me.lucaaa.advanceddisplays.managers.DisplaysManager;
import me.lucaaa.advanceddisplays.managers.HeadCacheManager;
import me.lucaaa.advanceddisplays.managers.InteractionsManager;
import me.lucaaa.advanceddisplays.managers.InventoryManager;
import me.lucaaa.advanceddisplays.managers.MessagesManager;
import me.lucaaa.advanceddisplays.managers.PlayersManager;
import me.lucaaa.advanceddisplays.managers.TickManager;
import me.lucaaa.advanceddisplays.managers.UpdateManager;
import me.lucaaa.advanceddisplays.managers.VersionManager;
import me.lucaaa.advanceddisplays.nms_common.Logger;
import me.lucaaa.advanceddisplays.nms_common.Metadata;
import me.lucaaa.advanceddisplays.nms_common.Version;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import shaded.net.kyori.adventure.audience.Audience;
import shaded.net.kyori.adventure.platform.bukkit.BukkitAudiences;

public class AdvancedDisplays
extends JavaPlugin
implements Logger {
    private ConfigManager mainConfig;
    private ConfigManager savesConfig;
    private Version nmsVersion;
    private boolean isRunning = false;
    public Metadata metadata;
    private BukkitAudiences audiences;
    private final Map<Compatibility, Integration> integrations = new HashMap<Compatibility, Integration>();
    private VersionManager versionManager;
    private TickManager tickManager;
    private HeadCacheManager headCacheManager;
    private InteractionsManager interactionsManager;
    private DisplaysManager displaysManager;
    private MessagesManager messagesManager;
    private PlayersManager playersManager;
    private InventoryManager inventoryManager;
    private final ADAPIProviderImplementation apiDisplays = new ADAPIProviderImplementation(this);

    public void reloadConfigs() {
        this.mainConfig = new ConfigManager(this, "config.yml", true);
        this.savesConfig = new ConfigManager(this, "saved-inventories.yml", true);
        HashMap<Integer, ADBaseEntity> savedApiDisplays = new HashMap();
        if (this.isRunning) {
            this.headCacheManager.shutdown();
            this.displaysManager.removeAll(true);
            savedApiDisplays = this.interactionsManager.getApiDisplays();
            this.versionManager.getPacketsManager().removeAll();
            this.playersManager.removeAll();
            this.inventoryManager.clearAll();
            this.tickManager.stop();
        }
        this.versionManager = new VersionManager(this);
        this.tickManager = new TickManager(this);
        this.headCacheManager = new HeadCacheManager(this);
        this.interactionsManager = new InteractionsManager(savedApiDisplays);
        this.displaysManager = new DisplaysManager(this, this.getName(), true, false);
        this.messagesManager = new MessagesManager(this, this.mainConfig);
        this.playersManager = new PlayersManager(this);
        this.inventoryManager = new InventoryManager(this, this.mainConfig);
    }

    public void onEnable() {
        String version = this.getServer().getBukkitVersion().split("-")[0];
        this.nmsVersion = Version.getNMSVersion(version);
        if (this.nmsVersion == Version.UNKNOWN) {
            this.log(Level.SEVERE, "----------[AdvancedDisplays initialization error]----------");
            this.log(Level.SEVERE, "Unknown NMS version! Server version: " + version);
            this.log(Level.SEVERE, "The plugin may not be updated to support the server's version.");
            this.log(Level.SEVERE, "Check dev builds latest versions support: https://github.com/Luncaaa/AdvancedDisplays/releases/tag/dev");
            this.log(Level.SEVERE, "If you're using a version lower than 1.19.4, upgrade to 1.19.4 or higher to use this plugin.");
            this.log(Level.SEVERE, "The plugin will be disabled...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.metadata = new Metadata(this.nmsVersion);
        this.audiences = BukkitAudiences.create((Plugin)this);
        ADAPIProvider.setImplementation(this.apiDisplays);
        if (this.getServer().getPluginManager().isPluginEnabled("Oraxen")) {
            this.integrations.put(Compatibility.ORAXEN, new OraxenCompat(this));
        }
        if (this.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
            this.integrations.put(Compatibility.ITEMS_ADDER, new ItemsAdderCompat(this));
        }
        this.reloadConfigs();
        if (this.mainConfig.getConfig().getBoolean("updateChecker", true)) {
            new UpdateManager(this).getVersion(v -> UpdateManager.sendStatus(this, v, this.getDescription().getVersion()));
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryEventsListener(this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("ad")).setExecutor((CommandExecutor)new MainCommand(this));
        this.isRunning = true;
        this.getServer().getConsoleSender().sendMessage(this.messagesManager.getColoredMessage("&aThe plugin has been successfully enabled! &7Version: " + this.getDescription().getVersion()));
    }

    public void onDisable() {
        if (this.inventoryManager != null) {
            this.inventoryManager.clearAll();
        }
        if (this.playersManager != null) {
            this.playersManager.removeAll();
        }
        if (this.headCacheManager != null) {
            this.headCacheManager.shutdown();
        }
        if (this.tickManager != null) {
            this.tickManager.stop();
        }
        if (this.audiences != null) {
            this.audiences.close();
        }
    }

    public ConfigManager getMainConfig() {
        return this.mainConfig;
    }

    public ConfigManager getSavesConfig() {
        return this.savesConfig;
    }

    public Version getNmsVersion() {
        return this.nmsVersion;
    }

    public Audience getAudience(Player player) {
        return this.audiences.player(player);
    }

    public boolean isIntegrationLoaded(Compatibility compatibility) {
        return this.integrations.containsKey((Object)compatibility);
    }

    public Integration getIntegration(Compatibility compatibility) {
        return this.integrations.get((Object)compatibility);
    }

    public VersionManager.PacketsManager getPacketsManager() {
        return this.versionManager.getPacketsManager();
    }

    public TasksManager getTasksManager() {
        return this.versionManager.getTasksManager();
    }

    public TickManager getTickManager() {
        return this.tickManager;
    }

    public HeadCacheManager getHeadCacheManager() {
        return this.headCacheManager;
    }

    public InteractionsManager getInteractionsManager() {
        return this.interactionsManager;
    }

    public ADAPIProviderImplementation getApiDisplays() {
        return this.apiDisplays;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public PlayersManager getPlayersManager() {
        return this.playersManager;
    }

    public DisplaysManager getDisplaysManager() {
        return this.displaysManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @Override
    public void log(Level level, String message) {
        this.getLogger().log(level, message);
    }

    @Override
    public void logError(Level level, String message, Throwable error) {
        this.getLogger().log(level, message, error);
    }
}

