/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.utils;

import java.util.concurrent.TimeUnit;
import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.api.events.AsyncHomeTeleportEvent;
import me.loving11ish.epichomes.libs.folialib.FoliaLib;
import me.loving11ish.epichomes.libs.folialib.wrapper.task.WrappedTask;
import me.loving11ish.epichomes.models.User;
import me.loving11ish.epichomes.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TeleportationUtils {
    private final FoliaLib foliaLib = EpicHomes.getFoliaLib();
    private WrappedTask wrappedTask;
    private static final String HOME_NAME_PLACEHOLDER = "%HOME%";

    public void teleportPlayerAsync(Player player, Location location, String homeName) {
        User user = EpicHomes.getPlugin().getUsermapStorageUtil().getUserByOnlinePlayer(player);
        this.foliaLib.getScheduler().teleportAsync((Entity)player, location);
        this.foliaLib.getScheduler().runAsync(task -> {
            this.fireAsyncHomeTeleportEvent(player, user, homeName, location);
            MessageUtils.sendDebugConsole("&aFired AsyncHomeTeleportEvent in async mode");
        });
        MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getNonTimedCompleteTP().replace(HOME_NAME_PLACEHOLDER, homeName));
    }

    public void teleportPlayerAsyncTimed(final Player player, final Location location, final String homeName) {
        final User user = EpicHomes.getPlugin().getUsermapStorageUtil().getUserByOnlinePlayer(player);
        MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getTimedBeginTP().replace(HOME_NAME_PLACEHOLDER, homeName));
        this.wrappedTask = this.foliaLib.getScheduler().runTimerAsync(new Runnable(){
            int time = EpicHomes.getPlugin().getConfigManager().getTeleportDelayTime();

            @Override
            public void run() {
                if (!EpicHomes.getPlugin().getTeleportationManager().getTeleportQueue().containsKey(player.getUniqueId())) {
                    EpicHomes.getPlugin().getTeleportationManager().getTeleportQueue().put(player.getUniqueId(), TeleportationUtils.this.getWrappedTask());
                    MessageUtils.sendDebugConsole("&aPlayer " + player.getName() + " has been added to teleport queue");
                }
                if (this.time == 0) {
                    EpicHomes.getPlugin().getTeleportationManager().getTeleportQueue().remove(player.getUniqueId());
                    MessageUtils.sendDebugConsole("&aPlayer " + player.getName() + " has been removed from the teleport queue");
                    TeleportationUtils.this.foliaLib.getScheduler().teleportAsync((Entity)player, location);
                    MessageUtils.sendPlayer(player, EpicHomes.getPlugin().getMessagesManager().getTimedCompleteTP().replace(TeleportationUtils.HOME_NAME_PLACEHOLDER, homeName));
                    TeleportationUtils.this.foliaLib.getScheduler().runAsync(task -> {
                        TeleportationUtils.this.fireAsyncHomeTeleportEvent(player, user, homeName, location);
                        MessageUtils.sendDebugConsole("&aFired AsyncHomeTeleportEvent in async mode");
                    });
                    TeleportationUtils.this.getWrappedTask().cancel();
                    MessageUtils.sendDebugConsole("&aTeleportPlayerAsyncTimed complete task entity: " + player.getName());
                    MessageUtils.sendDebugConsole("&aTeleportPlayerAsyncTimed complete task home location: " + location.toString());
                    MessageUtils.sendDebugConsole("&aComplete wrapped task ID: " + TeleportationUtils.this.getWrappedTask().toString());
                    MessageUtils.sendDebugConsole("&aCompleted TeleportPlayerAsyncTimed task canceled");
                    return;
                }
                --this.time;
                MessageUtils.sendDebugConsole("&aTeleportPlayerAsyncTimed task running");
                MessageUtils.sendDebugConsole("&aTeleportPlayerAsyncTimed task entity: " + player.getName());
                MessageUtils.sendDebugConsole("&aTeleportPlayerAsyncTimed task time left: " + this.time);
                MessageUtils.sendDebugConsole("&aTeleportPlayerAsyncTimed task home location: " + location.toString());
                MessageUtils.sendDebugConsole("&aWrapped task ID: " + TeleportationUtils.this.getWrappedTask().toString());
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public WrappedTask getWrappedTask() {
        return this.wrappedTask;
    }

    private void fireAsyncHomeTeleportEvent(Player player, User user, String homeName, Location homeLocation) {
        AsyncHomeTeleportEvent asyncHomeTeleportEvent = new AsyncHomeTeleportEvent(player, user, homeName, homeLocation);
        Bukkit.getPluginManager().callEvent((Event)asyncHomeTeleportEvent);
    }
}

