/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.epichomes.utils;

import me.loving11ish.epichomes.EpicHomes;
import me.loving11ish.epichomes.utils.ColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class MessageUtils {
    private static final ConsoleCommandSender console = Bukkit.getConsoleSender();
    public static String prefix = EpicHomes.getPlugin().getMessagesManager().getPrefix();
    private static boolean debug;
    private static String levelColor;

    public static void sendConsole(String message) {
        console.sendMessage(ColorUtils.translateColorCodes(prefix + " &r" + message));
    }

    public static void sendPlayer(Player player, String message) {
        player.sendMessage(ColorUtils.translateColorCodes(prefix + " &r" + message));
    }

    public static void sendPlayerNoPrefix(Player player, String message) {
        player.sendMessage(ColorUtils.translateColorCodes(message));
    }

    public static void sendOfflinePlayer(OfflinePlayer offlinePlayer, String message) {
        Player player = offlinePlayer.getPlayer();
        if (player != null) {
            player.sendMessage(ColorUtils.translateColorCodes(prefix + " &r" + message));
        } else {
            MessageUtils.sendConsole("&cPlayer &e" + offlinePlayer.getName() + " &cis not online! Message not sent.");
        }
    }

    public static void sendConsole(String level, String message) {
        level = MessageUtils.setDebugLevel(level);
        console.sendMessage(ColorUtils.translateColorCodes(prefix + " &r[" + level + "&r] - " + levelColor + message));
    }

    public static void sendDebugConsole(String message) {
        if (debug) {
            console.sendMessage(ColorUtils.translateColorCodes("&6EpicHomes-Debug&7: " + message));
        }
    }

    public static void sendDebugConsole(String level, String message) {
        if (debug) {
            level = MessageUtils.setDebugLevel(level);
            console.sendMessage(ColorUtils.translateColorCodes("&6EpicHomes-Debug&7: [" + level + "&7] - " + levelColor + message));
        }
    }

    public static void broadcastMessage(String message) {
        Bukkit.broadcastMessage((String)ColorUtils.translateColorCodes(prefix + " &l" + message));
    }

    public static void sendSender(CommandSender sender, String message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            MessageUtils.sendPlayer(player, message);
        } else {
            MessageUtils.sendConsole(message);
        }
    }

    public static void sendSender(CommandSender sender, String level, String message) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            MessageUtils.sendPlayer(player, message);
        } else {
            MessageUtils.sendConsole(level, message);
        }
    }

    private static String setDebugLevel(String level) {
        if (((String)level).equalsIgnoreCase("info")) {
            levelColor = "&a";
            level = levelColor + (String)level;
        } else if (((String)level).equalsIgnoreCase("warning")) {
            levelColor = "&e";
            level = levelColor + (String)level;
        } else if (((String)level).equalsIgnoreCase("error")) {
            levelColor = "&c";
            level = levelColor + (String)level;
        } else if (((String)level).equalsIgnoreCase("severe")) {
            levelColor = "&4";
            level = levelColor + (String)level;
        } else {
            levelColor = "&7";
            level = levelColor + (String)level;
        }
        return level;
    }

    public static void setDebug(boolean debug) {
        MessageUtils.debug = debug;
    }
}

